/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.vjet.dsf.javatojs.translate.AstBinding;
import org.eclipse.vjet.dsf.javatojs.translate.BaseTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.DataTypeTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.javatojs.translate.config.MethodKey;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomInfo;
import org.eclipse.vjet.dsf.javatojs.translate.custom.anno.IAnnoProcessor;
import org.eclipse.vjet.dsf.javatojs.util.AstBindingHelper;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstDoc;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstDoc;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.stmt.DispatchStmt;
import org.eclipse.vjet.dsf.jst.token.IStmt;

public class MethodTranslator
extends BaseTranslator {
    private static final String AMBIGUIOUS_ARGS = "Arguments of overlaod methods has ambiguity in JS";

    public JstMethod processMethod(MethodDeclaration astMtd, JstType jstType) {
        JstMethod jstMtd;
        TranslateCtx ctx = this.getCtx();
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(jstType);
        MethodKey mtdKey = MethodKey.genMethodKey(astMtd);
        String mtdName = astMtd.getName().toString();
        mtdName = this.getNameTranslator().processVarName(mtdName);
        CustomInfo cInfo = null;
        if (!tInfo.getMode().hasImplementation()) {
            for (IAnnoProcessor ap : ctx.getConfig().getAnnoProcessors()) {
                cInfo = ap.process((ASTNode)astMtd, jstType);
                if (cInfo == null || cInfo == CustomInfo.NONE) continue;
                tInfo.addMethodCustomInfo(mtdKey, cInfo);
            }
            if (!TranslateHelper.Method.includeMethodForDecl(astMtd, cInfo, jstType)) {
                return null;
            }
        } else if (!TranslateHelper.Method.includeMethodForImpl(astMtd, cInfo, jstType)) {
            return null;
        }
        if ((cInfo = tInfo.getMethodCustomInfo(mtdKey)) != null && !cInfo.isNone()) {
            jstMtd = tInfo.getRemovedMtds(mtdName).get(astMtd);
            if (jstMtd == null) {
                jstMtd = new JstMethod(mtdName, new JstArg[0]);
                jstMtd.setParent((IJstNode)jstType);
                jstMtd.setSource(new JstSource((JstSource.IBinding)new AstBinding((ASTNode)astMtd)));
                this.processMethodDecl(astMtd, jstMtd, cInfo);
                tInfo.addRemovedMtd(astMtd, jstMtd);
            }
            return jstMtd;
        }
        jstMtd = null;
        if (!tInfo.getStatus().isDeclTranlationDone()) {
            jstMtd = new JstMethod(mtdName, new JstArg[0]);
            jstMtd.setParent((IJstNode)jstType);
            jstMtd.setSource(new JstSource((JstSource.IBinding)new AstBinding((ASTNode)astMtd)));
            this.processMethodDecl(astMtd, jstMtd, cInfo);
        }
        if (cInfo != null && (cInfo.isJavaOnly() || cInfo.isJSProxy())) {
            return jstMtd;
        }
        if (tInfo.getMode().hasImplementation()) {
            jstMtd = (JstMethod)TranslateHelper.Method.getMethod(astMtd, jstType);
            if (jstMtd == null) {
                if (!(this.getCtx().isJavaOnly((IJstType)jstType) || cInfo != null && cInfo.isExcluded())) {
                    this.getLogger().logError("NullResult", "failed to translate method '" + astMtd.getName().toString() + "'", this, (ASTNode)astMtd, (BaseJstNode)jstType);
                }
                return null;
            }
            IJstType rtnType = jstMtd.getRtnType();
            if (rtnType != null) {
                TranslateHelper.Type.validateTypeReference(rtnType, (ASTNode)astMtd.getReturnType2(), (BaseJstNode)jstMtd, (BaseJstNode)jstType, this);
            }
            for (JstArg jstArg : jstMtd.getArgs()) {
                IJstType pType = jstArg.getType();
                if (pType == null) continue;
                TranslateHelper.Type.validateTypeReference(pType, (ASTNode)astMtd.getReturnType2(), (BaseJstNode)jstMtd, (BaseJstNode)jstType, this);
            }
            if (tInfo.clearTypeRefs()) {
                this.processMethodSigniture(astMtd, jstMtd);
            }
            this.processMethodImpl(astMtd, jstMtd);
        }
        return jstMtd;
    }

    private void processMethodDecl(MethodDeclaration astMtd, JstMethod jstMtd, CustomInfo cInfo) {
        JstType jstType = jstMtd.getOwnerType();
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(jstType);
        String mtdName = astMtd.getName().toString();
        mtdName = this.getNameTranslator().processVarName(mtdName);
        boolean isStatic = TranslateHelper.isStatic(astMtd.modifiers());
        for (IJstProperty p : jstType.getProperties()) {
            if (!p.getName().getName().equals(mtdName)) continue;
            this.getLogger().logError("Duplicate method or filed name", "Method name is same as other field: ", this, (ASTNode)astMtd, (BaseJstNode)jstType);
        }
        this.processMethodJavadoc(astMtd, jstMtd);
        this.processMethodSigniture(astMtd, jstMtd);
        JstModifiers modifiers = jstMtd.getModifiers();
        for (Object m : astMtd.modifiers()) {
            if (m instanceof Modifier) {
                modifiers.merge(((Modifier)m).getKeyword().toFlagValue());
                continue;
            }
            if (m instanceof Annotation) {
                this.getOtherTranslator().processAnnotation((Annotation)m, (BaseJstNode)jstMtd);
                continue;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)m, (BaseJstNode)jstMtd);
        }
        if (jstType.isInterface()) {
            modifiers.setPublic();
        }
        if (cInfo != null && !cInfo.isNone()) {
            jstType.addMethod((IJstMethod)jstMtd);
            return;
        }
        JstMethod firstOne = null;
        MethodKey mtdKey = null;
        if (astMtd.isConstructor()) {
            mtdName = "constructs";
            jstMtd.setName(mtdName);
            jstMtd.setIsConstructor(true);
            firstOne = jstType.getConstructor();
            if (tInfo.isOverloaded(mtdName, isStatic)) {
                if (this.hasArgConflict(tInfo.getOverloaded(mtdName, isStatic), jstMtd)) {
                    this.getLogger().logError("InvalidArgs", AMBIGUIOUS_ARGS, this, (ASTNode)astMtd, (BaseJstNode)jstType);
                }
                tInfo.addOverloaded(jstMtd);
                jstType.addMethod((IJstMethod)jstMtd);
                this.addDispatching(jstMtd, jstType);
            } else if (firstOne != null) {
                if (this.hasArgConflict((IJstMethod)firstOne, jstMtd)) {
                    this.getLogger().logError("InvalidArgs", AMBIGUIOUS_ARGS, this, (ASTNode)astMtd, (BaseJstNode)jstType);
                }
                jstType.setConstructor(null);
                tInfo.addOverloaded(firstOne);
                tInfo.addOverloaded(jstMtd);
                JstMethod dispatcher = this.addDispatching(firstOne, jstType);
                jstType.setConstructor(dispatcher);
                this.addDispatching(jstMtd, jstType);
                jstType.addMethod((IJstMethod)firstOne);
                jstType.addMethod((IJstMethod)jstMtd);
            } else {
                jstType.setConstructor(jstMtd);
            }
        } else {
            for (IJstMethod m : jstType.getMethods(isStatic)) {
                if (!mtdName.equals(m.getName().getName())) continue;
                mtdKey = MethodKey.genMethodKey(AstBindingHelper.getAstMethod(m));
                CustomInfo c = tInfo.getMethodCustomInfo(mtdKey);
                if (!(m instanceof JstMethod) || !c.isNone()) continue;
                firstOne = (JstMethod)m;
                break;
            }
            if (tInfo.isOverloaded(mtdName, TranslateHelper.isStatic(astMtd.modifiers()))) {
                if (this.hasArgConflict(tInfo.getOverloaded(mtdName, isStatic), jstMtd)) {
                    this.getLogger().logError("InvalidArgs", AMBIGUIOUS_ARGS, this, (ASTNode)astMtd, (BaseJstNode)jstType);
                }
                tInfo.addOverloaded(jstMtd);
                jstType.addMethod((IJstMethod)jstMtd);
                this.addDispatching(jstMtd, jstType);
            } else if (firstOne != null) {
                if (this.hasArgConflict((IJstMethod)firstOne, jstMtd)) {
                    this.getLogger().logError("InvalidArgs", AMBIGUIOUS_ARGS, this, (ASTNode)astMtd, (BaseJstNode)jstType);
                }
                jstType.removeMethod(mtdName, isStatic);
                tInfo.addOverloaded(firstOne);
                tInfo.addOverloaded(jstMtd);
                JstMethod dispatcher = this.addDispatching(firstOne, jstType);
                jstType.addMethod((IJstMethod)dispatcher);
                this.addDispatching(jstMtd, jstType);
                jstType.addMethod((IJstMethod)firstOne);
                jstType.addMethod((IJstMethod)jstMtd);
            } else {
                jstType.addMethod((IJstMethod)jstMtd);
            }
        }
    }

    private void processMethodJavadoc(MethodDeclaration astMtd, JstMethod jstMtd) {
        Javadoc javadoc = astMtd.getJavadoc();
        if (javadoc == null) {
            return;
        }
        JstDoc jstDoc = new JstDoc(javadoc.toString());
        jstMtd.setDoc((IJstDoc)jstDoc);
    }

    private void processMethodSigniture(MethodDeclaration astMtd, JstMethod jstMtd) {
        JstType jstType = jstMtd.getOwnerType();
        DataTypeTranslator typeTranslator = this.getDataTypeTranslator();
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(jstType);
        List params = astMtd.typeParameters();
        for (TypeParameter p : params) {
            JstParamType pType = jstMtd.addParam(p.getName().toString());
            if (pType == null) continue;
            for (Object b : p.typeBounds()) {
                if (!(b instanceof Type)) continue;
                pType.addBound(this.getDataTypeTranslator().processType((Type)b, (BaseJstNode)jstMtd));
            }
        }
        if (tInfo.getStatus().isDeclTranlationDone() && tInfo.clearTypeRefs()) {
            jstMtd.removeArgs();
        }
        for (Object p : astMtd.parameters()) {
            if (p instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration sv = (SingleVariableDeclaration)p;
                sv.getModifiers();
                String name = this.getNameTranslator().processVarName(sv.getName(), (BaseJstNode)jstMtd.getBlock(true));
                IJstType type = typeTranslator.processType(sv.getType(), (BaseJstNode)jstMtd);
                if (sv.getExtraDimensions() > 0) {
                    int i = 0;
                    while (i < sv.getExtraDimensions()) {
                        type = JstFactory.getInstance().createJstArrayType(type, true);
                        ++i;
                    }
                }
                JstArg jstArg = new JstArg(type, name, sv.isVarargs(), false, sv.getModifiers() == 16);
                jstArg.setSource(new JstSource((JstSource.IBinding)new AstBinding((ASTNode)sv.getType())));
                if (sv.isVarargs()) {
                    type = JstFactory.getInstance().createJstArrayType(type, false);
                }
                jstMtd.getBlock(true).getVarTable().addVarType(name, type);
                jstMtd.addArg(jstArg);
                continue;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)p, (BaseJstNode)jstMtd);
        }
        Type rtnType = astMtd.getReturnType2();
        if (rtnType != null) {
            jstMtd.setRtnType(typeTranslator.processType(rtnType, (BaseJstNode)jstMtd));
        }
    }

    private void processMethodImpl(MethodDeclaration astMtd, JstMethod jstMtd) {
        Block body = astMtd.getBody();
        if (body != null) {
            if (!this.getCustomTranslator().processMethodBody(astMtd, jstMtd)) {
                this.getOtherTranslator().processBlock(body, jstMtd.getBlock(true));
            }
            this.checkAndProcessBaseOverload(astMtd, jstMtd);
        }
    }

    private void checkAndProcessBaseOverload(MethodDeclaration astMtd, JstMethod jstMtd) {
        JstType jstType = jstMtd.getOwnerType();
        IJstType extend = jstType.getExtend();
        boolean hasSuperOverload = false;
        String mtdName = jstMtd.getOriginalName();
        while (extend != null && !"vjo.Object".equals(extend.getName())) {
            if (hasSuperOverload) break;
            IJstMethod m = extend.getMethod(mtdName, false);
            boolean isOverride = false;
            if (m != null) {
                List args1 = m.getArgs();
                List args2 = jstMtd.getArgs();
                if (args1.size() == args2.size()) {
                    if (args1.size() == 0) {
                        isOverride = true;
                    } else {
                        int i = 0;
                        while (i < args1.size()) {
                            if (!((JstArg)args1.get(i)).getType().getName().equals(((JstArg)args2.get(i)).getType().getName())) {
                                isOverride = false;
                                break;
                            }
                            isOverride = true;
                            ++i;
                        }
                    }
                }
            }
            hasSuperOverload = m != null && !m.isAbstract() && !jstMtd.isStatic() && (!isOverride || m.getOverloaded().size() != 0);
            extend = extend.getExtend();
        }
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(jstType);
        boolean isOverloaded = tInfo.isOverloaded(mtdName, TranslateHelper.isStatic(astMtd.modifiers()));
        boolean isConstructor = jstMtd.isConstructor();
        if (hasSuperOverload && !isConstructor && !isOverloaded) {
            jstType.removeMethod(jstMtd.getOriginalName(), false);
            JstMethod dispatcher = this.addDispatching(jstMtd, jstType);
            jstType.addMethod((IJstMethod)dispatcher);
            jstType.addMethod((IJstMethod)jstMtd);
            tInfo.addOverloaded(jstMtd);
        }
    }

    private JstMethod addDispatching(JstMethod jstMtd, JstType jstType) {
        JstMethod dispatcher;
        MethodDeclaration astMtd = (MethodDeclaration)AstBindingHelper.getAstNode((IJstNode)jstMtd);
        if (astMtd == null) {
            this.getLogger().logError("NullInput", "astMtd is null for " + jstMtd.getName(), this, AstBindingHelper.getAstNode((IJstNode)jstType), (BaseJstNode)jstType);
            return jstMtd;
        }
        String mtdName = astMtd.getName().toString();
        mtdName = this.getNameTranslator().processVarName(mtdName);
        if (astMtd.isConstructor()) {
            mtdName = "constructs";
            dispatcher = jstType.getConstructor();
        } else {
            dispatcher = (JstMethod)jstType.getMethod(mtdName, jstMtd.isStatic());
        }
        if (dispatcher == null) {
            if (astMtd.isConstructor()) {
                dispatcher = new JstMethod(mtdName, new JstArg[0]).setIsConstructor(true);
            } else {
                dispatcher = new JstMethod(mtdName, jstMtd.getRtnType(), new JstArg[0]);
                for (JstArg arg : jstMtd.getArgs()) {
                    dispatcher.addArg(arg);
                }
            }
            dispatcher.setParent((IJstNode)jstType);
        }
        dispatcher.addOverloaded(jstMtd);
        DispatchStmt dispatchStmt = null;
        JstBlock body = dispatcher.getBlock(true);
        if (dispatcher.getBlock(true).getStmts().isEmpty()) {
            dispatchStmt = new DispatchStmt();
            body.addStmt((IStmt)dispatchStmt);
        } else {
            for (IStmt s : body.getStmts()) {
                if (!(s instanceof DispatchStmt)) continue;
                dispatchStmt = (DispatchStmt)s;
                break;
            }
        }
        if (dispatchStmt != null) {
            dispatchStmt.addMethod(jstMtd);
        }
        dispatcher.getModifiers().merge(astMtd.getModifiers());
        return dispatcher;
    }

    private boolean isPrimitiveNumeric(String type) {
        return type.equals("int") || type.equals("float") || type.equals("byte") || type.equals("short") || type.equals("double") || type.equals("long");
    }

    private boolean isMappedToStringInJs(String type) {
        return type.equals("char") || type.equals("String");
    }

    private boolean hasArgConflict(Map<Integer, List<JstMethod>> jstMtds, JstMethod jstMtd) {
        if (TranslateCtx.ctx().isJSProxy((IJstType)jstMtd.getRootType())) {
            return false;
        }
        for (List<JstMethod> list : jstMtds.values()) {
            for (IJstMethod iJstMethod : list) {
                if (!this.hasArgConflict(iJstMethod, jstMtd)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasArgConflict(IJstMethod jstMtd1, JstMethod jstMtd2) {
        if (TranslateCtx.ctx().isJSProxy((IJstType)jstMtd2.getRootType())) {
            return false;
        }
        List argsFirst = jstMtd1.getArgs();
        List args = jstMtd2.getArgs();
        if (argsFirst.size() != args.size()) {
            return false;
        }
        int i = 0;
        while (i < args.size()) {
            if (argsFirst.get(i) == null || args.get(i) == null || ((JstArg)argsFirst.get(i)).getType() == null || ((JstArg)args.get(i)).getType() == null) {
                this.getLogger().logError("NullResult", "arg or arg type is null", this, AstBindingHelper.getAstNode((IJstNode)jstMtd2), (BaseJstNode)jstMtd2);
            } else {
                IJstType type1 = ((JstArg)argsFirst.get(i)).getType();
                IJstType type2 = ((JstArg)args.get(i)).getType();
                if (!(this.isPrimitiveNumeric(type1.getName()) && this.isPrimitiveNumeric(type2.getName()) || type1 instanceof JstArray && type2 instanceof JstArray || this.isMappedToStringInJs(type1.getName()) && this.isMappedToStringInJs(type2.getName()))) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

