/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.vjet.dsf.javatojs.translate.BaseTranslator;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.datatype.JstReservedTypes;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.VarTable;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;

public class LiteralTranslator
extends BaseTranslator {
    SimpleLiteral toJstLiteral(NumberLiteral astExpr, BaseJstNode jstNode) {
        String actType;
        String literal = astExpr.toString();
        String typeName = "";
        typeName = (literal.endsWith("f") || literal.endsWith("F")) && !literal.startsWith("0x") && !literal.startsWith("0X") ? "float" : ((literal.endsWith("d") || literal.endsWith("D")) && !literal.startsWith("0x") && !literal.startsWith("0X") ? "double" : (literal.endsWith("l") || literal.endsWith("L") ? "long" : (literal.contains(".") ? ((actType = this.getTypeName(astExpr)) != null ? actType : "float") : "int")));
        ASTNode ast = astExpr.getParent();
        VarTable varTable = null;
        if (ast instanceof VariableDeclarationFragment) {
            IJstType type;
            VariableDeclarationFragment o = (VariableDeclarationFragment)ast;
            SimpleName n = o.getName();
            if (jstNode instanceof JstType) {
                JstType jstType = (JstType)jstNode;
                varTable = jstType.getVarTable();
            }
            if (jstNode instanceof JstBlock) {
                JstBlock jstBlock = (JstBlock)jstNode;
                varTable = jstBlock.getVarTable();
            }
            String name = this.getNameTranslator().processVarName(n, jstNode);
            if (varTable != null && !(type = varTable.getVarType(name)).getSimpleName().equals("Object")) {
                typeName = type.getSimpleName();
            }
        }
        if (typeName.equals("int")) {
            return SimpleLiteral.getIntegerLiteral((String)literal);
        }
        if (typeName.equals("Integer")) {
            return SimpleLiteral.getIntegerLiteral((String)literal);
        }
        if (typeName.equals("Long") || typeName.equals("long")) {
            return SimpleLiteral.getLongLiteral((String)literal);
        }
        if (typeName.equals("short") || typeName.equals("Short")) {
            return SimpleLiteral.getShortLiteral((String)literal);
        }
        if (typeName.equals("byte") || typeName.equals("Byte")) {
            return SimpleLiteral.getByteLiteral((String)literal);
        }
        if (typeName.equals("float") || typeName.equals("Float")) {
            return SimpleLiteral.getFloatLiteral((String)literal);
        }
        return SimpleLiteral.getDoubleLiteral((String)literal);
    }

    SimpleLiteral toJstLiteral(CharacterLiteral literal) {
        String esval = literal.getEscapedValue();
        esval = esval.substring(1, esval.length() - 1);
        return SimpleLiteral.getCharLiteral((String)esval);
    }

    SimpleLiteral toJstLiteral(BooleanLiteral literal) {
        return SimpleLiteral.getBooleanLiteral((boolean)literal.booleanValue());
    }

    SimpleLiteral toJstLiteral(StringLiteral literal) {
        String s = literal.toString();
        return SimpleLiteral.getStringLiteral((String)s.substring(1, s.length() - 1));
    }

    SimpleLiteral toJstLiteral(TypeLiteral literal) {
        String s = literal.toString();
        return new SimpleLiteral(Object.class, (IJstType)JstReservedTypes.JsNative.OBJECT, s);
    }

    SimpleLiteral toJstLiteral(NullLiteral literal) {
        return new SimpleLiteral(Object.class, (IJstType)JstReservedTypes.JsNative.OBJECT, null);
    }

    private String getTypeName(NumberLiteral astExpr) {
        Type type;
        Expression expr;
        ASTNode parent = astExpr.getParent();
        if (parent instanceof MethodInvocation && "equals".equals(((MethodInvocation)parent).getName().toString()) && (expr = ((MethodInvocation)parent).getExpression()) instanceof ClassInstanceCreation && (type = ((ClassInstanceCreation)expr).getType()) != null) {
            if ("Double".equals(type.toString())) {
                return "double";
            }
            if ("Float".equals(type.toString())) {
                return "float";
            }
            if ("Long".equals(type.toString())) {
                return "long";
            }
        }
        return null;
    }
}

