/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.trace;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.vjet.dsf.common.trace.handler.TraceFileHandler;
import org.eclipse.vjet.dsf.common.trace.handler.TraceFormatter;
import org.eclipse.vjet.dsf.common.trace.listener.ITraceEventListener;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.common.xml.XmlStreamWriter;
import org.eclipse.vjet.dsf.javatojs.trace.ITranslateTracer;
import org.eclipse.vjet.dsf.javatojs.trace.TraceTime;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateTraceListener;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateTracer;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;

public class TranslateTraceMgr {
    private TranslateCtx m_ctx;
    private ITranslateTracer m_tracer;
    private List<ITraceEventListener> m_listeners = new ArrayList<ITraceEventListener>();
    private XmlStreamWriter m_writer = new XmlStreamWriter((Writer)new StringWriter(), IIndenter.COMPACT);
    private static Logger s_logger;
    private static final String FILE_PREFIX = "v4trace";
    private static final String FILE_EXTENSION = ".xml";
    private static final int FILE_MAX_SIZE = 10000000;
    private static final int FILE_MAX_COUT = 10;
    private static List<String> s_initializedLoggers;

    static {
        s_initializedLoggers = new ArrayList<String>(5);
    }

    public TranslateTraceMgr(TranslateCtx ctx) {
        this.m_ctx = ctx;
    }

    public TranslateTraceMgr addTraceListener(ITraceEventListener listener) {
        if (listener == null || this.m_listeners.contains(listener)) {
            return this;
        }
        this.m_listeners.add(listener);
        return this;
    }

    public void setTracer(ITranslateTracer tracer) {
        this.m_tracer = tracer;
    }

    public ITranslateTracer getTracer() {
        if (this.m_ctx.isTraceEnabled()) {
            return this.getTracer(true);
        }
        return TranslateTracer.NO_OP;
    }

    public ITranslateTracer getTracer(StringWriter writer) {
        if (this.m_ctx.isTraceEnabled()) {
            return this.createTracer(new XmlStreamWriter((Writer)writer));
        }
        return TranslateTracer.NO_OP;
    }

    public TraceTime getTimer() {
        if (this.m_ctx.isTraceEnabled()) {
            return new TraceTime();
        }
        return TraceTime.NO_OP_TIMER;
    }

    public void close() {
        if (this.m_tracer == null) {
            return;
        }
        this.m_writer.writeEndElement();
        this.m_tracer.close();
        String xml = this.m_writer.toString();
        this.getLogger().log(Level.INFO, xml);
        Handler[] handlerArray = this.getLogger().getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler h = handlerArray[n2];
            try {
                h.close();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        this.m_tracer = null;
    }

    public void append(String trace) {
        this.m_writer.writeRaw(trace);
    }

    private ITranslateTracer getTracer(boolean create) {
        if (this.m_tracer == null && create) {
            this.m_tracer = this.createTracer(this.m_writer);
            this.m_writer.writeStartElement("JavaToJst");
        }
        return this.m_tracer;
    }

    private ITranslateTracer createTracer(XmlStreamWriter writer) {
        TranslateTracer tracer = new TranslateTracer();
        tracer.addListener(new TranslateTraceListener(writer));
        for (ITraceEventListener l : this.m_listeners) {
            tracer.addListener(l);
        }
        return tracer;
    }

    public Logger getLogger() {
        if (s_logger == null) {
            try {
                s_logger = TranslateTraceMgr.createDefaultLogger("org.eclipse.vjet.dsf.common.tracer.TraceManager", (Formatter)new TraceFormatter(), 10);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return s_logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Logger createDefaultLogger(String scope, Formatter formatter, int maxFileCount) {
        String fileName = "v4trace.xml";
        Logger logger = Logger.getLogger(scope);
        Class<TranslateTraceMgr> clazz = TranslateTraceMgr.class;
        synchronized (TranslateTraceMgr.class) {
            if (s_initializedLoggers.contains(scope)) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return logger;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            logger.setLevel(Level.INFO);
            Handler[] handlerArray = logger.getHandlers();
            int n = handlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Handler h = handlerArray[n2];
                if (h instanceof ConsoleHandler) {
                    logger.removeHandler(h);
                }
                ++n2;
            }
            try {
                TraceFileHandler fileHandler = new TraceFileHandler(fileName, 10000000, maxFileCount, true);
                fileHandler.setFormatter(formatter);
                fileHandler.setLevel(Level.ALL);
                logger.addHandler((Handler)fileHandler);
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {}
            clazz = TranslateTraceMgr.class;
            synchronized (TranslateTraceMgr.class) {
                s_initializedLoggers.add(scope);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return logger;
            }
        }
    }
}

