/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.wizards;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.wizards.Messages;
import org.eclipse.dltk.mod.ui.wizards.NewElementWizard;
import org.eclipse.dltk.mod.ui.wizards.NewSourceModulePage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;

public abstract class NewSourceModuleWizard
extends NewElementWizard {
    private NewSourceModulePage page;
    private ISourceModule module;

    protected abstract NewSourceModulePage createNewSourceModulePage();

    public void addPages() {
        super.addPages();
        this.page = this.createNewSourceModulePage();
        this.page.init(this.getSelection());
        this.addPage((IWizardPage)this.page);
    }

    @Override
    public IModelElement getCreatedElement() {
        return this.module;
    }

    @Override
    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.module = this.page.createFile(monitor);
    }

    @Override
    public boolean performFinish() {
        boolean result = super.performFinish();
        if (result && this.module != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        EditorUtility.openInEditor(NewSourceModuleWizard.this.module);
                    }
                    catch (PartInitException e) {
                        DLTKUIPlugin.logErrorMessage(MessageFormat.format(Messages.NewSourceModuleWizard_errorInOpenInEditor, NewSourceModuleWizard.this.module.getElementName()), e);
                    }
                    catch (ModelException e) {
                        DLTKUIPlugin.logErrorMessage(MessageFormat.format(Messages.NewSourceModuleWizard_errorInOpenInEditor, NewSourceModuleWizard.this.module.getElementName()), e);
                    }
                }
            });
        }
        return result;
    }
}

