/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.viewsupport;

import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class MemberFilter
extends ViewerFilter {
    public static final int FILTER_NONPUBLIC = 1;
    public static final int FILTER_STATIC = 2;
    public static final int FILTER_FIELDS = 4;
    public static final int FILTER_LOCALTYPES = 8;
    private int fFilterProperties;

    public final void addFilter(int filter) {
        this.fFilterProperties |= filter;
    }

    public final void removeFilter(int filter) {
        this.fFilterProperties &= 0xFFFFFFFF ^ filter;
    }

    public final boolean hasFilter(int filter) {
        return (this.fFilterProperties & filter) != 0;
    }

    public boolean isFilterProperty(Object element, Object property) {
        return false;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            int memberType = member.getElementType();
            if (this.hasFilter(4) && memberType == 8) {
                return false;
            }
            if (this.hasFilter(8) && memberType == 7 && this.isLocalType((IType)member)) {
                return false;
            }
            if (member.getElementName().startsWith("<")) {
                return false;
            }
        }
        return true;
    }

    private boolean isLocalType(IType type) {
        IModelElement parent = type.getParent();
        return parent instanceof IMember && !(parent instanceof IType);
    }
}

