/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.editor.highlighting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.ui.editor.highlighting.HighlightedPosition;
import org.eclipse.dltk.mod.ui.editor.highlighting.HighlightingStyle;
import org.eclipse.dltk.mod.ui.editor.highlighting.IHighlightedPositionFactory;
import org.eclipse.dltk.mod.ui.editor.highlighting.ISemanticHighlighter;
import org.eclipse.dltk.mod.ui.editor.highlighting.ISemanticHighlightingRequestor;
import org.eclipse.jface.text.Position;

public abstract class AbstractSemanticHighlighter
implements ISemanticHighlighter,
ISemanticHighlightingRequestor {
    private IHighlightedPositionFactory positionFactory;
    private HighlightingStyle[] highlightingStyles;
    private final List newPositions = new ArrayList();
    private int oldPositionCount = 0;
    private final List oldPositions = new ArrayList();
    private static final boolean DEBUG = false;

    @Override
    public void initialize(IHighlightedPositionFactory factory, HighlightingStyle[] styles) {
        this.positionFactory = factory;
        this.highlightingStyles = styles;
    }

    @Override
    public ISemanticHighlighter.UpdateResult reconcile(ISourceModule code, List currentPositions) {
        try {
            this.newPositions.clear();
            this.oldPositionCount = currentPositions.size();
            this.oldPositions.clear();
            this.oldPositions.addAll(currentPositions);
            if (this.doHighlighting(code)) {
                this.checkNewPositionOrdering();
                HighlightedPosition[] removed = this.getRemovedPositions();
                return new ISemanticHighlighter.UpdateResult(this.getAddedPositions(), removed);
            }
        }
        catch (Exception e) {
            DLTKCore.error((String)"Error in SemanticPositionUpdater", (Throwable)e);
        }
        return new ISemanticHighlighter.UpdateResult(HighlightedPosition.NO_POSITIONS, HighlightedPosition.NO_POSITIONS);
    }

    protected abstract boolean doHighlighting(ISourceModule var1) throws Exception;

    @Override
    public void addPosition(int start, int end, int highlightingIndex) {
        HighlightedPosition p;
        int len = end - start;
        if (len <= 0) {
            return;
        }
        HighlightingStyle hl = this.highlightingStyles[highlightingIndex];
        int i = 0;
        int size = this.oldPositions.size();
        while (i < size) {
            p = (HighlightedPosition)((Object)this.oldPositions.get(i));
            if (p != null && p.isEqual(start, len, hl)) {
                this.oldPositions.set(i, null);
                --this.oldPositionCount;
                return;
            }
            ++i;
        }
        if (!this.newPositions.isEmpty()) {
            int lowBound = Math.max(this.newPositions.size() - 2, 0);
            int i2 = this.newPositions.size();
            while (--i2 >= lowBound) {
                p = (HighlightedPosition)((Object)this.newPositions.get(i2));
                if (!p.isEqual(start, len, hl)) continue;
                return;
            }
        }
        HighlightedPosition hp = this.positionFactory.createHighlightedPosition(start, len, hl);
        this.newPositions.add(hp);
    }

    protected HighlightedPosition[] getAddedPositions() {
        HighlightedPosition[] result = new HighlightedPosition[this.newPositions.size()];
        this.newPositions.toArray(result);
        return result;
    }

    protected HighlightedPosition[] getRemovedPositions() {
        HighlightedPosition[] result = new HighlightedPosition[this.oldPositionCount];
        int index = 0;
        int i = 0;
        int size = this.oldPositions.size();
        while (i < size) {
            HighlightedPosition p = (HighlightedPosition)((Object)this.oldPositions.get(i));
            if (p != null) {
                result[index++] = p;
            }
            ++i;
        }
        return result;
    }

    protected void checkNewPositionOrdering() {
        if (this.newPositions.isEmpty()) {
            return;
        }
        Collections.sort(this.newPositions, new Comparator(){

            public int compare(Object o1, Object o2) {
                Position p1 = (Position)o1;
                Position p2 = (Position)o2;
                return p1.getOffset() - p2.getOffset();
            }
        });
        Position previous = null;
        Iterator i = this.newPositions.iterator();
        while (i.hasNext()) {
            Position current = (Position)i.next();
            if (previous != null && previous.getOffset() + previous.getLength() > current.getOffset()) {
                i.remove();
                continue;
            }
            previous = current;
        }
    }
}

