/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.actions;

import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IField;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IPackageDeclaration;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.mod.internal.ui.search.SearchMessages;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.actions.FindAction;
import org.eclipse.dltk.mod.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.mod.ui.search.QuerySpecification;
import org.eclipse.ui.IWorkbenchSite;

public abstract class FindReferencesAction
extends FindAction {
    public FindReferencesAction(IWorkbenchSite site) {
        super(site);
    }

    public FindReferencesAction(ScriptEditor editor) {
        super(editor);
    }

    @Override
    Class[] getValidTypes() {
        return new Class[]{ISourceModule.class, IType.class, IMethod.class, IField.class, IPackageDeclaration.class, IScriptFolder.class};
    }

    @Override
    void init() {
        this.setText(SearchMessages.Search_FindReferencesAction_label);
        this.setToolTipText(SearchMessages.Search_FindReferencesAction_tooltip);
        this.setImageDescriptor(DLTKPluginImages.DESC_OBJS_SEARCH_REF);
        if (DLTKCore.DEBUG) {
            System.out.println("TODO: Add help support here...");
        }
    }

    @Override
    int getLimitTo() {
        return 1;
    }

    @Override
    QuerySpecification createQuery(IModelElement element) throws ModelException {
        DLTKSearchScopeFactory factory = DLTKSearchScopeFactory.getInstance();
        boolean isInsideInterpreterEnvironment = factory.isInsideInterpreter(element);
        IDLTKSearchScope scope = factory.createWorkspaceScope(isInsideInterpreterEnvironment, this.getLanguageToolkit());
        String description = factory.getWorkspaceScopeDescription(isInsideInterpreterEnvironment);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }

    @Override
    public void run(IModelElement element) {
        super.run(element);
    }
}

