/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.dltk.mod.internal.ui.search.SearchMessages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.search.IQueryParticipant;

public class SearchParticipantDescriptor {
    private static final String CLASS = "class";
    private static final String NATURE = "nature";
    private static final String ID = "id";
    private IConfigurationElement fConfigurationElement;
    private boolean fEnabled;

    protected SearchParticipantDescriptor(IConfigurationElement configElement) {
        this.fConfigurationElement = configElement;
        this.fEnabled = true;
    }

    protected IStatus checkSyntax() {
        if (this.fConfigurationElement.getAttribute(ID) == null) {
            String format = SearchMessages.SearchParticipant_error_noID;
            String message = Messages.format(format, new String[]{this.fConfigurationElement.getDeclaringExtension().getUniqueIdentifier()});
            return new Status(4, DLTKUIPlugin.getPluginId(), 0, message, null);
        }
        if (this.fConfigurationElement.getAttribute(NATURE) == null) {
            String format = SearchMessages.SearchParticipant_error_noNature;
            String message = Messages.format(format, new String[]{this.fConfigurationElement.getAttribute(ID)});
            return new Status(4, DLTKUIPlugin.getPluginId(), 0, message, null);
        }
        if (this.fConfigurationElement.getAttribute(CLASS) == null) {
            String format = SearchMessages.SearchParticipant_error_noClass;
            String message = Messages.format(format, new String[]{this.fConfigurationElement.getAttribute(ID)});
            return new Status(4, DLTKUIPlugin.getPluginId(), 0, message, null);
        }
        return Status.OK_STATUS;
    }

    public String getID() {
        return this.fConfigurationElement.getAttribute(ID);
    }

    public void disable() {
        this.fEnabled = false;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    protected IQueryParticipant create() throws CoreException {
        try {
            return (IQueryParticipant)this.fConfigurationElement.createExecutableExtension(CLASS);
        }
        catch (ClassCastException e) {
            throw new CoreException((IStatus)new Status(4, DLTKUIPlugin.getPluginId(), 0, SearchMessages.SearchParticipant_error_classCast, (Throwable)e));
        }
    }

    protected String getNature() {
        return this.fConfigurationElement.getAttribute(NATURE);
    }
}

