/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IExternalSourceModule;
import org.eclipse.dltk.mod.core.IForeignElement;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ISourceRange;
import org.eclipse.dltk.mod.core.ISourceReference;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.ScriptModelUtil;
import org.eclipse.dltk.mod.internal.core.JSSourceType;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.dltk.mod.internal.ui.editor.DLTKEditorMessages;
import org.eclipse.dltk.mod.internal.ui.editor.ExternalFileEditorInput;
import org.eclipse.dltk.mod.internal.ui.editor.ExternalStorageEditorInput;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.ui.DLTKUILanguageManager;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.IDLTKUILanguageToolkit;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class EditorUtility {
    private static String nativeTypeName = "";
    static List nativeGlobalObjects = new ArrayList();

    static {
        nativeGlobalObjects.add("Array");
        nativeGlobalObjects.add("Boolean");
        nativeGlobalObjects.add("Date");
        nativeGlobalObjects.add("Error");
        nativeGlobalObjects.add("EvalError");
        nativeGlobalObjects.add("Function");
        nativeGlobalObjects.add("Math");
        nativeGlobalObjects.add("Number");
        nativeGlobalObjects.add("Object");
        nativeGlobalObjects.add("RangeError");
        nativeGlobalObjects.add("ReferenceError");
        nativeGlobalObjects.add("RegExp");
        nativeGlobalObjects.add("String");
        nativeGlobalObjects.add("SyntaxError");
        nativeGlobalObjects.add("TypeError");
        nativeGlobalObjects.add("URIError");
        nativeGlobalObjects.add("Window");
        nativeGlobalObjects.add("Global");
        nativeGlobalObjects.add("Object");
    }

    public static IScriptProject getScriptProject(IEditorInput input) {
        IScriptProject project;
        IModelElement element;
        IScriptProject dProject = null;
        if (input instanceof IFileEditorInput) {
            IProject project2 = ((IFileEditorInput)input).getFile().getProject();
            if (project2 != null && !(dProject = DLTKCore.create((IProject)project2)).exists()) {
                dProject = null;
            }
        } else if (input instanceof ExternalStorageEditorInput && (element = (IModelElement)input.getAdapter(IModelElement.class)) != null && (project = element.getScriptProject()) != null && project.exists()) {
            return project;
        }
        return dProject;
    }

    public static ISourceModule getEditorInputModelElement(IEditorPart editor, boolean primaryOnly) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        ISourceModule je = DLTKUIPlugin.getEditorInputModelElement(editorInput);
        if (je != null || primaryOnly) {
            return je;
        }
        return DLTKUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput, primaryOnly);
    }

    private static IFileEditorInput generateTempNativeType(String containerName, String fileName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path("/"));
        IProject[] projects = root.getProjects();
        if (!resource.exists() || !(resource instanceof IContainer) || projects.length == 0) {
            return null;
        }
        IFolder folder = projects[0].getFolder(".nativeType");
        if (!folder.exists()) {
            try {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        IFile file = folder.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = EditorUtility.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                file.create(stream, true, (IProgressMonitor)new NullProgressMonitor());
            }
            stream.close();
        }
        catch (IOException iOException) {}
        return new FileEditorInput(file);
    }

    private static InputStream openContentStream() {
        String contents = "/* my test only the name gets by varaible,\n other infromation is hard code. */\n";
        contents = String.valueOf(contents) + "vjo.ctype('" + nativeTypeName + "') //< public\n";
        contents = String.valueOf(contents) + ".props({\n";
        contents = String.valueOf(contents) + "    //> public void main(String[] args)\n";
        contents = String.valueOf(contents) + "    //> " + nativeTypeName + " main()\n";
        contents = String.valueOf(contents) + "    main:function(args){\n";
        contents = String.valueOf(contents) + "        \n";
        contents = String.valueOf(contents) + "    }\n";
        contents = String.valueOf(contents) + "})\n";
        contents = String.valueOf(contents) + ".endType();\n";
        return new ByteArrayInputStream(contents.getBytes());
    }

    public static IEditorPart openInEditor(Object inputElement) throws ModelException, PartInitException {
        return EditorUtility.openInEditor(inputElement, true);
    }

    public static IEditorPart openInEditor(Object inputElement, boolean activate) throws ModelException, PartInitException {
        ISourceModule editorCU;
        IEditorPart editor;
        IWorkbenchPage page;
        IModelElement modelElement;
        ISourceModule cu;
        if (inputElement instanceof IFile) {
            return EditorUtility.openInEditor((IFile)inputElement, activate);
        }
        if (inputElement instanceof IModelElement && (cu = (ISourceModule)(modelElement = (IModelElement)inputElement).getAncestor(5)) != null && !ScriptModelUtil.isPrimary((ISourceModule)cu) && (page = DLTKUIPlugin.getActivePage()) != null && (editor = page.getActiveEditor()) != null && (editorCU = EditorUtility.getEditorInputModelElement(editor, false)) == cu) {
            EditorUtility.revealInEditor(editor, modelElement);
            return editor;
        }
        if (inputElement instanceof IForeignElement) {
            IForeignElement el = (IForeignElement)inputElement;
            el.codeSelect();
        } else {
            IEditorInput input;
            if (inputElement instanceof JSSourceType) {
                inputElement = ((JSSourceType)inputElement).getParent();
            }
            if ((input = EditorUtility.getEditorInput(inputElement)) != null) {
                if (inputElement instanceof IModelElement) {
                    IDLTKUILanguageToolkit toolkit;
                    String editorId = null;
                    if (editorId == null && input != null && (toolkit = DLTKUILanguageManager.getLanguageToolkit((IModelElement)inputElement)) != null) {
                        editorId = toolkit.getEditorId(inputElement);
                    }
                    if (editorId != null) {
                        IModelElement modelElement2 = (IModelElement)inputElement;
                        modelElement2.getElementName();
                        boolean openInROEditor = false;
                        return EditorUtility.openInEditor(input, editorId, activate, openInROEditor);
                    }
                } else {
                    return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, inputElement), activate, false);
                }
            }
        }
        return null;
    }

    public static String getEditorID(IEditorInput input, Object inputObject) {
        IEditorDescriptor editorDescriptor;
        try {
            editorDescriptor = input instanceof IFileEditorInput ? IDE.getEditorDescriptor((IFile)((IFileEditorInput)input).getFile()) : (input instanceof ExternalStorageEditorInput ? IDE.getEditorDescriptor((String)input.getName()) : IDE.getEditorDescriptor((String)input.getName()));
        }
        catch (PartInitException partInitException) {
            return null;
        }
        if (editorDescriptor != null) {
            return editorDescriptor.getId();
        }
        return null;
    }

    private static IEditorInput getEditorInput(IModelElement element) throws ModelException {
        while (element != null) {
            ISourceModule unit;
            if (element instanceof IExternalSourceModule) {
                unit = ((ISourceModule)element).getPrimary();
                if (unit instanceof IStorage) {
                    return new ExternalStorageEditorInput((IStorage)unit);
                }
            } else if (element instanceof ISourceModule) {
                unit = ((ISourceModule)element).getPrimary();
                IResource resource = unit.getResource();
                if (resource == null || !resource.exists()) {
                    return new ExternalFileEditorInput(element);
                }
                if (resource.exists() && resource instanceof IFile) {
                    return new FileEditorInput((IFile)resource);
                }
            }
            element = element.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object input) throws ModelException {
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        if (DLTKCore.DEBUG) {
            System.err.println("Add archive entry and external source folder editor input..");
        }
        if (input instanceof IStorage) {
            return new ExternalStorageEditorInput((IStorage)input);
        }
        IEditorInput einput = null;
        if (input instanceof IModelElement) {
            einput = EditorUtility.getEditorInput((IModelElement)input);
            return einput;
        }
        return null;
    }

    public static void revealInEditor(IEditorPart part, IModelElement element) {
        if (element == null) {
            return;
        }
        if (part instanceof ScriptEditor) {
            ((ScriptEditor)part).setSelection(element);
            if (DLTKCore.DEBUG) {
                System.err.println("Add revealInEditor set selection");
            }
            return;
        }
        try {
            ISourceRange range = null;
            if (!(element instanceof IExternalSourceModule)) {
                if (element instanceof ISourceModule) {
                    range = null;
                } else if (element instanceof IMember) {
                    range = ((IMember)element).getNameRange();
                } else if (element instanceof ISourceReference) {
                    range = ((ISourceReference)element).getSourceRange();
                }
            }
            if (range != null) {
                EditorUtility.revealInEditor(part, range.getOffset(), range.getLength());
            }
        }
        catch (ModelException modelException) {}
    }

    public static void revealInEditor(IEditorPart editorPart, int lineNumber) throws CoreException {
        if (editorPart instanceof ITextEditor && lineNumber >= 0) {
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocumentProvider provider = textEditor.getDocumentProvider();
            IEditorInput input = editorPart.getEditorInput();
            provider.connect((Object)input);
            IDocument document = provider.getDocument((Object)input);
            try {
                IRegion line = document.getLineInformation(lineNumber);
                textEditor.selectAndReveal(line.getOffset(), line.getLength());
            }
            catch (BadLocationException badLocationException) {}
            provider.disconnect((Object)input);
        }
    }

    public static void revealInEditor(IEditorPart part, IRegion region) {
        if (part != null && region != null) {
            EditorUtility.revealInEditor(part, region.getOffset(), region.getLength());
        }
    }

    public static void revealInEditor(IEditorPart editor, final int offset, final int length) {
        if (editor instanceof ITextEditor) {
            ((ITextEditor)editor).selectAndReveal(offset, length);
            return;
        }
        if (editor instanceof IGotoMarker) {
            final IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                final IGotoMarker gotoMarkerTarget = (IGotoMarker)editor;
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException {
                        IMarker marker = null;
                        try {
                            marker = ((IFileEditorInput)input).getFile().createMarker("org.eclipse.core.resources.textmarker");
                            marker.setAttribute("charStart", offset);
                            marker.setAttribute("charEnd", offset + length);
                            gotoMarkerTarget.gotoMarker(marker);
                        }
                        finally {
                            if (marker != null) {
                                marker.delete();
                            }
                        }
                    }
                };
                try {
                    op.run(null);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            } else if (input instanceof ExternalStorageEditorInput) {
                System.err.println("TODO: Add external storage editor input reveal...");
            }
            return;
        }
        if (editor != null && editor.getEditorSite().getSelectionProvider() != null) {
            IEditorSite site = editor.getEditorSite();
            if (site == null) {
                return;
            }
            ISelectionProvider provider = editor.getEditorSite().getSelectionProvider();
            if (provider == null) {
                return;
            }
            provider.setSelection((ISelection)new TextSelection(offset, length));
        }
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (file != null && (p = DLTKUIPlugin.getActivePage()) != null) {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)activate);
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate, boolean openInRO) throws PartInitException {
        IWorkbenchPage p;
        if (input != null && (p = DLTKUIPlugin.getActivePage()) != null) {
            IEditorPart editorPart;
            if (!openInRO) {
                editorPart = p.openEditor(input, editorID, activate);
            } else {
                try {
                    if (nativeTypeName.trim().length() > 0) {
                        input = EditorUtility.generateTempNativeType(".nativeType", "\\" + nativeTypeName + ".js");
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                editorPart = p.openEditor(input, "org.eclipse.vjet.eclipse.ui.VjoROEditor", activate);
            }
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    private static void initializeHighlightRange(IEditorPart editorPart) {
        if (editorPart instanceof ITextEditor) {
            boolean enable;
            IAction toggleAction = editorPart.getEditorSite().getActionBars().getGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly");
            boolean bl = enable = toggleAction != null;
            if (DLTKCore.DEBUG) {
                System.err.println("Add initializeHighlightRange support of preferences.");
            }
            boolean bl2 = enable = enable && toggleAction.isEnabled() && toggleAction.isChecked();
            if (enable) {
                if (toggleAction instanceof TextEditorAction) {
                    ((TextEditorAction)toggleAction).setEditor(null);
                    ((TextEditorAction)toggleAction).setEditor((ITextEditor)editorPart);
                } else {
                    toggleAction.run();
                    toggleAction.run();
                }
            }
        }
    }

    private static boolean isNativeType(String typeName) {
        return nativeGlobalObjects.contains(typeName);
    }

    public static IEditorPart isOpenInEditor(Object inputElement) {
        IWorkbenchPage p;
        IEditorInput input = null;
        try {
            input = EditorUtility.getEditorInput(inputElement);
        }
        catch (ModelException x) {
            DLTKUIPlugin.log(x.getStatus());
        }
        if (input != null && (p = DLTKUIPlugin.getActivePage()) != null) {
            return p.findEditor(input);
        }
        return null;
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (!inputs.contains(input)) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public static IModelElement getActiveEditorModelInput() {
        IEditorInput editorInput;
        IEditorPart part;
        IWorkbenchPage page = DLTKUIPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) != null && (editorInput = part.getEditorInput()) != null) {
            return DLTKUIPlugin.getEditorInputModelElement(editorInput);
        }
        return null;
    }

    private static String appendModifierString(String modifierString, int modifier) {
        if (modifierString == null) {
            modifierString = "";
        }
        String newModifierString = Action.findModifierString((int)modifier);
        if (modifierString.length() == 0) {
            return newModifierString;
        }
        return Messages.format(DLTKEditorMessages.EditorUtility_concatModifierStrings, new String[]{modifierString, newModifierString});
    }

    public static String getModifierString(int stateMask) {
        String modifierString = "";
        if ((stateMask & 0x40000) == 262144) {
            modifierString = EditorUtility.appendModifierString(modifierString, 262144);
        }
        if ((stateMask & 0x10000) == 65536) {
            modifierString = EditorUtility.appendModifierString(modifierString, 65536);
        }
        if ((stateMask & 0x20000) == 131072) {
            modifierString = EditorUtility.appendModifierString(modifierString, 131072);
        }
        if ((stateMask & 0x400000) == 0x400000) {
            modifierString = EditorUtility.appendModifierString(modifierString, 0x400000);
        }
        return modifierString;
    }

    public static int findLocalizedModifier(String modifierName) {
        if (modifierName == null) {
            return 0;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }
}

