/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.refactoring.vjet.descriptors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.internal.corext.refactoring.ScriptRefactoringDescriptor;

public class RenameModelElementDescriptor
extends ScriptRefactoringDescriptor {
    private static final String ATTRIBUTE_HIERARCHICAL = "hierarchical";
    private static final String ATTRIBUTE_MATCH_STRATEGY = "matchStrategy";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_SIMILAR_DECLARATIONS = "similarDeclarations";
    private static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    public static final int STRATEGY_EMBEDDED = 2;
    public static final int STRATEGY_EXACT = 1;
    public static final int STRATEGY_SUFFIX = 3;
    private boolean fDelegate = false;
    private boolean fDeprecate = false;
    private boolean fHierarchical = false;
    private IModelElement fJavaElement = null;
    private int fMatchStrategy = 1;
    private String fName = null;
    private String fPatterns = null;
    private boolean fQualified = false;
    private boolean fReferences = false;
    private boolean fRenameGetter = false;
    private boolean fRenameSetter = false;
    private boolean fSimilarDeclarations = false;
    private boolean fTextual = false;

    public RenameModelElementDescriptor(String id) {
        super(id, null, "TODO", "TODO");
    }

    private boolean checkId(String id) {
        Assert.isNotNull((Object)id);
        return true;
    }

    @Override
    protected void populateArgumentMap() {
        super.populateArgumentMap();
        this.fArguments.put("name", this.fName);
        this.fArguments.put("input", RenameModelElementDescriptor.elementToHandle(this.getProject(), this.fJavaElement));
        int type = this.fJavaElement.getElementType();
        if (type != 3) {
            this.fArguments.put("references", Boolean.toString(this.fReferences));
        }
        switch (type) {
            case 4: 
            case 7: 
            case 8: {
                this.fArguments.put(ATTRIBUTE_TEXTUAL_MATCHES, Boolean.toString(this.fTextual));
            }
        }
        switch (type) {
            case 4: 
            case 7: {
                this.fArguments.put(ATTRIBUTE_QUALIFIED, Boolean.toString(this.fQualified));
                if (this.fPatterns == null || "".equals(this.fPatterns)) break;
                this.fArguments.put(ATTRIBUTE_PATTERNS, this.fPatterns);
            }
        }
        switch (type) {
            case 7: {
                this.fArguments.put(ATTRIBUTE_SIMILAR_DECLARATIONS, Boolean.toString(this.fSimilarDeclarations));
                this.fArguments.put(ATTRIBUTE_MATCH_STRATEGY, Integer.toString(this.fMatchStrategy));
            }
        }
        switch (type) {
            case 4: {
                this.fArguments.put(ATTRIBUTE_HIERARCHICAL, Boolean.toString(this.fHierarchical));
            }
        }
    }

    public void setDeprecateDelegate(boolean deprecate) {
        this.fDeprecate = deprecate;
    }

    public void setFileNamePatterns(String patterns) {
        Assert.isNotNull((Object)patterns);
        Assert.isLegal((!"".equals(patterns) ? 1 : 0) != 0, (String)"Pattern must not be empty");
        this.fPatterns = patterns;
    }

    public void setModelElement(IModelElement element) {
        Assert.isNotNull((Object)element);
        this.fJavaElement = element;
    }

    public void setKeepOriginal(boolean delegate) {
        this.fDelegate = delegate;
    }

    public void setMatchStrategy(int strategy) {
        Assert.isLegal((strategy == 1 || strategy == 2 || strategy == 3 ? 1 : 0) != 0, (String)"Wrong match strategy argument");
        this.fMatchStrategy = strategy;
    }

    public void setNewName(String name) {
        Assert.isNotNull((Object)name);
        Assert.isLegal((!"".equals(name) ? 1 : 0) != 0, (String)"Name must not be empty");
        this.fName = name;
    }

    public void setProject(String project) {
        super.setProject(project);
    }

    public void setRenameGetters(boolean rename) {
        this.fRenameGetter = rename;
    }

    public void setRenameSetters(boolean rename) {
        this.fRenameSetter = rename;
    }

    public void setUpdateHierarchy(boolean update) {
        this.fHierarchical = update;
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fQualified = update;
    }

    public void setUpdateReferences(boolean update) {
        this.fReferences = update;
    }

    public void setUpdateSimilarDeclarations(boolean update) {
        this.fSimilarDeclarations = update;
    }

    public void setUpdateTextualOccurrences(boolean update) {
        this.fTextual = update;
    }
}

