/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.search.matching;

import org.eclipse.dltk.mod.compiler.CharOperation;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.search.SearchPattern;
import org.eclipse.dltk.mod.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.mod.internal.core.search.matching.AndPattern;

public class PackageReferencePattern
extends AndPattern
implements IIndexConstants {
    protected char[] pkgName;
    protected char[][] segments;
    protected int currentSegment;
    protected static char[][] CATEGORIES = new char[][]{REF};

    public PackageReferencePattern(char[] pkgName, int matchRule, IDLTKLanguageToolkit toolkit) {
        this(matchRule, toolkit);
        if (pkgName == null || pkgName.length == 0) {
            this.pkgName = null;
            this.segments = new char[][]{CharOperation.NO_CHAR};
        } else {
            this.pkgName = this.isCaseSensitive() || this.isCamelCase() ? pkgName : CharOperation.toLowerCase(pkgName);
            this.segments = CharOperation.splitOn('.', this.pkgName);
        }
    }

    PackageReferencePattern(int matchRule, IDLTKLanguageToolkit toolkit) {
        super(1, matchRule, toolkit);
    }

    @Override
    public void decodeIndexKey(char[] key) {
        this.pkgName = key;
    }

    @Override
    public SearchPattern getBlankPattern() {
        return new PackageReferencePattern(8, this.getToolkit());
    }

    @Override
    public char[] getIndexKey() {
        if (this.currentSegment >= 0) {
            return this.segments[this.currentSegment];
        }
        return null;
    }

    @Override
    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    @Override
    protected boolean hasNextQuery() {
        return --this.currentSegment >= (this.segments.length >= 4 ? 2 : 0);
    }

    @Override
    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        return true;
    }

    @Override
    protected void resetQuery() {
        this.currentSegment = this.segments.length - 1;
    }

    @Override
    protected StringBuffer print(StringBuffer output) {
        output.append("PackageReferencePattern: <");
        if (this.pkgName != null) {
            output.append(this.pkgName);
        } else {
            output.append("*");
        }
        output.append(">");
        return super.print(output);
    }
}

