/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.builder;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.builder.IBuildParticipant;
import org.eclipse.dltk.mod.core.builder.IBuildParticipantFactory;
import org.eclipse.dltk.mod.internal.core.builder.Messages;
import org.eclipse.dltk.mod.utils.NatureExtensionManager;
import org.eclipse.osgi.util.NLS;

public class BuildParticipantManager
extends NatureExtensionManager {
    private static final String EXT_POINT = "org.eclipse.dltk.mod.core.buildParticipant";
    private static final String REQUIRES = "requires";
    private static final String REQUIRES_ID = "id";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static BuildParticipantManager instance = null;
    private static final IBuildParticipant[] NO_PARTICIPANTS = new IBuildParticipant[0];

    private BuildParticipantManager() {
        super(EXT_POINT, BuildParticipantDescriptor.class);
    }

    @Override
    protected Object createInstanceByDescriptor(Object input) throws CoreException {
        IConfigurationElement element = (IConfigurationElement)input;
        Object factory = element.createExecutableExtension("class");
        if (!(factory instanceof IBuildParticipantFactory)) {
            return null;
        }
        BuildParticipantDescriptor descriptor = new BuildParticipantDescriptor((IBuildParticipantFactory)factory, element.getAttribute("id"), element.getAttribute(ATTR_NAME));
        IConfigurationElement[] requires = element.getChildren(REQUIRES);
        int i = 0;
        while (i < requires.length) {
            String id = requires[i].getAttribute("id");
            if (id != null) {
                descriptor.requirements.add(id);
            }
            ++i;
        }
        return descriptor;
    }

    private static BuildParticipantManager getInstance() {
        if (instance == null) {
            instance = new BuildParticipantManager();
        }
        return instance;
    }

    public static IBuildParticipant[] getBuildParticipants(IScriptProject project, String natureId) {
        BuildParticipantDescriptor[] descriptors = (BuildParticipantDescriptor[])BuildParticipantManager.getInstance().getInstances(natureId);
        if (descriptors == null || descriptors.length == 0) {
            return NO_PARTICIPANTS;
        }
        return BuildParticipantManager.createParticipants(project, descriptors);
    }

    public static IBuildParticipant[] createParticipants(IScriptProject project, BuildParticipantDescriptor[] descriptors) {
        int iterationStartCount;
        IBuildParticipant[] result = new IBuildParticipant[descriptors.length];
        HashSet<String> processed = new HashSet<String>();
        HashSet<String> created = new HashSet<String>();
        do {
            iterationStartCount = created.size();
            int i = 0;
            while (i < descriptors.length) {
                BuildParticipantDescriptor desc = descriptors[i];
                if (!processed.contains(desc.id) && created.containsAll(desc.requirements)) {
                    processed.add(desc.id);
                    try {
                        IBuildParticipant participant = desc.factory.createBuildParticipant(project);
                        if (participant != null) {
                            result[created.size()] = participant;
                            created.add(desc.id);
                        }
                    }
                    catch (CoreException e) {
                        String tpl = Messages.BuildParticipantManager_buildParticipantCreateError;
                        DLTKCore.warn(NLS.bind((String)tpl, (Object)desc.id), e);
                    }
                }
                ++i;
            }
        } while (iterationStartCount != created.size());
        if (created.size() != result.length) {
            IBuildParticipant[] newResult = new IBuildParticipant[created.size()];
            System.arraycopy(result, 0, newResult, 0, created.size());
            return newResult;
        }
        return result;
    }

    public static class BuildParticipantDescriptor {
        final IBuildParticipantFactory factory;
        final String id;
        final String name;
        public final Set requirements = new HashSet();

        public BuildParticipantDescriptor(IBuildParticipantFactory factory, String id, String name) {
            this.factory = factory;
            this.id = id != null ? id : factory.getClass().getName();
            this.name = name;
        }
    }
}

