/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.dltk.mod.compiler.CharOperation;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.builder.IBuildContext;
import org.eclipse.dltk.mod.core.builder.ISourceLineTracker;
import org.eclipse.dltk.mod.utils.TextUtils;

public abstract class AbstractBuildContext
implements IBuildContext {
    private final Map attributes = new HashMap();
    protected final ISourceModule module;
    private char[] contents;
    private ISourceLineTracker lineTracker = null;

    @Override
    public Object get(String attribute) {
        return this.attributes.get(attribute);
    }

    @Override
    public void set(String attribute, Object value) {
        if (value == null) {
            this.attributes.remove(attribute);
        } else {
            this.attributes.put(attribute, value);
        }
    }

    protected AbstractBuildContext(ISourceModule module) {
        this.module = module;
    }

    @Override
    public final char[] getContents() {
        if (this.contents == null) {
            try {
                this.contents = this.module.getSourceAsCharArray();
            }
            catch (ModelException e) {
                DLTKCore.error("Error retrieving contents of " + this.module.getElementName(), (Throwable)((Object)e));
                this.contents = CharOperation.NO_CHAR;
            }
        }
        return this.contents;
    }

    @Override
    public ISourceLineTracker getLineTracker() {
        if (this.lineTracker == null) {
            this.lineTracker = TextUtils.createLineTracker(this.getContents());
        }
        return this.lineTracker;
    }

    @Override
    public final ISourceModule getSourceModule() {
        return this.module;
    }

    @Override
    public final IFile getFile() {
        return (IFile)this.module.getResource();
    }
}

