/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuildpathContainer;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IBuiltinModuleProvider;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.BuiltinProjectFragmentInfo;
import org.eclipse.dltk.mod.internal.core.BuiltinScriptFolder;
import org.eclipse.dltk.mod.internal.core.BuiltinScriptFolderInfo;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.OpenableElementInfo;
import org.eclipse.dltk.mod.internal.core.ProjectFragment;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.mod.internal.core.util.Util;

public class BuiltinProjectFragment
extends ProjectFragment {
    public static final ArrayList EMPTY_LIST = new ArrayList();
    static final Object INTERPRETER_CONTAINER = "org.eclipse.dltk.mod.launching.INTERPRETER_CONTAINER";
    protected final IPath fPath;
    IBuiltinModuleProvider builtinProvider;

    protected BuiltinProjectFragment(IPath path, ScriptProject project) {
        super(null, project);
        this.fPath = path;
        this.builtinProvider = BuiltinProjectFragment.getBuiltinProvider(project);
    }

    public static IBuiltinModuleProvider getBuiltinProvider(IScriptProject project) {
        block4: {
            try {
                IBuildpathEntry[] entries = project.getRawBuildpath();
                IPath containerPath = null;
                int i = 0;
                while (i < entries.length) {
                    IBuiltinModuleProvider builtinProvider;
                    IBuildpathContainer buildpathContainer;
                    IPath path;
                    if (entries[i].getEntryKind() == 5 && (path = entries[i].getPath()).segment(0).equals(INTERPRETER_CONTAINER) && (containerPath = entries[i].getPath()) != null && (buildpathContainer = ModelManager.getModelManager().getBuildpathContainer(containerPath, project)) != null && buildpathContainer.getBuiltinProvider(project) != null && (builtinProvider = buildpathContainer.getBuiltinProvider(project)) != null && builtinProvider.getBuiltinModules() != null) {
                        return builtinProvider;
                    }
                    ++i;
                }
            }
            catch (CoreException ex) {
                if (!DLTKCore.DEBUG) break block4;
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isSupported(IScriptProject project) {
        IBuiltinModuleProvider prov = BuiltinProjectFragment.getBuiltinProvider(project);
        return prov != null && prov.getBuiltinModules() != null;
    }

    @Override
    protected boolean computeChildren(OpenableElementInfo info, Map newElements) throws ModelException {
        char[][] exclusionPatterns;
        ArrayList vChildren = new ArrayList(5);
        ArrayList vForeign = new ArrayList(5);
        char[][] inclusionPatterns = this.fullInclusionPatternChars();
        this.computeFolderChildren(this.fPath, !Util.isExcluded(this.fPath, inclusionPatterns, exclusionPatterns = this.fullExclusionPatternChars(), true), vChildren, vForeign, newElements, inclusionPatterns, exclusionPatterns);
        IModelElement[] children = new IModelElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    protected void computeFolderChildren(IPath path, boolean isIncluded, ArrayList vChildren, ArrayList vForeign, Map newElements, char[][] inclusionPatterns, char[][] exclusionPatterns) throws ModelException {
        BuiltinScriptFolder fldr = (BuiltinScriptFolder)this.getScriptFolder((IPath)new Path(""));
        vChildren.add(fldr);
        if (this.builtinProvider == null) {
            return;
        }
        try {
            BuiltinScriptFolderInfo fragInfo = new BuiltinScriptFolderInfo();
            fldr.computeChildren(fragInfo, this.builtinProvider.getBuiltinModules());
            fldr.computeForeignResources(fragInfo);
            newElements.put(fldr, fragInfo);
        }
        catch (IllegalArgumentException e) {
            throw new ModelException(e, 969);
        }
    }

    @Override
    public IScriptFolder getScriptFolder(IPath path) {
        block4: {
            try {
                ArrayList childs = this.getChildrenOfType(4);
                int i = 0;
                while (i < childs.size()) {
                    IScriptFolder folder = (IScriptFolder)childs.get(i);
                    if (folder.getElementName().equals(path.toPortableString())) {
                        return folder;
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return new BuiltinScriptFolder(this, path);
    }

    @Override
    public IScriptFolder getScriptFolder(String path) {
        return this.getScriptFolder((IPath)new Path(path));
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected Object createElementInfo() {
        return new BuiltinProjectFragmentInfo();
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    @Override
    public IResource getUnderlyingResource() throws ModelException {
        return null;
    }

    @Override
    public int hashCode() {
        return this.fPath.hashCode();
    }

    @Override
    public IPath getPath() {
        if (this.isExternal()) {
            return this.fPath;
        }
        return super.getPath();
    }

    @Override
    public IResource getResource() {
        return null;
    }

    @Override
    protected boolean resourceExists() {
        return true;
    }

    @Override
    protected void toStringAncestors(StringBuffer buffer) {
        if (this.isExternal()) {
            return;
        }
        super.toStringAncestors(buffer);
    }

    @Override
    public int getKind() {
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BuiltinProjectFragment) {
            BuiltinProjectFragment other = (BuiltinProjectFragment)o;
            return this.fPath.equals((Object)other.fPath);
        }
        return false;
    }

    @Override
    public String getElementName() {
        return this.fPath.toOSString().replace(File.separatorChar, '>');
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        ((ModelElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getElementName());
    }

    @Override
    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '<': {
                String pkgName;
                if (memento.hasMoreTokens()) {
                    pkgName = memento.nextToken();
                    char firstChar = pkgName.charAt(0);
                    if (firstChar == '{' || firstChar == '!') {
                        token = pkgName;
                        pkgName = "";
                    } else {
                        token = null;
                    }
                } else {
                    pkgName = "";
                    token = null;
                }
                ModelElement pkg = (ModelElement)((Object)this.getScriptFolder(pkgName));
                if (token == null) {
                    return pkg.getHandleFromMemento(memento, owner);
                }
                return pkg.getHandleFromMemento(token, memento, owner);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '/';
    }

    @Override
    public IBuildpathEntry getRawBuildpathEntry() throws ModelException {
        IBuildpathEntry rawEntry = null;
        ScriptProject project = (ScriptProject)this.getScriptProject();
        project.getResolvedBuildpath(true, false, false);
        Map resolvedPathToRawEntries = project.getPerProjectInfo().resolvedPathToRawEntries;
        if (resolvedPathToRawEntries != null && (rawEntry = (IBuildpathEntry)resolvedPathToRawEntries.get(new Path(this.getPath().segment(0)))) != null && rawEntry.getEntryKind() == 5) {
            IBuildpathContainer container = DLTKCore.getBuildpathContainer(rawEntry.getPath(), project);
            IBuildpathEntry[] entrys = container.getBuildpathEntries(project);
            int i = 0;
            while (i < entrys.length) {
                if (entrys[i].getPath().equals((Object)new Path(this.getPath().segment(0)))) {
                    return entrys[i];
                }
                ++i;
            }
        }
        return rawEntry;
    }

    @Override
    protected IStatus validateOnBuildpath() {
        return Status.OK_STATUS;
    }

    @Override
    public boolean exists() {
        return true;
    }

    public long lastModified() {
        return this.builtinProvider != null ? this.builtinProvider.lastModified() : 0L;
    }
}

