/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.core.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.mod.compiler.CharOperation;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.core.search.DLTKSearchParticipant;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.core.search.MethodNameMatch;
import org.eclipse.dltk.mod.core.search.SearchDocument;
import org.eclipse.dltk.mod.core.search.SearchParticipant;
import org.eclipse.dltk.mod.core.search.SearchPattern;
import org.eclipse.dltk.mod.core.search.SearchRequestor;
import org.eclipse.dltk.mod.core.search.TypeNameMatch;
import org.eclipse.dltk.mod.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.mod.core.search.indexing.IndexManager;
import org.eclipse.dltk.mod.core.search.matching.MatchLocator;
import org.eclipse.dltk.mod.internal.compiler.env.AccessRestriction;
import org.eclipse.dltk.mod.internal.compiler.env.AccessRuleSet;
import org.eclipse.dltk.mod.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.SourceModule;
import org.eclipse.dltk.mod.internal.core.search.DLTKSearchDocument;
import org.eclipse.dltk.mod.internal.core.search.DLTKSearchMethodNameMatch;
import org.eclipse.dltk.mod.internal.core.search.DLTKSearchScope;
import org.eclipse.dltk.mod.internal.core.search.DLTKSearchTypeNameMatch;
import org.eclipse.dltk.mod.internal.core.search.HierarchyScope;
import org.eclipse.dltk.mod.internal.core.search.IRestrictedAccessMethodRequestor;
import org.eclipse.dltk.mod.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.dltk.mod.internal.core.search.IndexQueryRequestor;
import org.eclipse.dltk.mod.internal.core.search.PathCollector;
import org.eclipse.dltk.mod.internal.core.search.PatternSearchJob;
import org.eclipse.dltk.mod.internal.core.search.SuperHierarchyScope;
import org.eclipse.dltk.mod.internal.core.search.matching.MethodDeclarationPattern;
import org.eclipse.dltk.mod.internal.core.search.matching.QualifiedTypeDeclarationPattern;
import org.eclipse.dltk.mod.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.dltk.mod.internal.core.util.Messages;
import org.eclipse.dltk.mod.internal.core.util.Util;

public class BasicSearchEngine {
    private ISourceModule[] workingCopies;
    private WorkingCopyOwner workingCopyOwner;
    public static boolean VERBOSE = false;

    public BasicSearchEngine() {
    }

    public BasicSearchEngine(ISourceModule[] workingCopies) {
        this.workingCopies = workingCopies;
    }

    char convertTypeKind(int typeDeclarationKind) {
        switch (typeDeclarationKind) {
            case 3001: {
                return 'C';
            }
        }
        return 'C';
    }

    public BasicSearchEngine(WorkingCopyOwner workingCopyOwner) {
        this.workingCopyOwner = workingCopyOwner;
    }

    public static IDLTKSearchScope createHierarchyScope(IType type) throws ModelException {
        return BasicSearchEngine.createHierarchyScope(type, DefaultWorkingCopyOwner.PRIMARY);
    }

    public static IDLTKSearchScope createHierarchyScope(IType type, WorkingCopyOwner owner) throws ModelException {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(type);
        return new HierarchyScope(toolkit, type, owner);
    }

    public static IDLTKSearchScope createSuperHierarchyScope(IType type) throws ModelException {
        return BasicSearchEngine.createSuperHierarchyScope(type, DefaultWorkingCopyOwner.PRIMARY);
    }

    public static IDLTKSearchScope createSuperHierarchyScope(IType type, WorkingCopyOwner owner) throws ModelException {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(type);
        return new SuperHierarchyScope(toolkit, type, owner);
    }

    public static IDLTKSearchScope createSearchScope(IModelElement[] elements, IDLTKLanguageToolkit toolkit) {
        return BasicSearchEngine.createSearchScope(elements, true, toolkit);
    }

    public static IDLTKSearchScope createSearchScope(IModelElement element) {
        return BasicSearchEngine.createSearchScope(new IModelElement[]{element}, true, DLTKLanguageManager.getLanguageToolkit(element));
    }

    public static IDLTKSearchScope createSearchScope(IModelElement[] elements, boolean includeReferencedProjects, IDLTKLanguageToolkit toolkit) {
        int includeMask = 7;
        if (includeReferencedProjects) {
            includeMask |= 8;
        }
        return BasicSearchEngine.createSearchScope(elements, includeMask, toolkit);
    }

    public static IDLTKSearchScope createSearchScope(IModelElement[] elements, int includeMask, IDLTKLanguageToolkit toolkit) {
        DLTKSearchScope scope = new DLTKSearchScope(toolkit);
        if (toolkit != null) {
            HashSet visitedProjects = new HashSet(2);
            int i = 0;
            while (i < elements.length) {
                IModelElement element = elements[i];
                if (element != null) {
                    try {
                        if (element instanceof ScriptProject) {
                            scope.add((ScriptProject)element, includeMask, visitedProjects);
                        } else {
                            scope.add(element);
                        }
                    }
                    catch (ModelException modelException) {}
                }
                ++i;
            }
        }
        return scope;
    }

    public static TypeNameMatch createTypeNameMatch(IType type, int modifiers) {
        return new DLTKSearchTypeNameMatch(type, modifiers);
    }

    public static IDLTKSearchScope createWorkspaceScope(IDLTKLanguageToolkit toolkit) {
        return ModelManager.getModelManager().getWorkspaceScope(toolkit);
    }

    void findMatches(SearchPattern pattern, SearchParticipant[] participants, IDLTKSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (VERBOSE) {
            Util.verbose("Searching for pattern: " + pattern.toString());
            Util.verbose(scope.toString());
        }
        if (participants == null) {
            if (VERBOSE) {
                Util.verbose("No participants => do nothing!");
            }
            return;
        }
        int length = participants.length;
        if (monitor != null) {
            monitor.beginTask(Messages.engine_searching, 100 * length);
        }
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        try {
            try {
                requestor.beginReporting();
                int i = 0;
                while (i < participants.length) {
                    block26: {
                        SearchParticipant participant = participants[i];
                        if (monitor != null && monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        try {
                            try {
                                String[] indexMatchPaths;
                                if (monitor != null) {
                                    monitor.subTask(Messages.bind(Messages.engine_searching_indexing, new String[]{participant.getDescription()}));
                                }
                                participant.beginSearching();
                                requestor.enterParticipant(participant);
                                PathCollector pathCollector = new PathCollector();
                                indexManager.performConcurrentJob(new PatternSearchJob(pattern, participant, scope, pathCollector), 3, (IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 50)));
                                if (monitor != null && monitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                if (monitor != null) {
                                    monitor.subTask(Messages.bind(Messages.engine_searching_matching, new String[]{participant.getDescription()}));
                                }
                                if ((indexMatchPaths = pathCollector.getPaths()) != null) {
                                    pathCollector = null;
                                    int indexMatchLength = indexMatchPaths.length;
                                    SearchDocument[] indexMatches = new SearchDocument[indexMatchLength];
                                    int j = 0;
                                    while (j < indexMatchLength) {
                                        indexMatches[j] = participant.getDocument(indexMatchPaths[j], null);
                                        ++j;
                                    }
                                    SearchDocument[] matches = MatchLocator.addWorkingCopies(pattern, indexMatches, this.getWorkingCopies(), participant);
                                    HashSet<Path> paths = new HashSet<Path>();
                                    ArrayList<SearchDocument> filteredMatches = new ArrayList<SearchDocument>();
                                    int q = 0;
                                    while (q < matches.length) {
                                        Path path = new Path(matches[q].getPath());
                                        if (paths.add(path)) {
                                            filteredMatches.add(matches[q]);
                                        }
                                        ++q;
                                    }
                                    SearchDocument[] fmatches = filteredMatches.toArray(new SearchDocument[filteredMatches.size()]);
                                    participant.locateMatches(fmatches, pattern, scope, requestor, (IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 50)));
                                }
                            }
                            catch (Exception e) {
                                DLTKCore.error("Error in findMatches()", e);
                                requestor.exitParticipant(participant);
                                participant.doneSearching();
                                break block26;
                            }
                        }
                        catch (Throwable throwable) {
                            requestor.exitParticipant(participant);
                            participant.doneSearching();
                            throw throwable;
                        }
                        requestor.exitParticipant(participant);
                        participant.doneSearching();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                DLTKCore.error("Error in findMatches()", e);
                requestor.endReporting();
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            requestor.endReporting();
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    List findMatchesSourceOnly(SearchPattern pattern, SearchParticipant[] participants, IDLTKSearchScope scope, IProgressMonitor monitor) throws CoreException {
        block24: {
            if (monitor != null && monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (monitor != null) {
                monitor.beginTask(Messages.engine_searching, 100);
            }
            if (VERBOSE) {
                Util.verbose("Searching for pattern: " + pattern.toString());
                Util.verbose(scope.toString());
            }
            if (participants == null) {
                if (VERBOSE) {
                    Util.verbose("No participants => do nothing!");
                }
                return null;
            }
            IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
            try {
                ArrayList<ISourceModule> documents;
                block26: {
                    SubProgressMonitor subMonitor;
                    documents = new ArrayList<ISourceModule>();
                    int i = 0;
                    if (i >= participants.length) break block24;
                    SearchParticipant participant = participants[i];
                    if (monitor != null && monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    SubProgressMonitor subProgressMonitor = subMonitor = monitor == null ? null : new SubProgressMonitor(monitor, 1000);
                    if (subMonitor != null) {
                        subMonitor.beginTask("", 1000);
                    }
                    try {
                        try {
                            String[] indexMatchPaths;
                            if (subMonitor != null) {
                                subMonitor.subTask(Messages.bind(Messages.engine_searching_indexing, new String[]{participant.getDescription()}));
                            }
                            participant.beginSearching();
                            PathCollector pathCollector = new PathCollector();
                            indexManager.performConcurrentJob(new PatternSearchJob(pattern, participant, scope, pathCollector), 3, (IProgressMonitor)subMonitor);
                            if (monitor != null && monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            if (subMonitor != null) {
                                subMonitor.subTask(Messages.bind(Messages.engine_searching_matching, new String[]{participant.getDescription()}));
                            }
                            if ((indexMatchPaths = pathCollector.getPaths()) != null) {
                                pathCollector = null;
                                int indexMatchLength = indexMatchPaths.length;
                                SearchDocument[] indexMatches = new SearchDocument[indexMatchLength];
                                int j = 0;
                                while (j < indexMatchLength) {
                                    indexMatches[j] = participant.getDocument(indexMatchPaths[j], null);
                                    ++j;
                                }
                                SearchDocument[] matches = MatchLocator.addWorkingCopies(pattern, indexMatches, this.getWorkingCopies(), participant);
                                ISourceModule[] modules = participant.locateModules(matches, pattern, scope, (IProgressMonitor)subMonitor);
                                int k = 0;
                                while (k < modules.length) {
                                    if (!documents.contains(modules[k])) {
                                        documents.add(modules[k]);
                                    }
                                    ++k;
                                }
                            }
                        }
                        catch (Exception e) {
                            DLTKCore.error("Error in findMatchesSourceOnly()", e);
                            participant.doneSearching();
                            break block26;
                        }
                    }
                    catch (Throwable throwable) {
                        participant.doneSearching();
                        throw throwable;
                    }
                    participant.doneSearching();
                }
                ArrayList<ISourceModule> arrayList = documents;
                return arrayList;
            }
            catch (Exception e) {
                DLTKCore.error("Error in findMatchesSourceOnly()", e);
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        return null;
    }

    public static SearchParticipant getDefaultSearchParticipant() {
        return new DLTKSearchParticipant();
    }

    public static String getMatchRuleString(int matchRule) {
        if (matchRule == 0) {
            return "R_EXACT_MATCH";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 1;
        while (i <= 8) {
            int bit = matchRule & 1 << i - 1;
            if (bit != 0 && buffer.length() > 0) {
                buffer.append(" | ");
            }
            switch (bit) {
                case 1: {
                    buffer.append("R_PREFIX_MATCH");
                    break;
                }
                case 8: {
                    buffer.append("R_CASE_SENSITIVE");
                    break;
                }
                case 32: {
                    buffer.append("R_EQUIVALENT_MATCH");
                    break;
                }
                case 16: {
                    buffer.append("R_ERASURE_MATCH");
                    break;
                }
                case 64: {
                    buffer.append("R_FULL_MATCH");
                    break;
                }
                case 2: {
                    buffer.append("R_PATTERN_MATCH");
                    break;
                }
                case 4: {
                    buffer.append("R_REGEXP_MATCH");
                    break;
                }
                case 128: {
                    buffer.append("R_CAMELCASE_MATCH");
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String getSearchForString(int searchFor) {
        switch (searchFor) {
            case 0: {
                return "TYPE";
            }
            case 1: {
                return "METHOD";
            }
            case 2: {
                return "FIELD";
            }
            case 8: {
                return "ANNOTATION_TYPE";
            }
        }
        return "UNKNOWN";
    }

    private ISourceModule[] getWorkingCopies() {
        int length;
        ISourceModule[] copies;
        if (this.workingCopies != null) {
            if (this.workingCopyOwner == null) {
                copies = ModelManager.getModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
                if (copies == null) {
                    copies = this.workingCopies;
                } else {
                    ISourceModule unit;
                    HashMap<IPath, ISourceModule> pathToCUs = new HashMap<IPath, ISourceModule>();
                    int i = 0;
                    while (i < copies.length) {
                        unit = copies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    i = 0;
                    while (i < this.workingCopies.length) {
                        unit = this.workingCopies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    length = pathToCUs.size();
                    copies = new ISourceModule[length];
                    pathToCUs.values().toArray(copies);
                }
            } else {
                copies = this.workingCopies;
            }
        } else {
            copies = this.workingCopyOwner != null ? ModelManager.getModelManager().getWorkingCopies(this.workingCopyOwner, true) : ModelManager.getModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
        }
        if (copies == null) {
            return null;
        }
        ISourceModule[] result = null;
        length = copies.length;
        int index = 0;
        int i = 0;
        while (i < length) {
            SourceModule copy = (SourceModule)copies[i];
            try {
                if (!copy.isPrimary() || copy.hasUnsavedChanges() || copy.hasResourceChanged()) {
                    if (result == null) {
                        result = new ISourceModule[length];
                    }
                    result[index++] = copy;
                }
            }
            catch (ModelException modelException) {}
            ++i;
        }
        if (index != length && result != null) {
            ISourceModule[] iSourceModuleArray = result;
            result = new ISourceModule[index];
            System.arraycopy(iSourceModuleArray, 0, result, 0, index);
        }
        return result;
    }

    private ISourceModule[] getWorkingCopies(IModelElement element) {
        ISourceModule cu;
        if (element instanceof IMember && (cu = ((IMember)element).getSourceModule()) != null && cu.isWorkingCopy()) {
            int length;
            ISourceModule[] copies = this.getWorkingCopies();
            int n = length = copies == null ? 0 : copies.length;
            if (length > 0) {
                ISourceModule[] newWorkingCopies = new ISourceModule[length + 1];
                System.arraycopy(copies, 0, newWorkingCopies, 0, length);
                newWorkingCopies[length] = cu;
                return newWorkingCopies;
            }
            return new ISourceModule[]{cu};
        }
        return this.getWorkingCopies();
    }

    boolean match(char patternTypeSuffix, int modifiers) {
        switch (patternTypeSuffix) {
            case 'C': {
                return true;
            }
        }
        return true;
    }

    boolean match(char patternTypeSuffix, char[] patternPkg, char[] patternTypeName, int matchRule, int typeKind, char[] typeName) {
        boolean isCaseSensitive;
        boolean bl = isCaseSensitive = (matchRule & 8) != 0;
        if (patternTypeName != null) {
            boolean matchFirstChar;
            boolean isCamelCase = (matchRule & 0x80) != 0;
            int matchMode = matchRule & 7;
            if (!isCaseSensitive && !isCamelCase) {
                patternTypeName = CharOperation.toLowerCase(patternTypeName);
            }
            boolean bl2 = matchFirstChar = !isCaseSensitive || patternTypeName[0] == typeName[0];
            if (isCamelCase && matchFirstChar && CharOperation.camelCaseMatch(patternTypeName, typeName)) {
                return true;
            }
            switch (matchMode) {
                case 0: {
                    if (!isCamelCase) {
                        return matchFirstChar && CharOperation.equals(patternTypeName, typeName, isCaseSensitive);
                    }
                }
                case 1: {
                    return matchFirstChar && CharOperation.prefixEquals(patternTypeName, typeName, isCaseSensitive);
                }
                case 2: {
                    return CharOperation.match(patternTypeName, typeName, isCaseSensitive);
                }
            }
        }
        return true;
    }

    public void search(SearchPattern pattern, SearchParticipant[] participants, IDLTKSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.search(SearchPattern, SearchParticipant[], IJavaSearchScope, SearchRequestor, IProgressMonitor)");
        }
        this.findMatches(pattern, participants, scope, requestor, monitor);
    }

    public List searchSourceOnly(SearchPattern pattern, SearchParticipant[] participants, IDLTKSearchScope scope, IProgressMonitor monitor) throws CoreException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.search(SearchPattern, SearchParticipant[], IJavaSearchScope, SearchRequestor, IProgressMonitor)");
        }
        return this.findMatchesSourceOnly(pattern, participants, scope, monitor);
    }

    public void searchAllSecondaryTypeNames(IProjectFragment[] sourceFolders, IRestrictedAccessTypeRequestor nameRequestor, boolean waitForIndexes, IProgressMonitor progressMonitor) throws ModelException {
    }

    public void searchAllTypeNames(char[] packageName, int packageMatchRule, char[] typeName, int typeMatchRule, int searchFor, IDLTKSearchScope scope, final IRestrictedAccessTypeRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws ModelException {
        int copiesLength;
        char typeSuffix;
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchAllTypeNames(char[], char[], int, int, IJavaSearchScope, IRestrictedAccessTypeRequestor, int, IProgressMonitor)");
            Util.verbose("\t- package name: " + (packageName == null ? "null" : new String(packageName)));
            Util.verbose("\t- match rule: " + BasicSearchEngine.getMatchRuleString(packageMatchRule));
            Util.verbose("\t- type name: " + (typeName == null ? "null" : new String(typeName)));
            Util.verbose("\t- match rule: " + BasicSearchEngine.getMatchRuleString(typeMatchRule));
            Util.verbose("\t- search for: " + searchFor);
            Util.verbose("\t- scope: " + scope);
        }
        if ((packageName == null || packageName.length == 0) && typeName != null && typeName.length == 0) {
            if (VERBOSE) {
                Util.verbose("\t=> return no result due to invalid empty values for package and type names!");
            }
            return;
        }
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        switch (searchFor) {
            case 0: {
                typeSuffix = 'C';
                break;
            }
            case 8: {
                typeSuffix = 'A';
                break;
            }
            default: {
                typeSuffix = 'C';
            }
        }
        TypeDeclarationPattern pattern = packageMatchRule == 0 ? new TypeDeclarationPattern(packageName, null, typeName, typeSuffix, typeMatchRule, scope.getLanguageToolkit()) : new QualifiedTypeDeclarationPattern(packageName, packageMatchRule, typeName, typeSuffix, typeMatchRule, scope.getLanguageToolkit());
        final HashSet<String> workingCopyPaths = new HashSet<String>();
        String workingCopyPath = null;
        ISourceModule[] copies = this.getWorkingCopies();
        int n = copiesLength = copies == null ? 0 : copies.length;
        if (copies != null) {
            if (copiesLength == 1) {
                workingCopyPath = copies[0].getPath().toString();
            } else {
                int i = 0;
                while (i < copiesLength) {
                    ISourceModule workingCopy = copies[i];
                    workingCopyPaths.add(workingCopy.getPath().toString());
                    ++i;
                }
            }
        }
        final String singleWkcpPath = workingCopyPath;
        IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

            @Override
            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                TypeDeclarationPattern record = (TypeDeclarationPattern)indexRecord;
                if (record.enclosingTypeNames == IIndexConstants.ONE_ZERO_CHAR) {
                    return true;
                }
                switch (copiesLength) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (!singleWkcpPath.equals(documentPath)) break;
                        return true;
                    }
                    default: {
                        if (!workingCopyPaths.contains(documentPath)) break;
                        return true;
                    }
                }
                AccessRestriction accessRestriction = null;
                if (access != null) {
                    int pkgLength = record.pkg == null || record.pkg.length == 0 ? 0 : record.pkg.length + 1;
                    int nameLength = record.simpleName == null ? 0 : record.simpleName.length;
                    char[] path = new char[pkgLength + nameLength];
                    int pos = 0;
                    if (pkgLength > 0) {
                        System.arraycopy(record.pkg, 0, path, pos, pkgLength - 1);
                        CharOperation.replace(path, '.', '/');
                        path[pkgLength - 1] = 47;
                        pos += pkgLength;
                    }
                    if (nameLength > 0) {
                        System.arraycopy(record.simpleName, 0, path, pos, nameLength);
                        pos += nameLength;
                    }
                    if (pos > 0) {
                        accessRestriction = access.getViolatedRestriction(path);
                    }
                }
                if (BasicSearchEngine.this.match(record.typeSuffix, record.modifiers)) {
                    nameRequestor.acceptType(record.modifiers, record.pkg, record.simpleName, record.enclosingTypeNames, documentPath, accessRestriction);
                }
                return true;
            }
        };
        try {
            if (progressMonitor != null) {
                progressMonitor.beginTask(Messages.engine_searching, 100);
            }
            indexManager.performConcurrentJob(new PatternSearchJob(pattern, BasicSearchEngine.getDefaultSearchParticipant(), scope, searchRequestor), waitingPolicy, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 100)));
            if (copies != null) {
                int i = 0;
                while (i < copiesLength) {
                    ISourceModule workingCopy = copies[i];
                    if (scope.encloses(workingCopy)) {
                        String path = workingCopy.getPath().toString();
                        IType[] allTypes = workingCopy.getTypes();
                        int j = 0;
                        while (j < allTypes.length) {
                            char[][] enclosingTypeNames;
                            IType type = allTypes[i];
                            IModelElement parent = type.getParent();
                            if (parent instanceof IType) {
                                char[] parentQualifiedName = ((IType)parent).getTypeQualifiedName().toCharArray();
                                enclosingTypeNames = CharOperation.splitOn('.', parentQualifiedName);
                            } else {
                                enclosingTypeNames = CharOperation.NO_CHAR_CHAR;
                            }
                            char[] simpleName = type.getElementName().toCharArray();
                            int kind = 0;
                            if (this.match(typeSuffix, packageName, typeName, typeMatchRule, kind, simpleName)) {
                                nameRequestor.acceptType(type.getFlags(), CharOperation.NO_CHAR, simpleName, enclosingTypeNames, path, null);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
    }

    public void searchAllTypeNames(char[][] qualifications, char[][] typeNames, int matchRule, int searchFor, IDLTKSearchScope scope, IRestrictedAccessTypeRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws ModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchAllTypeNames(char[][], char[][], int, int, IJavaSearchScope, IRestrictedAccessTypeRequestor, int, IProgressMonitor)");
            Util.verbose("\t- package name: " + (qualifications == null ? "null" : new String(CharOperation.concatWith(qualifications, ','))));
            Util.verbose("\t- type name: " + (typeNames == null ? "null" : new String(CharOperation.concatWith(typeNames, ','))));
            Util.verbose("\t- match rule: " + matchRule);
            Util.verbose("\t- search for: " + searchFor);
            Util.verbose("\t- scope: " + scope);
        }
    }

    public DLTKSearchParticipant getSearchParticipant(IModelElement element) {
        DLTKSearchParticipant par;
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit(element);
        if (toolkit != null && (par = DLTKLanguageManager.createSearchParticipant(toolkit.getNatureId())) != null) {
            return par;
        }
        return new DLTKSearchParticipant();
    }

    public void searchDeclarations(IModelElement enclosingElement, SearchRequestor requestor, SearchPattern pattern, IProgressMonitor monitor) throws ModelException {
        block14: {
            if (VERBOSE) {
                Util.verbose("\t- script element: " + enclosingElement);
            }
            IDLTKSearchScope scope = BasicSearchEngine.createSearchScope(new IModelElement[]{enclosingElement}, DLTKLanguageManager.getLanguageToolkit(enclosingElement));
            IResource resource = enclosingElement.getResource();
            if (enclosingElement instanceof IMember) {
                IMember member = (IMember)enclosingElement;
                ISourceModule cu = member.getSourceModule();
                if (cu != null) {
                    resource = cu.getResource();
                } else if (((IProjectFragment)member.getAncestor(3)).isExternal()) {
                    resource = null;
                }
            }
            try {
                if (resource instanceof IFile) {
                    try {
                        requestor.beginReporting();
                        if (VERBOSE) {
                            Util.verbose("Searching for " + pattern + " in " + resource.getFullPath());
                        }
                        DLTKSearchParticipant participant = this.getSearchParticipant(enclosingElement);
                        boolean external = false;
                        IProjectFragment fragment = (IProjectFragment)enclosingElement.getAncestor(3);
                        if (fragment != null) {
                            external = fragment.isExternal();
                        }
                        char[] contents = Util.getResourceContentsAsCharArray((IFile)resource);
                        SearchDocument[] documents = MatchLocator.addWorkingCopies(pattern, new SearchDocument[]{new DLTKSearchDocument(enclosingElement.getPath().toString(), contents, participant, external, enclosingElement.getScriptProject().getProject())}, this.getWorkingCopies(enclosingElement), participant);
                        ((SearchParticipant)participant).locateMatches(documents, pattern, scope, requestor, monitor);
                        break block14;
                    }
                    finally {
                        requestor.endReporting();
                    }
                }
                this.search(pattern, new SearchParticipant[]{BasicSearchEngine.getDefaultSearchParticipant()}, scope, requestor, monitor);
            }
            catch (CoreException e) {
                if (e instanceof ModelException) {
                    throw (ModelException)e;
                }
                throw new ModelException(e);
            }
        }
    }

    public void searchDeclarationsOfAccessedFields(IModelElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws ModelException {
    }

    public void searchDeclarationsOfReferencedTypes(IModelElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws ModelException {
    }

    public void searchDeclarationsOfSentMessages(IModelElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws ModelException {
    }

    public static MethodNameMatch createMethodNameMatch(IMethod method, int modifiers) {
        return new DLTKSearchMethodNameMatch(method, modifiers);
    }

    public void searchAllMethodNames(char[] methodName, int methodMatchRule, int searchFor, IDLTKSearchScope scope, final IRestrictedAccessMethodRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws ModelException {
        int copiesLength;
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchAllTypeNames(char[], char[], int, int, IJavaSearchScope, IRestrictedAccessTypeRequestor, int, IProgressMonitor)");
            Util.verbose("\t- method name: " + (methodName == null ? "null" : new String(methodName)));
            Util.verbose("\t- match rule: " + BasicSearchEngine.getMatchRuleString(methodMatchRule));
            Util.verbose("\t- search for: " + searchFor);
            Util.verbose("\t- scope: " + scope);
        }
        if (methodName != null && methodName.length == 0) {
            if (VERBOSE) {
                Util.verbose("\t=> return no result due to invalid empty values for package and type names!");
            }
            return;
        }
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        MethodDeclarationPattern pattern = new MethodDeclarationPattern(methodName, methodMatchRule, scope.getLanguageToolkit());
        final HashSet<String> workingCopyPaths = new HashSet<String>();
        String workingCopyPath = null;
        ISourceModule[] copies = this.getWorkingCopies();
        int n = copiesLength = copies == null ? 0 : copies.length;
        if (copies != null) {
            if (copiesLength == 1) {
                workingCopyPath = copies[0].getPath().toString();
            } else {
                int i = 0;
                while (i < copiesLength) {
                    ISourceModule workingCopy = copies[i];
                    workingCopyPaths.add(workingCopy.getPath().toString());
                    ++i;
                }
            }
        }
        final String singleWkcpPath = workingCopyPath;
        IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

            @Override
            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                MethodDeclarationPattern record = (MethodDeclarationPattern)indexRecord;
                switch (copiesLength) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (!singleWkcpPath.equals(documentPath)) break;
                        return true;
                    }
                    default: {
                        if (!workingCopyPaths.contains(documentPath)) break;
                        return true;
                    }
                }
                nameRequestor.acceptMethod(record.simpleName, documentPath);
                return true;
            }
        };
        try {
            if (progressMonitor != null) {
                progressMonitor.beginTask(Messages.engine_searching, 100);
            }
            indexManager.performConcurrentJob(new PatternSearchJob(pattern, BasicSearchEngine.getDefaultSearchParticipant(), scope, searchRequestor), waitingPolicy, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 100)));
            if (copies != null) {
                int i = 0;
                while (i < copiesLength) {
                    ISourceModule workingCopy = copies[i];
                    if (scope.encloses(workingCopy)) {
                        workingCopy.getPath().toString();
                        IType[] allTypes = workingCopy.getTypes();
                        int j = 0;
                        while (j < allTypes.length) {
                            IType type = allTypes[i];
                            IModelElement parent = type.getParent();
                            if (parent instanceof IType) {
                                char[] parentQualifiedName = ((IType)parent).getTypeQualifiedName().toCharArray();
                                CharOperation.splitOn('.', parentQualifiedName);
                            }
                            type.getElementName().toCharArray();
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
    }
}

