/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.core.mixin;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.mod.compiler.ISourceElementRequestor;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IParent;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.mixin.IMixinRequestor;

public class MixinSourceElementRequestor
implements ISourceElementRequestor {
    private List path = new ArrayList();
    private IMixinRequestor requestor;
    private boolean signature = false;
    private ISourceModule module;

    public MixinSourceElementRequestor(IMixinRequestor requestor, boolean signature, ISourceModule module) {
        this.requestor = requestor;
        this.signature = signature;
        this.module = module;
    }

    protected void enterElement(String path) {
        this.path.add(path);
    }

    private IModelElement getElement(IModelElement parent, int index) {
        if (this.path.size() == index) {
            return parent;
        }
        if (parent instanceof IParent) {
            IParent par = (IParent)((Object)parent);
            IModelElement[] children = null;
            try {
                children = par.getChildren();
            }
            catch (ModelException e) {
                e.printStackTrace();
                throw new RuntimeException((Throwable)((Object)e));
            }
            int i = 0;
            while (i < children.length) {
                IModelElement el;
                if (children[i].getElementName().equals(this.path.get(index)) && (el = this.getElement(children[i], index + 1)) != null) {
                    return el;
                }
                ++i;
            }
        }
        return null;
    }

    protected IModelElement getModelElement() {
        if (!this.signature) {
            return null;
        }
        if (this.path.size() == 0) {
            return this.module;
        }
        return this.getElement(this.module, 0);
    }

    protected void exitElement() {
        if (this.path.size() > 0) {
            this.path.remove(this.path.size() - 1);
        }
    }

    protected String getKey() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.path.size()) {
            buffer.append(this.path.get(i));
            if (i != this.path.size() - 1) {
                buffer.append(IMixinRequestor.MIXIN_NAME_SEPARATOR);
            }
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public void acceptFieldReference(char[] fieldName, int sourcePosition) {
    }

    @Override
    public void acceptMethodReference(char[] methodName, int argCount, int sourcePosition, int sourceEndPosition) {
    }

    @Override
    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
    }

    @Override
    public void acceptTypeReference(char[][] typeName, int sourceStart, int sourceEnd) {
    }

    @Override
    public void acceptTypeReference(char[] typeName, int sourcePosition) {
    }

    @Override
    public boolean enterFieldCheckDuplicates(ISourceElementRequestor.FieldInfo info) {
        return false;
    }

    @Override
    public boolean enterFieldWithParentType(ISourceElementRequestor.FieldInfo info, String parentName, String delimiter) {
        return false;
    }

    @Override
    public void enterMethodRemoveSame(ISourceElementRequestor.MethodInfo info) {
    }

    @Override
    public boolean enterMethodWithParentType(ISourceElementRequestor.MethodInfo info, String parentName, String delimiter) {
        return false;
    }

    @Override
    public void enterModule() {
    }

    @Override
    public void enterModuleRoot() {
    }

    @Override
    public boolean enterTypeAppend(String fullName, String delimiter) {
        return false;
    }

    @Override
    public void exitModule(int declarationEnd) {
    }

    @Override
    public void exitModuleRoot() {
    }

    @Override
    public void exitField(int declarationEnd) {
        this.exitElement();
    }

    @Override
    public void exitMethod(int declarationEnd) {
        this.exitElement();
    }

    @Override
    public void exitType(int declarationEnd) {
        this.exitElement();
    }

    @Override
    public void enterField(ISourceElementRequestor.FieldInfo info) {
        this.enterElement(info.name);
        IMixinRequestor.ElementInfo elInfo = new IMixinRequestor.ElementInfo();
        elInfo.key = this.getKey();
        if (this.signature) {
            elInfo.object = this.getModelElement();
        }
        this.requestor.reportElement(elInfo);
    }

    @Override
    public void enterMethod(ISourceElementRequestor.MethodInfo info) {
        this.enterElement(info.name);
        IMixinRequestor.ElementInfo elInfo = new IMixinRequestor.ElementInfo();
        elInfo.key = this.getKey();
        if (this.signature) {
            elInfo.object = this.getModelElement();
        }
        this.requestor.reportElement(elInfo);
    }

    @Override
    public void enterType(ISourceElementRequestor.TypeInfo info) {
        this.enterElement(info.name);
        IMixinRequestor.ElementInfo elInfo = new IMixinRequestor.ElementInfo();
        elInfo.key = this.getKey();
        if (this.signature) {
            elInfo.object = this.getModelElement();
        }
        this.requestor.reportElement(elInfo);
    }
}

