/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.core.internal.environment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.core.environment.IFileHandle;

public class EFSFileHandle
implements IFileHandle {
    private IFileStore file;
    private IEnvironment environment;

    public EFSFileHandle(IEnvironment env, IFileStore file) {
        this.environment = env;
        this.file = file;
    }

    @Override
    public boolean exists() {
        try {
            return this.file.fetchInfo().exists();
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    @Override
    public String toOSString() {
        return this.environment.convertPathToString(this.getPath());
    }

    @Override
    public String getCanonicalPath() {
        return this.environment.getCanonicalPath(this.getPath());
    }

    @Override
    public IFileHandle getChild(String childname) {
        return new EFSFileHandle(this.environment, this.file.getChild((IPath)new Path(childname)));
    }

    @Override
    public IFileHandle[] getChildren() {
        try {
            IFileStore[] files = this.file.childStores(0, null);
            IFileHandle[] children = new IFileHandle[files.length];
            int i = 0;
            while (i < files.length) {
                children[i] = new EFSFileHandle(this.environment, files[i]);
                ++i;
            }
            return children;
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public IEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public URI toURI() {
        return this.file.toURI();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public IFileHandle getParent() {
        IFileStore parent = this.file.getParent();
        if (parent == null) {
            return null;
        }
        return new EFSFileHandle(this.environment, parent);
    }

    @Override
    public IPath getPath() {
        return new Path(this.file.toURI().getPath());
    }

    @Override
    public boolean isDirectory() {
        return this.file.fetchInfo().isDirectory();
    }

    @Override
    public boolean isFile() {
        IFileInfo info = this.file.fetchInfo();
        return info.exists() && !info.isDirectory();
    }

    @Override
    public boolean isSymlink() {
        return this.file.fetchInfo().getAttribute(32);
    }

    @Override
    public InputStream openInputStream(IProgressMonitor monitor) throws IOException {
        try {
            return this.file.openInputStream(0, monitor);
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof EFSFileHandle) {
            EFSFileHandle anotherFile = (EFSFileHandle)obj;
            return this.file.equals(anotherFile.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.toOSString();
    }

    @Override
    public long lastModified() {
        return this.file.fetchInfo().getLastModified();
    }

    @Override
    public long length() {
        return this.file.fetchInfo().getLength();
    }

    @Override
    public IPath getFullPath() {
        return EnvironmentPathUtils.getFullPath(this.environment, this.getPath());
    }

    @Override
    public String getEnvironmentId() {
        return this.environment.getId();
    }
}

