/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.core;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

public class ScriptNature
implements IProjectNature {
    private IProject project;

    public void configure() throws CoreException {
        this.addToBuildSpec("org.eclipse.dltk.mod.core.scriptbuilder");
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec("org.eclipse.dltk.mod.core.scriptbuilder");
    }

    protected void addToBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        int scriptCommandIndex = this.getScriptCommandIndex(description.getBuildSpec());
        if (scriptCommandIndex == -1) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            this.setScriptCommand(description, command);
        }
    }

    private void setScriptCommand(IProjectDescription description, ICommand newCommand) throws CoreException {
        ICommand[] newCommands;
        ICommand[] oldBuildSpec = description.getBuildSpec();
        int oldScriptCommandIndex = this.getScriptCommandIndex(oldBuildSpec);
        if (oldScriptCommandIndex == -1) {
            newCommands = new ICommand[oldBuildSpec.length + 1];
            System.arraycopy(oldBuildSpec, 0, newCommands, 1, oldBuildSpec.length);
            newCommands[0] = newCommand;
        } else {
            oldBuildSpec[oldScriptCommandIndex] = newCommand;
            newCommands = oldBuildSpec;
        }
        description.setBuildSpec(newCommands);
        this.project.setDescription(description, null);
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    private int getScriptCommandIndex(ICommand[] buildSpec) {
        int i = 0;
        while (i < buildSpec.length) {
            if (buildSpec[i].getBuilderName().equals("org.eclipse.dltk.mod.core.scriptbuilder")) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }
}

