/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.dltk.mod.core.DLTKIdContributionSelector;
import org.eclipse.dltk.mod.core.PreferencesLookupDelegate;

public class PreferenceBasedContributionSelector
extends DLTKIdContributionSelector
implements IExecutableExtension {
    private static final String NODE_PARAM = "parameter";
    private static final String ATTR_NAME = "name";
    private static final String ATR_VALUE = "value";
    private static final String PARAM_QUALIFIER = "qualifier";
    private static final String PARAM_KEY = "key";
    private String qualifier;
    private String key;

    @Override
    protected String getSavedContributionId(PreferencesLookupDelegate delegate) {
        if (this.qualifier != null && this.key != null) {
            return delegate.getString(this.qualifier, this.key);
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        IConfigurationElement[] parameters = config.getChildren(NODE_PARAM);
        int i = 0;
        while (i < parameters.length) {
            IConfigurationElement parameter = parameters[i];
            String parameterName = parameter.getAttribute(ATTR_NAME);
            if (PARAM_QUALIFIER.equals(parameterName)) {
                this.qualifier = parameter.getAttribute(ATR_VALUE);
            } else if (PARAM_KEY.equals(parameterName)) {
                this.key = parameter.getAttribute(ATR_VALUE);
            }
            ++i;
        }
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

