/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsdebugger;

import org.eclipse.vjet.dsf.jsdebugger.ContextData;
import org.eclipse.vjet.dsf.jsdebugger.DebuggerAdapter;
import org.eclipse.vjet.dsf.jsdebugger.ObjectIdMapper;
import org.eclipse.vjet.dsf.jsdi.FunctionSource;
import org.eclipse.vjet.dsf.jsdi.SourceInfo;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.debug.DebugFrame;

public class StackFrame
implements DebugFrame {
    private DebuggerAdapter m_debugger;
    private ContextData m_contextData;
    private Scriptable m_scope;
    private Scriptable m_thisObj;
    private FunctionSource m_fsource;
    private boolean[] m_breakpoints;
    private int m_lineNumber;
    private ObjectIdMapper m_objCache = new ObjectIdMapper();

    StackFrame(Context cx, DebuggerAdapter dim, FunctionSource fsource) {
        this.m_debugger = dim;
        this.m_contextData = ContextData.get(cx);
        this.m_fsource = fsource;
        this.m_breakpoints = fsource.sourceInfo().getBreakpoints();
        this.m_lineNumber = fsource.firstLine();
    }

    public void onEnter(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        this.m_contextData.pushFrame(this);
        this.m_scope = scope;
        this.m_thisObj = thisObj;
        if (this.m_debugger.isBreakOnEnter()) {
            this.m_debugger.handleBreakpointHit(this, cx);
        }
    }

    public void onLineChange(Context cx, int lineno) {
        this.m_lineNumber = lineno;
        if (!this.m_breakpoints[lineno] && !this.m_debugger.shouldBreak()) {
            boolean lineBreak = this.m_contextData.isBreakNextLine();
            if (lineBreak && this.m_contextData.getStopAtFrameDepth() >= 0) {
                boolean bl = lineBreak = this.m_contextData.frameCount() <= this.m_contextData.getStopAtFrameDepth();
            }
            if (!lineBreak) {
                return;
            }
            this.m_contextData.setStopAtFrameDepth(-1);
            this.m_contextData.setBreakNextLine(false);
        }
        this.m_debugger.handleBreakpointHit(this, cx);
    }

    public void onExceptionThrown(Context cx, Throwable exception) {
        this.m_debugger.handleExceptionThrown(cx, exception, this);
    }

    public void onExit(Context cx, boolean byThrow, Object resultOrException) {
        if (this.m_debugger.isBreakOnReturn() && !byThrow) {
            this.m_debugger.handleBreakpointHit(this, cx);
        }
        this.m_contextData.popFrame();
    }

    public void onDebuggerStatement(Context cx) {
        this.m_debugger.handleBreakpointHit(this, cx);
    }

    public SourceInfo sourceInfo() {
        return this.m_fsource.sourceInfo();
    }

    public ContextData contextData() {
        return this.m_contextData;
    }

    public Scriptable scope() {
        return this.m_scope;
    }

    public Scriptable thisObj() {
        return this.m_thisObj;
    }

    public String getUrl() {
        return this.m_fsource.sourceInfo().getUri();
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public long getId(Object obj) {
        if (obj == this.m_thisObj) {
            return -3L;
        }
        if (obj == this.m_scope) {
            return -2L;
        }
        return this.m_objCache.getId(obj);
    }

    public Object getObject(long id) {
        if (id == -3L) {
            return this.m_thisObj;
        }
        if (id == -2L) {
            return this.m_scope;
        }
        return this.m_objCache.getObject(id);
    }

    public void clearObjectCache() {
        this.m_objCache.clear();
    }
}

