/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst;

import java.util.List;
import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstAttributedType;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.expr.FuncExpr;
import org.eclipse.vjet.dsf.jst.expr.JstInitializer;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jst.stmt.ExprStmt;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateCtx;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.BaseAst2JstTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletionOnMemberAccess;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletionOnSingleNameReference;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstTypeCompletion;

public class MethodDeclarationTranslator
extends BaseAst2JstTranslator<MethodDeclaration, ExprStmt> {
    private static final char DOT = '.';
    private static final String EMPTY = "";

    @Override
    protected ExprStmt doTranslate(MethodDeclaration astNode) {
        IJsCommentMeta mtdMeta;
        IJstType metaTyping;
        String methName = null;
        if (astNode.selector != null) {
            methName = String.valueOf(astNode.selector);
        }
        List<IJsCommentMeta> metaArr = this.getCommentMeta(astNode);
        JstMethod jstMethod = MethodDeclarationTranslator.createJstMethodFromMethodDeclAst(this.m_ctx, astNode, metaArr, methName);
        if (this.m_ctx.getCurrentScope() == ScopeIds.PROPS) {
            jstMethod.getModifiers().merge(8);
        }
        if (metaArr != null) {
            for (IJsCommentMeta meta : metaArr) {
                TranslateHelper.setReferenceSource(jstMethod, meta);
            }
        }
        FuncExpr funcExpr = new FuncExpr(jstMethod);
        if (metaArr != null && metaArr.size() > 0 && !metaArr.get(0).isMethod() && (metaTyping = TranslateHelper.findType(this.m_ctx, (mtdMeta = metaArr.get(0)).getTyping(), mtdMeta)) != null && (metaTyping instanceof JstAttributedType || metaTyping instanceof JstFunctionRefType)) {
            funcExpr.setType(metaTyping);
        }
        return new ExprStmt((IExpr)funcExpr);
    }

    public static JstMethod createJstMethodFromMethodDeclAst(TranslateCtx ctx, MethodDeclaration astMethodDeclaration, List<IJsCommentMeta> metaArr, String name) {
        JstMethod jstMethod = TranslateHelper.MethodTranslateHelper.createJstMethod(astMethodDeclaration, metaArr, ctx, name);
        JstBlock jstBlock = jstMethod.getBlock(true);
        JstSource methodSource = TranslateHelper.getSource((IASTNode)astMethodDeclaration, ctx.getSourceUtil());
        if (!ctx.isSkiptImplementation() && astMethodDeclaration.statements != null) {
            ctx.enterBlock(ScopeIds.METHOD);
            try {
                ctx.setPreviousNodeSourceEnd(astMethodDeclaration.sourceStart());
                jstBlock.setSource(methodSource);
                JstType refType = JstCache.getInstance().getType("Arguments");
                JstVars jstVar = new JstVars((IJstType)refType, new JstInitializer((ILHS)new JstIdentifier("arguments"), null));
                jstBlock.addChild((IJstNode)jstVar);
                TranslateHelper.addStatementsToJstBlock(astMethodDeclaration.statements, jstBlock, astMethodDeclaration.sourceEnd(), ctx);
            }
            finally {
                ctx.exitBlock();
            }
        }
        TranslateHelper.MethodTranslateHelper.addMethodCommentsAndSource(ctx, (IASTNode)astMethodDeclaration, jstMethod);
        return jstMethod;
    }

    public static boolean isNotCompleteExpression(TranslateCtx m_ctx, int statEnd) {
        return m_ctx.getOriginalSource()[statEnd] != ';';
    }

    private List<IJsCommentMeta> getCommentMeta(MethodDeclaration astMethodDeclaration) {
        int next = this.m_ctx.getNextNodeSourceStart();
        if (astMethodDeclaration != null) {
            if (astMethodDeclaration.statements != null && astMethodDeclaration.statements.length > 0) {
                next = astMethodDeclaration.statements[0].sourceStart();
            } else if (next <= 0) {
                next = astMethodDeclaration.bodyEnd;
            }
        }
        return this.m_ctx.getCommentCollector().getCommentMeta(astMethodDeclaration.bodyStart, this.m_ctx.getPreviousNodeSourceEnd(), next);
    }

    @Override
    protected JstCompletion createCompletion(MethodDeclaration astNode, boolean isAfterSource) {
        char c = this.m_ctx.getOriginalSource()[this.m_ctx.getCompletionPos() - 1];
        JstTypeCompletion completion = null;
        JstType type = this.m_ctx.getCurrentType();
        completion = c == '.' ? new JstCompletionOnMemberAccess((BaseJstNode)type) : new JstCompletionOnSingleNameReference((BaseJstNode)type);
        completion.setToken(EMPTY);
        this.m_ctx.setCreatedCompletion(true);
        completion.setScopeStack(this.m_ctx.getScopeStack());
        completion.pushScope(ScopeIds.METHOD);
        return completion;
    }
}

