/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.parser.comments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.vjet.dsf.jst.JstCommentLocation;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsCommentMeta;
import org.eclipse.vjet.dsf.jstojava.parser.comments.ParseException;
import org.eclipse.vjet.dsf.jstojava.parser.comments.VjComment;
import org.eclipse.vjet.dsf.jstojava.parser.comments.VjCommentUtil;
import org.eclipse.vjet.dsf.jstojava.report.ErrorReporter;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;

public class CommentCollector {
    private static final char NEWLINE = '\n';
    LinkedHashMap<Integer, CommentMetaWrapper> m_commentMetaMap = new LinkedHashMap();
    LinkedHashMap<Integer, CommentMetaWrapper> m_annotationMetaMap = new LinkedHashMap();
    LinkedHashMap<Integer, String> m_commentMap = new LinkedHashMap();
    int[][] commentOffsets;
    private String m_source = null;
    private char[] m_sourceChars;
    private int m_lastcommentOffset = 0;
    private List<InactiveNeedsWrapper> m_inactiveNeeds = new ArrayList<InactiveNeedsWrapper>(8);
    private int m_unstructuredCommentLastOffset = -1;

    public void handle(CompilationUnitDeclaration ast, ErrorReporter reporter, IFindTypeSupport.ILineInfoProvider jstSourceUtil) {
        this.commentOffsets = ast.comments;
        if (this.commentOffsets == null || this.commentOffsets.length == 0) {
            return;
        }
        this.m_source = String.valueOf(ast.compilationResult.compilationUnit.getContents());
        if (this.m_source == null) {
            return;
        }
        this.m_sourceChars = this.m_source.toCharArray();
        int[][] nArray = this.commentOffsets;
        int n = this.commentOffsets.length;
        int n2 = 0;
        while (n2 < n) {
            int[] ind = nArray[n2];
            int beginOffset = Math.abs(ind[0]);
            int endOffset = Math.abs(ind[1]);
            String comment = this.m_source.substring(beginOffset, endOffset);
            try {
                JsCommentMeta commentMeta = null;
                try {
                    if (VjCommentUtil.isVjetComment(comment)) {
                        commentMeta = VjComment.parse(comment);
                    }
                }
                catch (ParseException e) {
                    reporter.error("VJET comment error: " + e.getMessage() + " For comment :" + comment, new String(ast.getFileName()), beginOffset, endOffset, jstSourceUtil.line(beginOffset), jstSourceUtil.col(beginOffset));
                }
                if (commentMeta != null) {
                    commentMeta.setBeginOffset(beginOffset);
                    commentMeta.setEndOffset(endOffset);
                    if (commentMeta.getDirection() != null) {
                        int idx = beginOffset + 1;
                        if (commentMeta.getDirection().equals((Object)IJsCommentMeta.DIRECTION.BACK)) {
                            idx = endOffset - 1;
                        }
                        if (commentMeta.isAnnotation()) {
                            this.m_annotationMetaMap.put(idx, new CommentMetaWrapper(commentMeta));
                            if (commentMeta.getInactiveNeeds().size() > 0) {
                                for (String inactiveNeedTypeName : commentMeta.getInactiveNeeds()) {
                                    this.m_inactiveNeeds.add(new InactiveNeedsWrapper(inactiveNeedTypeName, beginOffset, endOffset));
                                }
                            }
                        } else {
                            this.m_commentMetaMap.put(idx, new CommentMetaWrapper(commentMeta));
                        }
                    }
                } else {
                    char c;
                    int start = beginOffset - 1;
                    String whiteSpace = "";
                    while (start >= 0 && (c = this.m_source.charAt(start)) != '\n') {
                        whiteSpace = String.valueOf(whiteSpace) + c;
                        --start;
                    }
                    String commentWithWhitespace = whiteSpace.trim().equals("") ? String.valueOf(whiteSpace) + comment : comment;
                    this.m_commentMap.put(beginOffset, commentWithWhitespace);
                }
            }
            catch (Throwable e) {
                reporter.error("VJET comment error: " + e.getMessage() + " For comment :" + comment, new String(ast.getFileName()), beginOffset, endOffset, jstSourceUtil.line(beginOffset), jstSourceUtil.col(beginOffset));
            }
            ++n2;
        }
    }

    public List<String> getComments(int previousEnd, int nextStart) {
        Set<Integer> keySet = this.m_commentMap.keySet();
        ArrayList<String> comments = new ArrayList<String>(3);
        if (nextStart < previousEnd) {
            return comments;
        }
        for (Integer key : keySet) {
            String current = this.m_commentMap.get(key);
            if (previousEnd >= key || nextStart < key) continue;
            comments.add(current);
        }
        return comments;
    }

    public List<JstCommentLocation> getCommentLocations(int previousEnd, int nextStart) {
        Set<Integer> keySet = this.m_commentMap.keySet();
        ArrayList<JstCommentLocation> comments = new ArrayList<JstCommentLocation>(3);
        if (nextStart < previousEnd) {
            return comments;
        }
        for (Integer key : keySet) {
            String current = this.m_commentMap.get(key);
            if (previousEnd >= key || nextStart < key) continue;
            comments.add(new JstCommentLocation(key.intValue(), key + current.length()));
        }
        return comments;
    }

    public List<InactiveNeedsWrapper> getInactiveNeeds() {
        return this.m_inactiveNeeds;
    }

    public List<IJsCommentMeta> getCommentMeta(int exprStart, int previousEnd, int nextStart) {
        return this.getCommentMeta(exprStart, exprStart, previousEnd, nextStart);
    }

    public List<IJsCommentMeta> getCommentMeta(int exprStart, int previousEnd, int nextStart, boolean ignoreUnsed) {
        return this.getCommentMeta(exprStart, exprStart, previousEnd, nextStart, ignoreUnsed);
    }

    public Collection<IJsCommentMeta> getCommentAllMeta() {
        ArrayList<IJsCommentMeta> m = new ArrayList<IJsCommentMeta>();
        for (CommentMetaWrapper wrap : this.m_commentMetaMap.values()) {
            m.add(wrap.m_meta);
        }
        return m;
    }

    public List<IJsCommentMeta> getCommentMeta(int exprStart, int exprEnd, int previousEnd, int nextStart) {
        return this.getCommentMeta(exprStart, exprEnd, previousEnd, nextStart, false);
    }

    public List<IJsCommentMeta> getCommentMeta(int exprStart, int exprEnd, int previousEnd, int nextStart, boolean ignoreUnsed) {
        ArrayList<IJsCommentMeta> comments = new ArrayList<IJsCommentMeta>();
        if (nextStart < previousEnd) {
            return comments;
        }
        Set<Integer> keySet = this.m_commentMetaMap.keySet();
        for (Integer key : keySet) {
            CommentMetaWrapper wrapper = this.m_commentMetaMap.get(key);
            IJsCommentMeta meta = wrapper.m_meta;
            if (this.isExists(comments, meta)) continue;
            if (key > previousEnd && key < exprStart && meta.getDirection().equals((Object)IJsCommentMeta.DIRECTION.FORWARD)) {
                if (ignoreUnsed) {
                    comments.add(meta);
                    continue;
                }
                if (wrapper.isUsed()) continue;
                wrapper.setUsed(true);
                comments.add(meta);
                continue;
            }
            if (key <= exprEnd || key > nextStart || !meta.getDirection().equals((Object)IJsCommentMeta.DIRECTION.BACK)) continue;
            if (ignoreUnsed) {
                comments.add(meta);
                continue;
            }
            if (wrapper.isUsed()) continue;
            wrapper.setUsed(true);
            comments.add(meta);
        }
        return comments;
    }

    public List<IJsCommentMeta> getAnnotationMeta(int exprStart, int previousEnd, int nextStart) {
        return this.getAnnotationMeta(exprStart, exprStart, previousEnd, nextStart);
    }

    public List<IJsCommentMeta> getAnnotationMeta(int exprStart, int exprEnd, int previousEnd, int nextStart) {
        ArrayList<IJsCommentMeta> comments = new ArrayList<IJsCommentMeta>();
        if (nextStart < previousEnd) {
            return comments;
        }
        Set<Integer> keySet = this.m_annotationMetaMap.keySet();
        for (Integer key : keySet) {
            CommentMetaWrapper wrapper = this.m_annotationMetaMap.get(key);
            IJsCommentMeta meta = wrapper.m_meta;
            if (this.isExists(comments, meta)) continue;
            if (key > previousEnd && key < exprStart && meta.getDirection().equals((Object)IJsCommentMeta.DIRECTION.FORWARD)) {
                comments.add(meta);
                continue;
            }
            if (key <= exprEnd || key >= nextStart || !meta.getDirection().equals((Object)IJsCommentMeta.DIRECTION.BACK)) continue;
            comments.add(meta);
        }
        return comments;
    }

    public List<String> getCommentNonMeta(int methodStartOffset, int previousOffset) {
        int lastCommentOffset = previousOffset;
        ArrayList<String> comments = new ArrayList<String>();
        while (lastCommentOffset <= methodStartOffset) {
            String com = this.m_commentMap.get(lastCommentOffset);
            if (com != null) {
                Collections.addAll(comments, com.split("\n"));
            }
            ++lastCommentOffset;
        }
        return comments;
    }

    public List<JstCommentLocation> getCommentLocationNonMeta(int methodStartOffset, int previousOffset) {
        int lastCommentOffset = previousOffset;
        ArrayList<JstCommentLocation> comments = new ArrayList<JstCommentLocation>();
        while (lastCommentOffset <= methodStartOffset) {
            String com = this.m_commentMap.get(lastCommentOffset);
            if (com != null) {
                comments.add(new JstCommentLocation(lastCommentOffset, lastCommentOffset + com.length()));
            }
            ++lastCommentOffset;
        }
        return comments;
    }

    public String getCommentNonMeta2(int methodStartOffset) {
        if (methodStartOffset - this.m_unstructuredCommentLastOffset > 100 && methodStartOffset > 100) {
            this.m_unstructuredCommentLastOffset = methodStartOffset - 100;
        }
        int i = methodStartOffset;
        while (i > this.m_unstructuredCommentLastOffset) {
            CommentMetaWrapper wrapper = this.m_commentMetaMap.get(i);
            String com = this.m_commentMap.get(i);
            if (wrapper == null && com != null) {
                this.m_unstructuredCommentLastOffset = methodStartOffset;
                return com;
            }
            --i;
        }
        return null;
    }

    public JstCommentLocation getCommentLocationNonMeta2(int methodStartOffset) {
        int i = methodStartOffset;
        while (i > this.m_unstructuredCommentLastOffset) {
            CommentMetaWrapper wrapper = this.m_commentMetaMap.get(i);
            String com = this.m_commentMap.get(i);
            if (wrapper == null && com != null) {
                this.m_unstructuredCommentLastOffset = methodStartOffset;
                return new JstCommentLocation(i, i + com.length());
            }
            --i;
        }
        return null;
    }

    public IJsCommentMeta getLocalVariableCommentMeta(int varStart, int varEnd) {
        if (this.m_source == null) {
            return null;
        }
        char[] source = this.m_sourceChars;
        int startOffset = this.getStartOffset(source, varStart);
        int endOffset = this.getEndOffset(source, varEnd);
        Set<Integer> keySet = this.m_commentMetaMap.keySet();
        for (Integer key : keySet) {
            CommentMetaWrapper wrapper = this.m_commentMetaMap.get(key);
            IJsCommentMeta jsCommentMeta = wrapper.m_meta;
            if (key > startOffset && key < varStart && jsCommentMeta.getDirection().equals((Object)IJsCommentMeta.DIRECTION.FORWARD)) {
                return this.m_commentMetaMap.get(key).m_meta;
            }
            if (key <= varEnd || key >= endOffset || !jsCommentMeta.getDirection().equals((Object)IJsCommentMeta.DIRECTION.BACK)) continue;
            return this.m_commentMetaMap.get(key).m_meta;
        }
        return null;
    }

    public int[] getLocalVariableCommentPrevNextOffsets(int varStart, int varEnd) {
        if (this.m_source == null) {
            return new int[]{varStart, varEnd};
        }
        char[] source = this.m_sourceChars;
        int startOffset = this.getStartOffset(source, varStart);
        int endOffset = this.getEndOffset(source, varEnd);
        return new int[]{startOffset, endOffset};
    }

    public int getCommentNonMetaBeginOffset(String comment) {
        Set<Integer> keySet = this.m_commentMap.keySet();
        for (Integer key : keySet) {
            String current = this.m_commentMap.get(key);
            if (!current.equals(comment)) continue;
            return key;
        }
        return -1;
    }

    private int getStartOffset(char[] originalSource, int startOffSet) {
        int i = startOffSet;
        while (i >= 0) {
            if (originalSource[i] == '{' && !this.checkIfInCommented(i)) {
                return i;
            }
            if (originalSource[i] == 'r' && i - 3 >= 0 && originalSource[i - 1] == 'a' && originalSource[i - 2] == 'v' && (Character.isWhitespace(originalSource[i - 3]) || originalSource[i - 3] == '{' || originalSource[i - 3] == ';') && !this.checkIfInCommented(i)) {
                return i;
            }
            if (originalSource[i] == 'r' && i == 2 && originalSource[i - 1] == 'a' && originalSource[i - 2] == 'v' && !this.checkIfInCommented(i)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private int getEndOffset(char[] originalSource, int endOffSet) {
        int i = endOffSet;
        while (i < originalSource.length) {
            char ch = originalSource[i];
            if (ch == '}' && !this.checkIfInCommented(i)) {
                return i;
            }
            if (ch == '.' && !this.checkIfInCommented(i)) {
                return i;
            }
            if (i + "var ".length() < originalSource.length && "var ".equals(String.valueOf(Arrays.copyOfRange(originalSource, i, i + "var ".length()))) && !this.checkIfInCommented(i)) {
                return i;
            }
            if (i + "function ".length() < originalSource.length && "function ".equals(String.valueOf(Arrays.copyOfRange(originalSource, i, i + "function ".length()))) && !this.checkIfInCommented(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean checkIfInCommented(int i) {
        if (this.commentOffsets == null) {
            return false;
        }
        int[][] nArray = this.commentOffsets;
        int n = this.commentOffsets.length;
        int n2 = 0;
        while (n2 < n) {
            int[] ind = nArray[n2];
            int beginOffset = Math.abs(ind[0]);
            int endOffset = Math.abs(ind[1]);
            if (i >= beginOffset && i <= endOffset) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isEqual(IJsCommentMeta source, IJsCommentMeta target) {
        return false;
    }

    private boolean isExists(ArrayList<IJsCommentMeta> list, IJsCommentMeta comment) {
        for (IJsCommentMeta meta : list) {
            if (!this.isEqual(meta, comment)) continue;
            return true;
        }
        return false;
    }

    class CommentMetaWrapper {
        private IJsCommentMeta m_meta;
        private boolean m_used;

        public CommentMetaWrapper(IJsCommentMeta meta) {
            this.m_meta = meta;
        }

        public void setUsed(boolean b) {
            this.m_used = b;
        }

        public boolean isUsed() {
            return this.m_used;
        }
    }

    public static class InactiveNeedsWrapper {
        private final String m_needsTypeName;
        private final int m_beginOffset;
        private final int m_endOffset;

        public InactiveNeedsWrapper(String needsTypeName, int beginOffset, int endOffset) {
            this.m_needsTypeName = needsTypeName;
            this.m_beginOffset = beginOffset;
            this.m_endOffset = endOffset;
        }

        public String getNeedsTypeName() {
            return this.m_needsTypeName;
        }

        public int getBeginOffset() {
            return this.m_beginOffset;
        }

        public int getEndOffset() {
            return this.m_endOffset;
        }
    }
}

