/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.oauth;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Random;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public abstract class OAuthParameters {
    public static final String PROP_SERVICE = ".oauth.service";
    public static final String PROP_EXPECTED_CALLBACK = ".oauth.expected.callback";
    public static final String PROP_SCOPES = ".oauth.scopes";
    public static final String PROP_CLIENT_ID = ".oauth.client.id";
    public static final String PROP_CLIENT_SECRET = ".oauth.client.secret";
    public static final String PROP_CLIENT_KEY = ".oauth.client.key";
    public static final String DEFAULT_SERVICE = "https://accounts.eclipse.org/";
    public static final String DEFAULT_EXPECTED_CALLBACK = "http://localhost/";
    private static final String[] DEFAULT_SCOPES = new String[]{"profile", "uss_retrieve", "uss_update"};
    private final BundleContext bundleContext = Platform.isRunning() ? FrameworkUtil.getBundle(this.getClass()).getBundleContext() : null;

    protected OAuthParameters() {
    }

    protected abstract String getServiceName();

    String getDecryptedClientID() {
        return this.getDecryptedValue(String.valueOf(this.getServiceName()) + PROP_CLIENT_ID, this.getDefaultClientId());
    }

    protected abstract String getDefaultClientId();

    String getDecryptedClientSecret() {
        return this.getDecryptedValue(String.valueOf(this.getServiceName()) + PROP_CLIENT_SECRET, this.getDefaultClientSecret());
    }

    protected abstract String getDefaultClientSecret();

    public URI getService() {
        String serviceAddress = this.getProperty(String.valueOf(this.getServiceName()) + PROP_SERVICE, this.getDefaultService());
        return URI.create(serviceAddress);
    }

    protected String getDefaultService() {
        return DEFAULT_SERVICE;
    }

    public URI getExpectedCallback() {
        String expectedCallbackAddress = this.getProperty(String.valueOf(this.getServiceName()) + PROP_EXPECTED_CALLBACK, this.getDefaultExpectedCallback());
        return URI.create(expectedCallbackAddress);
    }

    protected String getDefaultExpectedCallback() {
        return DEFAULT_EXPECTED_CALLBACK;
    }

    public String[] getScopes() {
        String scopesStr = this.getProperty(String.valueOf(this.getServiceName()) + PROP_SCOPES, null);
        return scopesStr != null ? OAuthParameters.initScopes(scopesStr) : this.getDefaultScopes();
    }

    protected String[] getDefaultScopes() {
        return DEFAULT_SCOPES;
    }

    protected abstract String getDefaultClientKey();

    private String getDecryptedValue(String propName, String defaultValue) {
        try {
            String property = this.getProperty(propName);
            if (!OAuthParameters.isEmpty(property)) {
                String key = this.getProperty(String.valueOf(this.getServiceName()) + PROP_CLIENT_KEY);
                if (!OAuthParameters.isEmpty(key)) {
                    return OAuthParameters.decrypt(property, key);
                }
                return property;
            }
        }
        catch (Throwable throwable) {}
        return OAuthParameters.decrypt(defaultValue, this.getDefaultClientKey());
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    protected final String getProperty(String propName) {
        return this.getProperty(propName, null);
    }

    protected String getProperty(String propName, String defaultValue) {
        String value;
        String string = value = this.bundleContext == null ? System.getProperty(propName) : this.bundleContext.getProperty(propName);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private static String decrypt(String str, String key) {
        byte[] keyBytes = OAuthParameters.hexToBytes(key);
        byte[] bytes = OAuthParameters.hexToBytes(str);
        byte[] result = new byte[bytes.length - 1];
        int j = bytes[result.length] - -128;
        OAuthParameters.crypt(bytes, result, keyBytes, result.length, j);
        try {
            return new String(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static byte[] hexToBytes(String hexStr) {
        int hexStrLen = hexStr.length();
        if ((hexStrLen & 1) == 1) {
            hexStr = String.valueOf('0') + hexStr;
            ++hexStrLen;
        }
        byte[] out = new byte[hexStrLen / 2];
        int i = 0;
        while (i < hexStrLen) {
            byte b1 = (byte)Character.digit(hexStr.charAt(i), 16);
            byte b2 = (byte)Character.digit(hexStr.charAt(i + 1), 16);
            if (b1 < 0 || b2 < 0) {
                throw new NumberFormatException(hexStr);
            }
            out[i / 2] = (byte)(b1 << 4 | b2 & 0xFF);
            i += 2;
        }
        return out;
    }

    private static String bytesToHex(byte[] bs) {
        StringBuilder builder = new StringBuilder(bs.length * 2);
        byte[] byArray = bs;
        int n = bs.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            builder.append(Character.forDigit(element >>> 4 & 0xF, 16));
            builder.append(Character.forDigit(element & 0xF, 16));
            ++n2;
        }
        return builder.toString();
    }

    private static byte[] encrypt(String str, byte[] key, Random random) throws UnsupportedEncodingException {
        byte[] bytes = str.getBytes("UTF-8");
        byte[] result = new byte[bytes.length + 1];
        int j = random.nextInt(key.length);
        result[bytes.length] = (byte)(j + -128);
        OAuthParameters.crypt(bytes, result, key, bytes.length, j);
        return result;
    }

    private static void crypt(byte[] bytes, byte[] result, byte[] key, int length, int j) {
        int i = 0;
        while (i < length) {
            result[i] = (byte)(bytes[i] ^ key[j++ % key.length]);
            ++i;
        }
    }

    private static String[] initScopes(String property) {
        try {
            if (!OAuthParameters.isEmpty(property)) {
                return property.split(",");
            }
        }
        catch (Throwable throwable) {}
        return DEFAULT_SCOPES;
    }

    public static void main(String[] args) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("Client ID: ");
        String clientID = reader.readLine();
        System.out.print("Client Secret: ");
        String clientSecret = reader.readLine();
        int keyLength = Math.max(clientID.length(), clientSecret.length());
        byte[] key = new byte[keyLength];
        Random random = new Random(System.currentTimeMillis());
        random.nextBytes(key);
        clientID = OAuthParameters.bytesToHex(OAuthParameters.encrypt(clientID, key, random));
        clientSecret = OAuthParameters.bytesToHex(OAuthParameters.encrypt(clientSecret, key, random));
        String clientKey = OAuthParameters.bytesToHex(key);
        System.out.println();
        System.out.println("private static final String CLIENT_ID = \"" + clientID + "\";");
        System.out.println("private static final String CLIENT_SECRET = \"" + clientSecret + "\";");
        System.out.println("private static final String CLIENT_KEY = \"" + clientKey + "\";");
        System.out.println();
    }
}

