/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph;

import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.AggregatedCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.AggregatedCalledFunctionStatistics;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.SymbolAspect;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;

public class FlamegraphEvent
extends TimeEvent {
    private final Object fSymbol;
    private final long fSelfTime;
    private final int fProcessId;
    private final AggregatedCalledFunctionStatistics fStatistics;

    public FlamegraphEvent(ITimeGraphEntry source, long beginTime, AggregatedCalledFunction aggregatedFunction) {
        super(source, beginTime, aggregatedFunction.getDuration(), aggregatedFunction.getSymbol().hashCode());
        this.fSymbol = aggregatedFunction.getSymbol();
        this.fStatistics = aggregatedFunction.getFunctionStatistics();
        this.fProcessId = aggregatedFunction.getProcessId();
        this.fSelfTime = aggregatedFunction.getSelfTime();
    }

    public Object getSymbol() {
        return this.fSymbol;
    }

    public AggregatedCalledFunctionStatistics getStatistics() {
        return this.fStatistics;
    }

    public long getSelfTime() {
        return this.fSelfTime;
    }

    public int getProcessId() {
        return this.fProcessId;
    }

    public String getLabel() {
        return this.getFunctionSymbol();
    }

    private String getFunctionSymbol() {
        String funcSymbol = "";
        if (this.getSymbol() instanceof Long || this.getSymbol() instanceof Integer) {
            ICalledFunction segment = (ICalledFunction)this.getStatistics().getDurationStatistics().getMinObject();
            if (segment == null) {
                long longAddress = (Long)this.getSymbol();
                return "0x" + Long.toHexString(longAddress);
            }
            Object symbol = SymbolAspect.SYMBOL_ASPECT.resolve((ISegment)segment);
            if (symbol != null) {
                return symbol.toString();
            }
        } else {
            return this.getSymbol().toString();
        }
        return funcSymbol;
    }
}

