/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.registry.ITMResource;

public class TMResource
implements ITMResource {
    private static final String PLATFORM_PLUGIN = "platform:/plugin/";
    private String path;
    private @Nullable String pluginId;

    public TMResource() {
        this.path = "<set-by-gson>";
    }

    public TMResource(String path) {
        this.path = path;
    }

    public TMResource(IConfigurationElement ce) {
        this(ce.getAttribute("path"));
        this.pluginId = ce.getNamespaceIdentifier();
    }

    public TMResource(String path, @Nullable String pluginId) {
        this.path = path;
        this.pluginId = pluginId;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public @Nullable String getPluginId() {
        return this.pluginId;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.pluginId != null ? new URL(PLATFORM_PLUGIN + this.pluginId + "/" + this.path).openStream() : new FileInputStream(new File(this.path));
    }

    protected @Nullable String getResourceContent() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = this.getInputStream();){
                return TMResource.convertStreamToString(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String convertStreamToString(InputStream is) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Scanner s = new Scanner(is);){
            s.useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

