/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.supports;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.languageconfiguration.internal.supports.AutoClosingPairConditional;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CharacterPair;

public final class CharacterPairSupport {
    private List<CharacterPair> autoClosingPairs;
    private final List<CharacterPair> surroundingPairs;

    public CharacterPairSupport(@Nullable List<CharacterPair> brackets, @Nullable List<AutoClosingPairConditional> autoClosingPairs, @Nullable List<CharacterPair> surroundingPairs) {
        this.autoClosingPairs = autoClosingPairs != null ? autoClosingPairs.stream().filter(Objects::nonNull).map(el -> new AutoClosingPairConditional((String)el.getKey(), (String)el.getValue(), el.getNotIn())).collect(Collectors.toList()) : (brackets != null ? brackets.stream().filter(Objects::nonNull).map(el -> new AutoClosingPairConditional((String)el.getKey(), (String)el.getValue(), null)).collect(Collectors.toList()) : new ArrayList<CharacterPair>());
        this.surroundingPairs = surroundingPairs != null ? surroundingPairs.stream().filter(Objects::nonNull).collect(Collectors.toList()) : this.autoClosingPairs;
    }

    public @Nullable CharacterPair getAutoClosePair(String text, int offset, String newCharacter) {
        if (newCharacter.isEmpty()) {
            return null;
        }
        for (CharacterPair autoClosingPair : this.autoClosingPairs) {
            String offsetPrefix;
            String opening = (String)autoClosingPair.getKey();
            if (!opening.endsWith(newCharacter) || opening.length() > 1 && !(offsetPrefix = text.substring(0, offset)).endsWith(opening.substring(0, opening.length() - 1))) continue;
            return autoClosingPair;
        }
        return null;
    }

    public List<CharacterPair> getAutoClosingPairs() {
        return this.autoClosingPairs;
    }

    public List<CharacterPair> getSurroundingPairs() {
        return this.surroundingPairs;
    }
}

