/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.oniguruma.OnigCaptureIndex;
import org.eclipse.tm4e.core.internal.rule.CaptureRule;
import org.eclipse.tm4e.core.internal.rule.CompilePatternsResult;
import org.eclipse.tm4e.core.internal.rule.CompiledRule;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.RegExpSource;
import org.eclipse.tm4e.core.internal.rule.RegExpSourceList;
import org.eclipse.tm4e.core.internal.rule.Rule;

public final class BeginWhileRule
extends Rule {
    private final RegExpSource begin;
    public final List<@Nullable CaptureRule> beginCaptures;
    public final List<@Nullable CaptureRule> whileCaptures;
    private final RegExpSource _while;
    public final boolean whileHasBackReferences;
    final boolean hasMissingPatterns;
    final int[] patterns;
    private @Nullable RegExpSourceList cachedCompiledPatterns;
    private @Nullable RegExpSourceList cachedCompiledWhilePatterns;

    BeginWhileRule(int id, @Nullable String name, @Nullable String contentName, String begin, List<@Nullable CaptureRule> beginCaptures, String _while, List<@Nullable CaptureRule> whileCaptures, CompilePatternsResult patterns) {
        super(id, name, contentName);
        this.begin = new RegExpSource(begin, this.id);
        this.beginCaptures = beginCaptures;
        this.whileCaptures = whileCaptures;
        this._while = new RegExpSource(_while, -2);
        this.whileHasBackReferences = this._while.hasBackReferences;
        this.patterns = patterns.patterns;
        this.hasMissingPatterns = patterns.hasMissingPatterns;
    }

    public String getWhileWithResolvedBackReferences(String lineText, OnigCaptureIndex[] captureIndices) {
        return this._while.resolveBackReferences(lineText, captureIndices);
    }

    @Override
    public void collectPatternsRecursive(IRuleRegistry grammar, RegExpSourceList out, boolean isFirst) {
        if (isFirst) {
            int[] nArray = this.patterns;
            int n = this.patterns.length;
            int n2 = 0;
            while (n2 < n) {
                int pattern = nArray[n2];
                Rule rule = grammar.getRule(pattern);
                rule.collectPatternsRecursive(grammar, out, false);
                ++n2;
            }
        } else {
            out.add(this.begin);
        }
    }

    @Override
    public CompiledRule compile(IRuleRegistry grammar, @Nullable String endRegexSource) {
        return this.getCachedCompiledPatterns(grammar).compile();
    }

    @Override
    public CompiledRule compileAG(IRuleRegistry grammar, @Nullable String endRegexSource, boolean allowA, boolean allowG) {
        return this.getCachedCompiledPatterns(grammar).compileAG(allowA, allowG);
    }

    private RegExpSourceList getCachedCompiledPatterns(IRuleRegistry grammar) {
        RegExpSourceList cachedCompiledPatterns = this.cachedCompiledPatterns;
        if (cachedCompiledPatterns == null) {
            cachedCompiledPatterns = new RegExpSourceList();
            this.collectPatternsRecursive(grammar, cachedCompiledPatterns, true);
            this.cachedCompiledPatterns = cachedCompiledPatterns;
        }
        return cachedCompiledPatterns;
    }

    public CompiledRule compileWhile(@Nullable String endRegexSource) {
        return this.getCachedCompiledWhilePatterns(endRegexSource).compile();
    }

    public CompiledRule compileWhileAG(@Nullable String endRegexSource, boolean allowA, boolean allowG) {
        return this.getCachedCompiledWhilePatterns(endRegexSource).compileAG(allowA, allowG);
    }

    private RegExpSourceList getCachedCompiledWhilePatterns(@Nullable String endRegexSource) {
        RegExpSourceList cachedCompiledWhilePatterns = this.cachedCompiledWhilePatterns;
        if (cachedCompiledWhilePatterns == null) {
            cachedCompiledWhilePatterns = new RegExpSourceList();
            cachedCompiledWhilePatterns.add(this.whileHasBackReferences ? this._while.clone() : this._while);
            if (this.whileHasBackReferences) {
                cachedCompiledWhilePatterns.setSource(0, endRegexSource != null ? endRegexSource : "\uffff");
            }
            this.cachedCompiledWhilePatterns = cachedCompiledWhilePatterns;
        }
        return cachedCompiledWhilePatterns;
    }
}

