/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.oniguruma;

import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.internal.oniguruma.OnigResult;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.WarnCallback;
import org.joni.exception.SyntaxException;

final class OnigRegExp {
    private @Nullable OnigString lastSearchString;
    private int lastSearchPosition = -1;
    private @Nullable OnigResult lastSearchResult;
    private final Regex regex;

    OnigRegExp(String source) {
        byte[] pattern = source.getBytes(StandardCharsets.UTF_8);
        try {
            this.regex = new Regex(pattern, 0, pattern.length, 256, (Encoding)UTF8Encoding.INSTANCE, Syntax.DEFAULT, WarnCallback.DEFAULT);
        }
        catch (SyntaxException ex) {
            throw new TMException("Parsing regex pattern \"" + source + "\" failed with " + (Object)((Object)ex), ex);
        }
    }

    @Nullable OnigResult search(OnigString str, int position) {
        OnigResult theLastSearchResult = this.lastSearchResult;
        if (this.lastSearchString == str && this.lastSearchPosition <= position && (theLastSearchResult == null || theLastSearchResult.locationAt(0) >= position)) {
            return theLastSearchResult;
        }
        this.lastSearchString = str;
        this.lastSearchPosition = position;
        this.lastSearchResult = this.search(str.bytesUTF8, position, str.bytesCount);
        return this.lastSearchResult;
    }

    private @Nullable OnigResult search(byte[] data, int position, int end) {
        Matcher matcher = this.regex.matcher(data);
        int status = matcher.search(position, end, 0);
        if (status != -1) {
            Region region = matcher.getEagerRegion();
            return new OnigResult(region, -1);
        }
        return null;
    }
}

