/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.grammar.Grammar;
import org.eclipse.tm4e.core.internal.grammar.Injection;
import org.eclipse.tm4e.core.internal.grammar.LineTokens;
import org.eclipse.tm4e.core.internal.grammar.LocalStackElement;
import org.eclipse.tm4e.core.internal.grammar.ScopeListElement;
import org.eclipse.tm4e.core.internal.grammar.StackElement;
import org.eclipse.tm4e.core.internal.oniguruma.OnigCaptureIndex;
import org.eclipse.tm4e.core.internal.oniguruma.OnigNextMatchResult;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;
import org.eclipse.tm4e.core.internal.rule.BeginEndRule;
import org.eclipse.tm4e.core.internal.rule.BeginWhileRule;
import org.eclipse.tm4e.core.internal.rule.CaptureRule;
import org.eclipse.tm4e.core.internal.rule.CompiledRule;
import org.eclipse.tm4e.core.internal.rule.MatchRule;
import org.eclipse.tm4e.core.internal.rule.Rule;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;

final class LineTokenizer {
    private static final System.Logger LOGGER = System.getLogger(LineTokenizer.class.getName());
    private final Grammar grammar;
    private final OnigString lineText;
    private boolean isFirstLine;
    private int linePos;
    private StackElement stack;
    private final LineTokens lineTokens;
    private int anchorPosition = -1;
    private boolean stop;

    private LineTokenizer(Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StackElement stack, LineTokens lineTokens) {
        this.grammar = grammar;
        this.lineText = lineText;
        this.isFirstLine = isFirstLine;
        this.linePos = linePos;
        this.stack = stack;
        this.lineTokens = lineTokens;
    }

    private StackElement scan(boolean checkWhileConditions) {
        this.stop = false;
        if (checkWhileConditions) {
            WhileCheckResult whileCheckResult = this.checkWhileConditions(this.grammar, this.lineText, this.isFirstLine, this.linePos, this.stack, this.lineTokens);
            this.stack = whileCheckResult.stack;
            this.linePos = whileCheckResult.linePos;
            this.isFirstLine = whileCheckResult.isFirstLine;
            this.anchorPosition = whileCheckResult.anchorPosition;
        }
        while (!this.stop) {
            this.scanNext();
        }
        return this.stack;
    }

    private void scanNext() {
        boolean hasAdvanced;
        LOGGER.log(System.Logger.Level.TRACE, () -> "@@scanNext: |" + this.lineText.string.replace("\n", "\\n").substring(this.linePos) + '|');
        IMatchResult r = this.matchRuleOrInjections(this.grammar, this.lineText, this.isFirstLine, this.linePos, this.stack, this.anchorPosition);
        if (r == null) {
            LOGGER.log(System.Logger.Level.TRACE, " no more matches.");
            this.lineTokens.produce(this.stack, this.lineText.bytesCount);
            this.stop = true;
            return;
        }
        OnigCaptureIndex[] captureIndices = r.getCaptureIndices();
        int matchedRuleId = r.getMatchedRuleId();
        boolean bl = hasAdvanced = captureIndices.length > 0 && captureIndices[0].end > this.linePos;
        if (matchedRuleId == -1) {
            BeginEndRule poppedRule = (BeginEndRule)this.stack.getRule(this.grammar);
            this.lineTokens.produce(this.stack, captureIndices[0].start);
            this.stack = this.stack.setContentNameScopesList(this.stack.nameScopesList);
            this.handleCaptures(this.grammar, this.lineText, this.isFirstLine, this.stack, this.lineTokens, poppedRule.endCaptures, captureIndices);
            this.lineTokens.produce(this.stack, captureIndices[0].end);
            StackElement popped = this.stack;
            this.stack = NullSafetyHelper.castNonNull(this.stack.pop());
            this.anchorPosition = popped.getAnchorPos();
            if (!hasAdvanced && popped.getEnterPos() == this.linePos) {
                LOGGER.log(System.Logger.Level.INFO, "[1] - Grammar is in an endless loop - Grammar pushed & popped a rule without advancing");
                this.stack = popped;
                this.lineTokens.produce(this.stack, this.lineText.bytesCount);
                this.stop = true;
                return;
            }
        } else if (captureIndices.length > 0) {
            Rule rule = this.grammar.getRule(matchedRuleId);
            this.lineTokens.produce(this.stack, captureIndices[0].start);
            StackElement beforePush = this.stack;
            String scopeName = rule.getName(this.lineText.string, captureIndices);
            ScopeListElement nameScopesList = this.stack.contentNameScopesList.push(this.grammar, scopeName);
            this.stack = this.stack.push(matchedRuleId, this.linePos, this.anchorPosition, captureIndices[0].end == this.lineText.bytesCount, null, nameScopesList, nameScopesList);
            if (rule instanceof BeginEndRule) {
                BeginEndRule pushedRule = (BeginEndRule)rule;
                this.handleCaptures(this.grammar, this.lineText, this.isFirstLine, this.stack, this.lineTokens, pushedRule.beginCaptures, captureIndices);
                this.lineTokens.produce(this.stack, captureIndices[0].end);
                this.anchorPosition = captureIndices[0].end;
                String contentName = pushedRule.getContentName(this.lineText.string, captureIndices);
                ScopeListElement contentNameScopesList = nameScopesList.push(this.grammar, contentName);
                this.stack = this.stack.setContentNameScopesList(contentNameScopesList);
                if (pushedRule.endHasBackReferences) {
                    this.stack = this.stack.setEndRule(pushedRule.getEndWithResolvedBackReferences(this.lineText.string, captureIndices));
                }
                if (!hasAdvanced && beforePush.hasSameRuleAs(this.stack)) {
                    LOGGER.log(System.Logger.Level.INFO, "[2] - Grammar is in an endless loop - Grammar pushed the same rule without advancing");
                    this.stack = NullSafetyHelper.castNonNull(this.stack.pop());
                    this.lineTokens.produce(this.stack, this.lineText.bytesCount);
                    this.stop = true;
                    return;
                }
            } else if (rule instanceof BeginWhileRule) {
                BeginWhileRule pushedRule = (BeginWhileRule)rule;
                this.handleCaptures(this.grammar, this.lineText, this.isFirstLine, this.stack, this.lineTokens, pushedRule.beginCaptures, captureIndices);
                this.lineTokens.produce(this.stack, captureIndices[0].end);
                this.anchorPosition = captureIndices[0].end;
                String contentName = pushedRule.getContentName(this.lineText.string, captureIndices);
                ScopeListElement contentNameScopesList = nameScopesList.push(this.grammar, contentName);
                this.stack = this.stack.setContentNameScopesList(contentNameScopesList);
                if (pushedRule.whileHasBackReferences) {
                    this.stack = this.stack.setEndRule(pushedRule.getWhileWithResolvedBackReferences(this.lineText.string, captureIndices));
                }
                if (!hasAdvanced && beforePush.hasSameRuleAs(this.stack)) {
                    LOGGER.log(System.Logger.Level.INFO, "[3] - Grammar is in an endless loop - Grammar pushed the same rule without advancing");
                    this.stack = NullSafetyHelper.castNonNull(this.stack.pop());
                    this.lineTokens.produce(this.stack, this.lineText.bytesCount);
                    this.stop = true;
                    return;
                }
            } else {
                MatchRule matchingRule = (MatchRule)rule;
                this.handleCaptures(this.grammar, this.lineText, this.isFirstLine, this.stack, this.lineTokens, matchingRule.captures, captureIndices);
                this.lineTokens.produce(this.stack, captureIndices[0].end);
                this.stack = NullSafetyHelper.castNonNull(this.stack.pop());
                if (!hasAdvanced) {
                    LOGGER.log(System.Logger.Level.INFO, "[4] - Grammar is in an endless loop - Grammar is not advancing, nor is it pushing/popping");
                    this.stack = this.stack.safePop();
                    this.lineTokens.produce(this.stack, this.lineText.bytesCount);
                    this.stop = true;
                    return;
                }
            }
        }
        if (captureIndices.length > 0 && captureIndices[0].end > this.linePos) {
            this.linePos = captureIndices[0].end;
            this.isFirstLine = false;
        }
    }

    private @Nullable IMatchResult matchRule(Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StackElement stack, int anchorPosition) {
        Rule rule = stack.getRule(grammar);
        final CompiledRule ruleScanner = rule.compileAG(grammar, stack.endRule, isFirstLine, linePos == anchorPosition);
        final OnigNextMatchResult r = ruleScanner.scanner.findNextMatchSync(lineText, linePos);
        if (r != null) {
            return new IMatchResult(){

                @Override
                public int getMatchedRuleId() {
                    return ruleScanner.rules[r.getIndex()];
                }

                @Override
                public OnigCaptureIndex[] getCaptureIndices() {
                    return r.getCaptureIndices();
                }
            };
        }
        return null;
    }

    private @Nullable IMatchResult matchRuleOrInjections(Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StackElement stack, int anchorPosition) {
        IMatchResult matchResult = this.matchRule(grammar, lineText, isFirstLine, linePos, stack, anchorPosition);
        List<Injection> injections = grammar.getInjections();
        if (injections.isEmpty()) {
            return matchResult;
        }
        IMatchInjectionsResult injectionResult = this.matchInjections(injections, grammar, lineText, isFirstLine, linePos, stack, anchorPosition);
        if (injectionResult == null) {
            return matchResult;
        }
        if (matchResult == null) {
            return injectionResult;
        }
        int injectionResultScore = injectionResult.getCaptureIndices()[0].start;
        int matchResultScore = matchResult.getCaptureIndices()[0].start;
        if (injectionResultScore < matchResultScore || injectionResult.isPriorityMatch() && injectionResultScore == matchResultScore) {
            return injectionResult;
        }
        return matchResult;
    }

    private @Nullable IMatchInjectionsResult matchInjections(List<Injection> injections, Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StackElement stack, int anchorPosition) {
        int bestMatchRating = Integer.MAX_VALUE;
        OnigCaptureIndex[] bestMatchCaptureIndices = null;
        int bestMatchRuleId = -1;
        int bestMatchResultPriority = 0;
        List<String> scopes = stack.contentNameScopesList.generateScopes();
        for (Injection injection : injections) {
            int matchRating;
            if (!injection.matches(scopes)) continue;
            CompiledRule ruleScanner = grammar.getRule(injection.ruleId).compileAG(grammar, null, isFirstLine, linePos == anchorPosition);
            OnigNextMatchResult matchResult = ruleScanner.scanner.findNextMatchSync(lineText, linePos);
            if (matchResult == null) continue;
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "  matched injection: " + injection.debugSelector);
                LOGGER.log(System.Logger.Level.TRACE, LineTokenizer.debugCompiledRuleToString(ruleScanner));
            }
            if ((matchRating = matchResult.getCaptureIndices()[0].start) > bestMatchRating) continue;
            bestMatchRating = matchRating;
            bestMatchCaptureIndices = matchResult.getCaptureIndices();
            bestMatchRuleId = ruleScanner.rules[matchResult.getIndex()];
            bestMatchResultPriority = injection.priority;
            if (bestMatchRating == linePos) break;
        }
        if (bestMatchCaptureIndices != null) {
            final int matchedRuleId = bestMatchRuleId;
            final OnigCaptureIndex[] matchCaptureIndices = bestMatchCaptureIndices;
            final boolean matchResultPriority = bestMatchResultPriority == -1;
            return new IMatchInjectionsResult(){

                @Override
                public int getMatchedRuleId() {
                    return matchedRuleId;
                }

                @Override
                public OnigCaptureIndex[] getCaptureIndices() {
                    return matchCaptureIndices;
                }

                @Override
                public boolean isPriorityMatch() {
                    return matchResultPriority;
                }
            };
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void handleCaptures(Grammar grammar, OnigString lineText, boolean isFirstLine, StackElement stack, LineTokens lineTokens, List<@Nullable CaptureRule> captures, OnigCaptureIndex[] captureIndices) {
        if (captures.isEmpty()) {
            return;
        }
        len = Math.min(captures.size(), captureIndices.length);
        localStack = new ArrayDeque<LocalStackElement>();
        maxEnd = captureIndices[0].end;
        i = 0;
        while (i < len) {
            block9: {
                captureRule = captures.get(i);
                if (captureRule == null || (captureIndex = captureIndices[i]).getLength() == 0) break block9;
                if (captureIndex.start <= maxEnd) ** GOTO lbl14
                break;
lbl-1000:
                // 1 sources

                {
                    lastElem = (LocalStackElement)localStack.removeLast();
                    lineTokens.produceFromScopes(lastElem.scopes, lastElem.endPos);
lbl14:
                    // 2 sources

                    ** while (!localStack.isEmpty() && ((LocalStackElement)localStack.getLast()).endPos <= captureIndex.start)
                }
lbl15:
                // 1 sources

                if (!localStack.isEmpty()) {
                    lineTokens.produceFromScopes(((LocalStackElement)localStack.getLast()).scopes, captureIndex.start);
                } else {
                    lineTokens.produce(stack, captureIndex.start);
                }
                retokenizeCapturedWithRuleId = captureRule.retokenizeCapturedWithRuleId;
                if (retokenizeCapturedWithRuleId != null) {
                    scopeName = captureRule.getName(lineText.string, captureIndices);
                    nameScopesList = stack.contentNameScopesList.push(grammar, scopeName);
                    contentName = captureRule.getContentName(lineText.string, captureIndices);
                    contentNameScopesList = nameScopesList.push(grammar, contentName);
                    stackClone = stack.push(retokenizeCapturedWithRuleId, captureIndex.start, -1, false, null, nameScopesList, contentNameScopesList);
                    onigSubStr = OnigString.of(lineText.string.substring(0, captureIndex.end));
                    LineTokenizer.tokenizeString(grammar, onigSubStr, isFirstLine != false && captureIndex.start == 0, captureIndex.start, stackClone, lineTokens, false);
                } else {
                    captureRuleScopeName = captureRule.getName(lineText.string, captureIndices);
                    if (captureRuleScopeName != null) {
                        base = localStack.isEmpty() != false ? stack.contentNameScopesList : ((LocalStackElement)localStack.getLast()).scopes;
                        captureRuleScopesList = base.push(grammar, captureRuleScopeName);
                        localStack.add(new LocalStackElement(captureRuleScopesList, captureIndex.end));
                    }
                }
            }
            ++i;
        }
        while (!localStack.isEmpty()) {
            lastElem = (LocalStackElement)localStack.removeLast();
            lineTokens.produceFromScopes(lastElem.scopes, lastElem.endPos);
        }
    }

    private WhileCheckResult checkWhileConditions(Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StackElement stack, LineTokens lineTokens) {
        int currentanchorPosition = stack.beginRuleCapturedEOL ? 0 : -1;
        ArrayList<WhileStack> whileRules = new ArrayList<WhileStack>();
        StackElement node = stack;
        while (node != null) {
            Rule nodeRule = node.getRule(grammar);
            if (nodeRule instanceof BeginWhileRule) {
                whileRules.add(new WhileStack(node, (BeginWhileRule)nodeRule));
            }
            node = node.pop();
        }
        int i = whileRules.size() - 1;
        while (i >= 0) {
            block6: {
                WhileStack whileRule;
                block5: {
                    whileRule = (WhileStack)whileRules.get(i);
                    CompiledRule ruleScanner = whileRule.rule.compileWhileAG(whileRule.stack.endRule, isFirstLine, currentanchorPosition == linePos);
                    OnigNextMatchResult r = ruleScanner.scanner.findNextMatchSync(lineText, linePos);
                    if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                        LOGGER.log(System.Logger.Level.TRACE, "  scanning for while rule");
                        LOGGER.log(System.Logger.Level.TRACE, LineTokenizer.debugCompiledRuleToString(ruleScanner));
                    }
                    if (r == null) break block5;
                    int matchedRuleId = ruleScanner.rules[r.getIndex()];
                    if (matchedRuleId != -2) {
                        stack = NullSafetyHelper.castNonNull(whileRule.stack.pop());
                        break;
                    }
                    if (r.getCaptureIndices().length <= 0) break block6;
                    lineTokens.produce(whileRule.stack, r.getCaptureIndices()[0].start);
                    this.handleCaptures(grammar, lineText, isFirstLine, whileRule.stack, lineTokens, whileRule.rule.whileCaptures, r.getCaptureIndices());
                    lineTokens.produce(whileRule.stack, r.getCaptureIndices()[0].end);
                    currentanchorPosition = r.getCaptureIndices()[0].end;
                    if (r.getCaptureIndices()[0].end <= linePos) break block6;
                    linePos = r.getCaptureIndices()[0].end;
                    isFirstLine = false;
                    break block6;
                }
                stack = NullSafetyHelper.castNonNull(whileRule.stack.pop());
                break;
            }
            --i;
        }
        return new WhileCheckResult(stack, linePos, currentanchorPosition, isFirstLine);
    }

    static StackElement tokenizeString(Grammar grammar, OnigString lineText, boolean isFirstLine, int linePos, StackElement stack, LineTokens lineTokens, boolean checkWhileConditions) {
        return new LineTokenizer(grammar, lineText, isFirstLine, linePos, stack, lineTokens).scan(checkWhileConditions);
    }

    static String debugCompiledRuleToString(CompiledRule ruleScanner) {
        ArrayList<String> r = new ArrayList<String>();
        int i = 0;
        int l = ruleScanner.rules.length;
        while (i < l) {
            r.add("   - " + ruleScanner.rules[i] + ": " + ruleScanner.debugRegExps.get(i));
            ++i;
        }
        return String.join((CharSequence)System.lineSeparator(), r);
    }

    private static interface IMatchInjectionsResult
    extends IMatchResult {
        public boolean isPriorityMatch();
    }

    private static interface IMatchResult {
        public OnigCaptureIndex[] getCaptureIndices();

        public int getMatchedRuleId();
    }

    private static final class WhileCheckResult {
        private final StackElement stack;
        private final int linePos;
        private final int anchorPosition;
        private final boolean isFirstLine;

        private WhileCheckResult(StackElement stack, int linePos, int anchorPosition, boolean isFirstLine) {
            this.stack = stack;
            this.linePos = linePos;
            this.anchorPosition = anchorPosition;
            this.isFirstLine = isFirstLine;
        }
    }

    private static final class WhileStack {
        private final StackElement stack;
        private final BeginWhileRule rule;

        private WhileStack(StackElement stack, BeginWhileRule rule) {
            this.stack = stack;
            this.rule = rule;
        }
    }
}

