/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.core;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.views.msc.ui.core.MSCNode;
import org.eclipse.titan.log.viewer.views.msc.ui.view.IGC;
import org.eclipse.titan.log.viewer.views.msc.util.MSCConstants;

public class SetverdictUnknown
extends MSCNode {
    private final String verdict;
    private int lifelines;

    public SetverdictUnknown(int eventOccurrence, String verdict) {
        super(eventOccurrence);
        this.verdict = verdict;
    }

    public void setNumLifelines(int lifelines) {
        this.lifelines = lifelines;
    }

    @Override
    public int getX() {
        return MSCConstants.COLUMN_WIDTH + 6;
    }

    @Override
    public int getY() {
        return MSCConstants.ROW_HEIGHT * this.getStartOccurrence() + 5;
    }

    @Override
    public int getWidth() {
        return this.lifelines * MSCConstants.COLUMN_WIDTH - 12 + 2;
    }

    @Override
    public int getHeight() {
        return MSCConstants.ROW_HEIGHT - 10 + 1;
    }

    @Override
    protected void draw(IGC context) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        context.setLineStyle(context.getLineSolidStyle());
        context.setLineWidth(1);
        context.setBackground((Color)Activator.getDefault().getCachedResource("COLOR_GREY"));
        context.fillRectangle(x + 1, y + 1, width, height);
        context.setBackground((Color)Activator.getDefault().getCachedResource(MSCConstants.getVerdictColor(this.verdict)));
        context.setGradientColor((Color)Activator.getDefault().getCachedResource("COLOR_WHITE"));
        context.fillGradientRectangle(x, y, width - 1, height - 1, true);
        context.setForeground((Color)Activator.getDefault().getCachedResource("COLOR_BLACK"));
        context.drawRectangle(x, y, width - 1, height - 1);
        context.setForeground((Color)Activator.getDefault().getCachedResource("COLOR_BLACK"));
        context.setFont((Font)Activator.getDefault().getCachedResource("FONT_DEFAULT"));
        context.drawTextTruncatedCentred(this.verdict, x, y, width - 1, height - 1, true);
    }

    @Override
    public MSCNode.Type getType() {
        return MSCNode.Type.SETVERDICT_UNKNOWN;
    }

    @Override
    public boolean positiveDistanceToPoint(int x, int y) {
        return true;
    }
}

