/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.logging;

import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewComponentDialog
extends Dialog {
    static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[0-9a-zA-Z_]+");
    private final Set<String> namesTaken;
    private Text nameText;
    private Label errorLabel;
    private String name;
    private final ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            NewComponentDialog.this.validate();
        }
    };

    public NewComponentDialog(Shell shell, Set<String> namesTaken) {
        super(shell);
        this.setShellStyle(shell.getStyle() | 0x10 | 0x8000);
        this.namesTaken = namesTaken;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create new component configuration.");
    }

    public String getName() {
        return this.name;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.errorLabel = new Label(container, 0);
        this.errorLabel.setLayoutData((Object)new GridData(768));
        this.errorLabel.setText("The name of the component must be a valid identifier or '*' for all valid components.");
        this.errorLabel.setVisible(false);
        Composite nameContainer = new Composite(parent, 0);
        nameContainer.setLayout((Layout)new GridLayout(2, false));
        nameContainer.setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (this.namesTaken.contains("new_component_" + i)) {
            ++i;
        }
        this.name = "new_component_" + i;
        Label label = new Label(nameContainer, 0);
        label.setText("The name of the new component: ");
        this.nameText = new Text(nameContainer, 2052);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.setText(this.name);
        this.nameText.addModifyListener(this.modifyListener);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void validate() {
        String temp = this.nameText.getText();
        if (this.namesTaken.contains(temp)) {
            this.getButton(0).setEnabled(false);
            this.errorLabel.setText("A component with this name already exists.");
            this.errorLabel.setVisible(true);
            return;
        }
        if ("*".equals(temp) || IDENTIFIER_PATTERN.matcher(temp).matches()) {
            this.getButton(0).setEnabled(true);
            this.errorLabel.setVisible(false);
            this.name = temp;
            return;
        }
        this.getButton(0).setEnabled(false);
        this.errorLabel.setText("The name of the component must be a valid identifier or '*' for all valid components.");
        this.errorLabel.setVisible(true);
    }
}

