/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.asn1editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.common.parsers.IntervalDetector;
import org.eclipse.titan.designer.editors.IHeuristicalIntervalDetector;

public final class HeuristicalIntervalDetector
extends IntervalDetector
implements IHeuristicalIntervalDetector {
    public Interval buildIntervals(IDocument document) {
        String text = document.get();
        int rangeEnd = text.length();
        this.initRootInterval(rangeEnd);
        int actualLine = 0;
        boolean insideString = false;
        try {
            block16: for (int nextPos = 0; nextPos < rangeEnd; ++nextPos) {
                switch (text.charAt(nextPos)) {
                    case '(': {
                        if (insideString || this.actualInterval.isComment()) continue block16;
                        this.pushInterval(nextPos, actualLine, Interval.interval_type.PARAMETER);
                        continue block16;
                    }
                    case ')': {
                        if (insideString || !Interval.interval_type.PARAMETER.equals((Object)this.actualInterval.getType())) continue block16;
                        this.popInterval(nextPos, actualLine);
                        continue block16;
                    }
                    case '[': {
                        if (insideString || this.actualInterval.isComment()) continue block16;
                        this.pushInterval(nextPos, actualLine, Interval.interval_type.INDEX);
                        continue block16;
                    }
                    case ']': {
                        if (insideString || !Interval.interval_type.INDEX.equals((Object)this.actualInterval.getType())) continue block16;
                        this.popInterval(nextPos, actualLine);
                        continue block16;
                    }
                    case '{': {
                        if (insideString || this.actualInterval.isComment()) continue block16;
                        this.pushInterval(nextPos, actualLine, Interval.interval_type.NORMAL);
                        continue block16;
                    }
                    case '}': {
                        if (insideString || !Interval.interval_type.NORMAL.equals((Object)this.actualInterval.getType())) continue block16;
                        this.popInterval(nextPos, actualLine);
                        continue block16;
                    }
                    case '/': {
                        if (insideString || this.actualInterval.isComment() || nextPos + 1 >= rangeEnd || '*' != text.charAt(nextPos)) continue block16;
                        this.pushInterval(nextPos, actualLine, Interval.interval_type.MULTILINE_COMMENT);
                        ++nextPos;
                        continue block16;
                    }
                    case '*': {
                        if (insideString || !Interval.interval_type.MULTILINE_COMMENT.equals((Object)this.actualInterval.getType()) || nextPos + 1 >= rangeEnd || '/' != text.charAt(nextPos + 1)) continue block16;
                        this.popInterval(nextPos, actualLine);
                        ++nextPos;
                        continue block16;
                    }
                    case '\"': {
                        if (nextPos - 1 <= 0 || '\\' == text.charAt(nextPos - 1) || this.actualInterval.isComment()) continue block16;
                        insideString = !insideString;
                        continue block16;
                    }
                    case '#': {
                        if (insideString || this.actualInterval.isComment()) continue block16;
                        this.pushInterval(nextPos, actualLine, Interval.interval_type.SINGLELINE_COMMENT);
                        continue block16;
                    }
                    case '-': {
                        if (nextPos + 1 >= rangeEnd || '-' != text.charAt(nextPos + 1) || insideString) continue block16;
                        if (Interval.interval_type.SINGLELINE_COMMENT.equals((Object)this.actualInterval.getType())) {
                            this.popInterval(nextPos, actualLine);
                        } else {
                            this.pushInterval(nextPos, actualLine, Interval.interval_type.SINGLELINE_COMMENT);
                        }
                        ++nextPos;
                        continue block16;
                    }
                    case '\n': {
                        if (Interval.interval_type.SINGLELINE_COMMENT.equals((Object)this.actualInterval.getType())) {
                            this.popInterval(nextPos, actualLine);
                        }
                        ++actualLine;
                        continue block16;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        this.handleFinalCorrection();
        return this.rootInterval;
    }

    @Override
    public boolean isWithinString(StringBuilder document, int offset, Interval enclosingInterval) throws BadLocationException {
        Interval interval = enclosingInterval.getSmallestEnclosingInterval(offset);
        if (Interval.interval_type.MULTILINE_COMMENT.equals((Object)interval.getType()) || Interval.interval_type.SINGLELINE_COMMENT.equals((Object)interval.getType())) {
            return false;
        }
        int counter = 0;
        for (int start = interval.getStartOffset(); start < offset; ++start) {
            char curr = document.charAt(start);
            if (curr != '\"') continue;
            ++counter;
        }
        return counter % 2 != 0;
    }
}

