/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ErroneousAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class Update_Statement
extends Statement {
    private static final String STATEMENT_NAME = "@update";
    private static final String FULLNAMEPART1 = ".ref";
    private static final String FULLNAMEPART2 = ".<attribpath>";
    private Reference ref;
    private MultipleWithAttributes attr;
    private ErroneousAttributes err_attrib;

    public Update_Statement(Reference reference, MultipleWithAttributes attributes) {
        if (reference != null) {
            this.ref = reference;
        }
        if (attributes != null) {
            this.attr = attributes;
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_UPDATE;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.ref == child) {
            return builder.append(FULLNAMEPART1);
        }
        builder.append(FULLNAMEPART2);
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.ref != null) {
            this.ref.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.ref != null) {
            this.ref.setCodeSection(codeSection);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        boolean useRuntime2 = false;
        try {
            if ("true".equals(this.getLocation().getFile().getProject().getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Function test runtime")))) {
                useRuntime2 = true;
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while reading persistent property", (Throwable)e);
        }
        if (this.myStatementBlock.isInDynamicTemplate()) {
            this.getLocation().reportSemanticError("The @update statement is not allowed in the statement block of a dynamic template");
            return;
        }
        if (this.myStatementBlock.isInGetterScope()) {
            this.getLocation().reportSemanticError("The @update statement is not allowed in the statement block of a property's getter");
            return;
        }
        if (this.myStatementBlock.isInSetterScope()) {
            this.getLocation().reportSemanticError("The @update statement is not allowed in the statement block of a property's setter");
            return;
        }
        Assignment refd_ass = this.ref.getRefdAssignment(timestamp, false);
        switch (refd_ass.getAssignmentType()) {
            case A_CONST: 
            case A_TEMPLATE: {
                break;
            }
            default: {
                this.getLocation().reportSemanticError(MessageFormat.format("Reference to constant or template definition was expected instead of {0}", refd_ass.getAssignmentName()));
                return;
            }
        }
        IType refd_type = refd_ass.getType(timestamp);
        if (refd_type != null && refd_type.getIsErroneous(timestamp)) {
            this.ref.getLocation().reportSemanticError(MessageFormat.format("Type `{0}' cannot have erroneous attributes", refd_type.getTypename()));
        }
        if (this.attr != null) {
            this.err_attrib = Definition.checkErroneousAttributes(this.attr, refd_type, this.myScope, refd_type.getFullName(), false, timestamp, this.ref);
            if (this.err_attrib != null) {
                // empty if block
            }
        }
        if (this.ref.getSubreferences() != null) {
            this.ref.getLocation().reportSemanticError("Field names and array indexes are not allowed in this context");
        }
        if (!useRuntime2) {
            this.getLocation().reportSemanticError("The @update statement is only available in the Function Test runtime");
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.ref != null) {
            this.ref.updateSyntax(reparser, false);
            reparser.updateLocation(this.ref.getLocation());
        }
        if (this.attr != null) {
            this.attr.updateSyntax(reparser, false);
            reparser.updateLocation(this.attr.getLocation());
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.ref != null && !this.ref.accept(v)) {
            return false;
        }
        return this.attr == null || this.attr.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        source.append("//TODO: update statement\n ");
    }
}

