/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Timer;
import org.eclipse.titan.designer.AST.TTCN3.statements.Start_Timer_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.types.PortGenerator;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Timeout_Statement
extends Statement {
    private static final String FULLNAMEPART1 = ".timerreference";
    private static final String FULLNAMEPART2 = ".redirectIndex";
    private static final String STATEMENT_NAME = "timeout";
    private final Reference timerReference;
    private final boolean any_from;
    private final Reference indexRedirection;

    public Timeout_Statement(Reference timerReference) {
        this.timerReference = timerReference;
        this.any_from = false;
        this.indexRedirection = null;
        if (timerReference != null) {
            timerReference.setFullNameParent(this);
        }
    }

    public Timeout_Statement(Reference timerReference, boolean any_from, Reference index_redirect) {
        this.timerReference = timerReference;
        this.any_from = any_from;
        this.indexRedirection = index_redirect;
        if (timerReference != null) {
            timerReference.setFullNameParent(this);
        }
        if (index_redirect != null) {
            index_redirect.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_TIMEOUT;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.timerReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.indexRedirection == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.timerReference != null) {
            this.timerReference.setMyScope(scope);
        }
        if (this.indexRedirection != null) {
            this.indexRedirection.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.timerReference != null) {
            this.timerReference.setCodeSection(codeSection);
        }
        if (this.indexRedirection != null) {
            this.indexRedirection.setCodeSection(codeSection);
        }
    }

    @Override
    public boolean hasReceivingStatement() {
        return true;
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        Start_Timer_Statement.checkTimerReference(timestamp, this.timerReference, this.any_from);
        if (this.timerReference != null && this.indexRedirection != null) {
            Assignment assignment = this.timerReference.getRefdAssignment(timestamp, false);
            Timeout_Statement.checkIndexRedirection(timestamp, this.indexRedirection, assignment == null ? null : ((Def_Timer)assignment).getDimensions(), this.any_from, "timer");
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.timerReference != null) {
            this.timerReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.timerReference.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.timerReference == null) {
            return;
        }
        this.timerReference.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.timerReference == null || this.timerReference.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expression = new ExpressionStruct();
        this.generateCodeExpression(aData, expression, null);
        source.append((CharSequence)expression.preamble);
        PortGenerator.generateCodeStandalone(aData, source, expression.expression.toString(), this.getStatementName(), this.canRepeat(), this.getLocation());
    }

    @Override
    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression, String callTimer) {
        if (this.timerReference == null) {
            aData.addBuiltinTypeImport("TitanTimer");
            expression.expression.append("TitanTimer.any_timeout()");
        } else {
            this.timerReference.generateCode(aData, expression);
            expression.expression.append(".timeout(");
            if (this.indexRedirection == null) {
                expression.expression.append("null");
            } else {
                Timeout_Statement.generateCodeIndexRedirect(aData, expression, this.indexRedirection, this.getMyScope());
            }
            expression.expression.append(")");
        }
    }
}

