/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.text.table;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.exceptions.UserException;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.parsers.data.TestCase;
import org.eclipse.titan.log.viewer.utils.ActionUtils;
import org.eclipse.titan.log.viewer.utils.Constants;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.views.MSCView;
import org.eclipse.titan.log.viewer.views.text.table.TextTableView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class TextTableViewHelper {
    public static TextTableView open(String projectName, String projectRelativePath, int recordToSelect) {
        IWorkspace workspace;
        IWorkspaceRoot root;
        IProject project;
        IFile logFile;
        String secondId = projectRelativePath;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference reference = activePage.findViewReference("org.eclipse.titan.log.viewer.views.text.table.TextTableView", secondId);
        if (reference != null) {
            try {
                TextTableView view = (TextTableView)activePage.showView("org.eclipse.titan.log.viewer.views.text.table.TextTableView", secondId, 1);
                view.setSelectedRecord(recordToSelect);
                view.setFocus();
                return view;
            }
            catch (PartInitException view) {
                // empty catch block
            }
        }
        if (!(logFile = (project = (root = (workspace = ResourcesPlugin.getWorkspace()).getRoot()).getProject(projectName)).getFile(projectRelativePath.substring(projectName.length() + 1))).exists()) {
            IViewReference[] viewReferences = activePage.getViewReferences();
            ActionUtils.closeAssociatedViews(activePage, viewReferences, (IResource)logFile);
            TitanLogExceptionHandler.handleException(new UserException(Messages.getString("OpenMSCViewMenuAction.4")));
            return null;
        }
        try {
            Object temp = logFile.getSessionProperty(Constants.EXTRACTION_RUNNING);
            if (temp != null && ((Boolean)temp).booleanValue()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation(null, (String)"View can not be opened.", (String)("Test case extraction is already running on " + logFile.getName()));
                    }
                });
                return null;
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            TitanLogExceptionHandler.handleException(new UserException(e.getMessage()));
        }
        if (LogFileCacheHandler.hasLogFileChanged(logFile)) {
            LogFileCacheHandler.handleLogFileChange(logFile);
            return null;
        }
        try {
            TextTableView view = (TextTableView)activePage.showView("org.eclipse.titan.log.viewer.views.text.table.TextTableView", secondId, 1);
            view.setInput(logFile, recordToSelect);
            view.setFocus();
            return view;
        }
        catch (FileNotFoundException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenTextTableTestCasesViewMenuAction.0") + e.getMessage()));
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenTextTableTestCasesViewMenuAction.1") + e.getMessage()));
        }
        catch (PartInitException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenTextTableTestCasesViewMenuAction.2") + e.getMessage()));
        }
        catch (ClassNotFoundException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenTextTableTestCasesViewMenuAction.2") + e.getMessage()));
        }
        return null;
    }

    static void updateSelectionInConnectedMscView(int selectedRecord, LogFileMetaData fileMetaData) {
        IViewReference[] viewReferences;
        for (IViewReference viewReference : viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences()) {
            MSCView mscView;
            IViewPart viewPart = viewReference.getView(false);
            if (!(viewPart instanceof MSCView) || (mscView = (MSCView)viewPart).getModel() == null || mscView.getModel().getTestCase() == null) continue;
            TestCase testCase = mscView.getModel().getTestCase();
            if (!fileMetaData.getFilePath().equals(mscView.getLogFileMetaData().getFilePath()) || testCase.getStartRecordNumber() > selectedRecord || testCase.getEndRecordNumber() < selectedRecord) continue;
            if (mscView.getSelectedRecordNumber() == selectedRecord) break;
            mscView.setSelection(selectedRecord);
            break;
        }
    }
}

