/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.types;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titanium.markers.types.ProblemNameToPreferenceMapper;
import org.eclipse.titanium.markers.types.ProblemType;

public enum TaskType implements ProblemType
{
    FIXME("FIXME tags", 0.0, 0.0, 0.0){

        @Override
        public boolean equalType(IMarker m) throws CoreException {
            return 2 == m.getAttribute("priority", 0);
        }
    }
    ,
    TODO("TODO tags", 0.0, 0.0, 0.0){

        @Override
        public boolean equalType(IMarker m) throws CoreException {
            return 1 == m.getAttribute("priority", 0);
        }
    };

    private double defaultMinTime;
    private double defaultAvgTime;
    private double defaultMaxTime;
    private String readableName;
    private String innerName;

    private TaskType(String name, Double minTime, Double avgTime, Double maxTime) {
        this.readableName = name;
        this.defaultMinTime = minTime;
        this.defaultAvgTime = avgTime;
        this.defaultMaxTime = maxTime;
        this.innerName = this.name();
    }

    @Override
    public int getBaseLine() {
        return this.getInt(ProblemNameToPreferenceMapper.nameSmellBaseLine(this.innerName));
    }

    @Override
    public int getImpact() {
        return this.getInt(ProblemNameToPreferenceMapper.nameSmellImpact(this.innerName));
    }

    @Override
    public double getAvgRepairTime() {
        return this.getDouble(ProblemNameToPreferenceMapper.nameSmellAvgTime(this.innerName), this.defaultAvgTime);
    }

    @Override
    public double getMinRepairTime() {
        return this.getDouble(ProblemNameToPreferenceMapper.nameSmellMinTime(this.innerName), this.defaultMinTime);
    }

    @Override
    public double getMaxRepairTime() {
        return this.getDouble(ProblemNameToPreferenceMapper.nameSmellMaxTime(this.innerName), this.defaultMaxTime);
    }

    @Override
    public double getAvgDefaultTime() {
        return this.defaultAvgTime;
    }

    @Override
    public double getMinDefaultTime() {
        return this.defaultMinTime;
    }

    @Override
    public double getMaxDefaultTime() {
        return this.defaultMaxTime;
    }

    @Override
    public String getHumanReadableName() {
        return this.readableName;
    }

    public String toString() {
        return this.innerName;
    }

    private int getInt(String id) {
        int val = Platform.getPreferencesService().getInt("org.eclipse.titanium", id, -1, null);
        if (val == -1) {
            throw new IllegalArgumentException("The requested field for " + this.readableName + " is not found in the preference store. Probably you forgot to add it in the PreferenceInitializer or in the RiskFactorPreferencePage.");
        }
        return val;
    }

    private double getDouble(String id, double defaultValue) {
        return Platform.getPreferencesService().getDouble("org.eclipse.titanium", id, defaultValue, null);
    }

    public abstract boolean equalType(IMarker var1) throws CoreException;
}

