/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards.projectFormat;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.properties.data.DOMErrorHandlerImpl;
import org.eclipse.titan.designer.properties.data.ProjectBuildPropertyData;
import org.eclipse.titan.designer.properties.data.ProjectDocumentHandlingUtility;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titan.designer.wizards.projectFormat.TITANProjectExportWizard;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public final class TITANProjectExporter {
    private final IProject project;
    private String projectFile = null;
    private boolean isExcludedWorkingDirectoryContents = true;
    private boolean isExcludedDotResources = true;
    private boolean excludeLinkedContents = false;
    private boolean saveDefaultValues = false;
    private boolean packAllProjectsIntoOne = false;
    private boolean useTpdNameAttribute = false;
    private final IPreferencesService preferenceService;

    public TITANProjectExporter(IProject project) {
        this.project = project;
        this.preferenceService = Platform.getPreferencesService();
    }

    public TITANProjectExporter(IProject project, String projectFile) {
        this.project = project;
        this.projectFile = projectFile;
        this.preferenceService = Platform.getPreferencesService();
    }

    public String getProjectFile() {
        return this.projectFile;
    }

    public void setProjectFile(String value) {
        this.projectFile = value;
    }

    public boolean getIsExcludedWorkingDirectoryContents() {
        return this.isExcludedWorkingDirectoryContents;
    }

    public void setIsExcludedWorkingDirectoryContents(boolean value) {
        this.isExcludedWorkingDirectoryContents = value;
    }

    public boolean getIsExcludedDotResources() {
        return this.isExcludedDotResources;
    }

    public void setIsExcludedDotResources(boolean value) {
        this.isExcludedDotResources = value;
    }

    public boolean getExcludeLinkedContents() {
        return this.excludeLinkedContents;
    }

    public void setExcludeLinkedContents(boolean value) {
        this.excludeLinkedContents = value;
    }

    public boolean getSaveDefaultValues() {
        return this.saveDefaultValues;
    }

    public void setSaveDefaultValues(boolean value) {
        this.saveDefaultValues = value;
    }

    public boolean getPackAllProjectsIntoOne() {
        return this.packAllProjectsIntoOne;
    }

    public void setPackAllProjectsIntoOne(boolean value) {
        this.packAllProjectsIntoOne = value;
    }

    public boolean getUseTpdNameAttribute() {
        return this.useTpdNameAttribute;
    }

    public void setUseTpdNameAttribute(boolean value) {
        this.useTpdNameAttribute = value;
    }

    public boolean setProjectFileFromLoadLocation() {
        if (this.project == null) {
            return false;
        }
        try {
            this.projectFile = this.project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "loadLocation"));
            if (this.projectFile == null) {
                return false;
            }
            if (this.projectFile.startsWith("file:/")) {
                this.projectFile = this.projectFile.substring(6);
                if (this.projectFile.matches("//[a-zA-Z]:.*")) {
                    this.projectFile = this.projectFile.substring(1);
                    this.project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "loadLocation"), this.projectFile);
                } else {
                    this.project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "loadLocation"), this.projectFile);
                }
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return true;
    }

    public void setExportPreferences() {
        this.setIsExcludedWorkingDirectoryContents(this.preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.excludeWorkingDirectoryContents", true, null));
        this.setIsExcludedDotResources(this.preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.excludeDotResources", true, null));
        this.setExcludeLinkedContents(this.preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.excludeLinkedContents", true, null));
        this.setSaveDefaultValues(this.preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.saveDefaultValues", true, null));
        this.setPackAllProjectsIntoOne(this.preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.packAllProjectsIntoOne", true, null));
    }

    public boolean saveAll() {
        DocumentBuilder builder;
        if (this.project == null) {
            ErrorReporter.logError((String)"Invalid project");
            return false;
        }
        if (this.projectFile == null || this.projectFile.trim().length() == 0) {
            return false;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return false;
        }
        DOMImplementation impl = builder.getDOMImplementation();
        Document document = impl.createDocument(null, "TITAN_Project_File_Information", null);
        Element root = document.getDocumentElement();
        root.setAttribute("version", "1.0");
        boolean result = this.saveProjectInformation(root, this.project, this.packAllProjectsIntoOne, !this.packAllProjectsIntoOne);
        if (!result) {
            return false;
        }
        ProjectFileHandler.indentNode(document, document.getDocumentElement(), 1);
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "com.sun.org.apache.xerces.internal.dom.DOMImplementationSourceImpl");
        DOMImplementationRegistry registry = null;
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (ClassNotFoundException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)ce);
            return false;
        }
        catch (InstantiationException ie) {
            ErrorReporter.logExceptionStackTrace((Exception)ie);
            return false;
        }
        catch (IllegalAccessException iae) {
            ErrorReporter.logExceptionStackTrace((Exception)iae);
            return false;
        }
        DOMImplementation domImpl = registry.getDOMImplementation("LS 3.0");
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)domImpl);
        LSParser parser = domImplLS.createLSParser((short)1, "http://www.w3.org/2001/XMLSchema");
        DOMConfiguration config = parser.getDomConfig();
        DOMErrorHandlerImpl errorHandler = new DOMErrorHandlerImpl();
        config.setParameter("error-handler", errorHandler);
        config.setParameter("validate", Boolean.TRUE);
        config.setParameter("schema-type", "http://www.w3.org/2001/XMLSchema");
        config.setParameter("validate-if-schema", Boolean.TRUE);
        LSSerializer dom3Writer = domImplLS.createLSSerializer();
        LSOutput output = domImplLS.createLSOutput();
        IPath projectFilePath = Path.fromOSString((String)this.projectFile);
        URI projectFileURI = URIUtil.toURI((IPath)projectFilePath);
        try {
            IFile[] files;
            StringWriter sw = new StringWriter();
            output.setCharacterStream(sw);
            output.setEncoding("UTF-8");
            dom3Writer.write(document, output);
            String temporaloutput = sw.getBuffer().toString();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.projectFile));
            bufferedWriter.write(temporaloutput);
            bufferedWriter.flush();
            bufferedWriter.close();
            for (IFile file : files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(projectFileURI)) {
                file.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        ProjectBuildPropertyData.setLoadLocation(this.project, projectFileURI.getPath().toString());
        ProjectBuildPropertyData.setProjectAlreadyExported(this.project, true);
        return true;
    }

    private boolean saveProjectInformation(Node root, IProject project, boolean packReferencedProjects, boolean storeReferredProjectLocationURI) {
        Document document = root.getOwnerDocument();
        String copyrightStr = null;
        try {
            copyrightStr = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "projectCopyright"));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        if (copyrightStr == null || copyrightStr.isEmpty()) {
            copyrightStr = "\n Copyright (c) 2000-2025 Ericsson Telecom AB\n All rights reserved. This program and the accompanying materials\n are made available under the terms of the Eclipse Public License v2.0\n which accompanies this distribution, and is available at\n https://www.eclipse.org/org/documents/epl-2.0/EPL-2.0.html\n";
        }
        Comment commentNode = document.createComment(copyrightStr);
        root.appendChild(commentNode);
        Element projectNameNode = document.createElement("ProjectName");
        projectNameNode.appendChild(document.createTextNode(project.getName()));
        root.appendChild(projectNameNode);
        boolean result = this.saveReferencedProjectsData(root, project, storeReferredProjectLocationURI);
        if (!result) {
            return false;
        }
        IContainer[] workingDirectories = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryResources(false);
        TITANProjectExportWizard.ExportResourceVisitor visitor = new TITANProjectExportWizard.ExportResourceVisitor(workingDirectories, this.isExcludedWorkingDirectoryContents, this.isExcludedDotResources, this.excludeLinkedContents);
        try {
            if (project.isAccessible()) {
                project.accept((IResourceVisitor)visitor);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        Path projectFilePath = new Path(this.projectFile);
        projectFilePath = projectFilePath.removeLastSegments(1);
        URI projectFileURI = URIUtil.toURI((IPath)projectFilePath);
        Map<String, IFolder> folders = visitor.getFolders();
        this.saveFoldersData(root, folders, projectFileURI);
        Map<String, IFile> files = visitor.getFiles();
        this.saveFilesData(root, files, projectFileURI);
        this.savePathVariableData(root);
        this.saveConfigurationData(root, project, files, folders, this.saveDefaultValues);
        if (packReferencedProjects) {
            List<IProject> referencedProjects = ProjectBasedBuilder.getProjectBasedBuilder(project).getAllReachableProjects();
            referencedProjects.remove(project);
            if (!referencedProjects.isEmpty()) {
                Element projectsElement = document.createElement("PackedReferencedProjects");
                root.appendChild(projectsElement);
                for (IProject tempProject : referencedProjects) {
                    Element element = document.createElement("PackedReferencedProject");
                    projectsElement.appendChild(element);
                    this.saveProjectInformation(element, tempProject, false, storeReferredProjectLocationURI);
                }
            }
        }
        return true;
    }

    private boolean saveReferencedProjectsData(Node root, IProject project, boolean storeReferredProjectLocationURI) {
        IProject[] referencedProjects = ProjectBasedBuilder.getProjectBasedBuilder(project).getReferencedProjects();
        if (referencedProjects.length == 0) {
            return true;
        }
        Document document = root.getOwnerDocument();
        Element projectsElement = document.createElement("ReferencedProjects");
        root.appendChild(projectsElement);
        for (IProject tempProject : referencedProjects) {
            Element element;
            block15: {
                element = document.createElement("ReferencedProject");
                element.setAttribute("name", tempProject.getName());
                boolean projectLocationURIset = false;
                if (this.useTpdNameAttribute) {
                    String tempTpdName = null;
                    String origTpdURI = null;
                    try {
                        tempTpdName = tempProject.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "useTpdName"));
                        origTpdURI = tempProject.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "origTpdURI"));
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                    }
                    if (tempTpdName == null || tempTpdName.length() == 0) {
                        tempTpdName = tempProject.getName() + ".tpd";
                    } else if (origTpdURI != null && origTpdURI.length() != 0 && storeReferredProjectLocationURI) {
                        element.setAttribute("projectLocationURI", origTpdURI);
                        projectLocationURIset = true;
                    }
                    element.setAttribute("tpdName", tempTpdName);
                }
                if (!tempProject.isOpen()) {
                    ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Export failed", (String)("In order to export data on project " + project.getName() + " it's referenced project " + tempProject.getName() + " must be open."));
                    ErrorReporter.logError((String)("In order to export data on project " + project.getName() + " it's referenced project " + tempProject.getName() + " must be open."));
                    return true;
                }
                try {
                    String location = tempProject.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "loadLocation"));
                    if (location == null || location.length() == 0) {
                        IProject tempProject2 = tempProject;
                        ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Export failed", (String)("In order to export data on project " + project.getName() + " data on project " + tempProject2.getName() + " must be saved first."));
                        ErrorReporter.logError((String)("In order to export data on project " + project.getName() + " data on project " + tempProject.getName() + " must be saved first."));
                        return false;
                    }
                    if (projectLocationURIset || !storeReferredProjectLocationURI) break block15;
                    URI locationuri = null;
                    try {
                        locationuri = org.eclipse.core.runtime.URIUtil.fromString((String)location);
                        if (locationuri.getScheme() == null || locationuri.getScheme().length() <= 1) {
                            Path locationPath = new Path(location);
                            locationuri = org.eclipse.core.runtime.URIUtil.fromString((String)("file:/" + locationPath.toString()));
                        }
                    }
                    catch (URISyntaxException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)e);
                        return false;
                    }
                    Path path = new Path(this.projectFile);
                    path = path.removeLastSegments(1);
                    URI projecturi = URIUtil.toURI((IPath)path);
                    URI result = org.eclipse.core.runtime.URIUtil.makeRelative((URI)locationuri, (URI)projecturi);
                    element.setAttribute("projectLocationURI", result.toString());
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
            }
            projectsElement.appendChild(element);
        }
        return true;
    }

    private void saveFoldersData(Node root, Map<String, IFolder> folders, URI projectFileURI) {
        if (folders.isEmpty()) {
            return;
        }
        Document document = root.getOwnerDocument();
        Element foldersRoot = document.createElement("Folders");
        root.appendChild(foldersRoot);
        for (IFolder folder : folders.values()) {
            Element folderRoot = document.createElement("FolderResource");
            foldersRoot.appendChild(folderRoot);
            folderRoot.setAttribute("projectRelativePath", folder.getProjectRelativePath().toString());
            URI rawURI = folder.getRawLocationURI();
            if (rawURI != null) {
                URI expandedURI = folder.getLocationURI();
                if (rawURI.equals(expandedURI)) {
                    if (folder.getLocation() != null) {
                        URI result = org.eclipse.core.runtime.URIUtil.makeRelative((URI)expandedURI, (URI)projectFileURI);
                        folderRoot.setAttribute("relativeURI", result.toString());
                        continue;
                    }
                    folderRoot.setAttribute("rawURI", expandedURI.toString());
                    continue;
                }
                folderRoot.setAttribute("rawURI", rawURI.toString());
                continue;
            }
            ErrorReporter.logError((String)("The folder " + folder.toString() + " cannot be resolved to rawURI, it cannot be saved"));
        }
    }

    private void saveFilesData(Node root, Map<String, IFile> files, URI projectFileURI) {
        if (files.isEmpty()) {
            return;
        }
        Document document = root.getOwnerDocument();
        Element filesRoot = document.createElement("Files");
        root.appendChild(filesRoot);
        for (IFile file : files.values()) {
            Element fileRoot = document.createElement("FileResource");
            filesRoot.appendChild(fileRoot);
            fileRoot.setAttribute("projectRelativePath", file.getProjectRelativePath().toString());
            URI rawURI = file.getRawLocationURI();
            URI expandedURI = file.getLocationURI();
            if (rawURI.equals(expandedURI)) {
                if (file.getLocation() != null) {
                    URI result = org.eclipse.core.runtime.URIUtil.makeRelative((URI)expandedURI, (URI)projectFileURI);
                    fileRoot.setAttribute("relativeURI", result.toString());
                    continue;
                }
                fileRoot.setAttribute("rawURI", file.getLocationURI().toString());
                continue;
            }
            fileRoot.setAttribute("rawURI", file.getRawLocationURI().toString());
        }
    }

    private void savePathVariableData(Node root) {
        IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        String[] names = pathVariableManager.getPathVariableNames();
        if (names.length == 0) {
            return;
        }
        ArrayList<String> namesArray = new ArrayList<String>(names.length);
        for (String name : names) {
            namesArray.add(name);
        }
        Collections.sort(namesArray);
        Document document = root.getOwnerDocument();
        Element variablesRoot = document.createElement("PathVariables");
        root.appendChild(variablesRoot);
        for (String name : namesArray) {
            Element variableRoot = document.createElement("PathVariable");
            variablesRoot.appendChild(variableRoot);
            URI value = pathVariableManager.getURIValue(name);
            variableRoot.setAttribute("value", value.toString());
            variableRoot.setAttribute("name", name);
        }
    }

    private void saveConfigurationData(Node root, IProject project, Map<String, IFile> files, Map<String, IFolder> folders, boolean saveDefaultValues) {
        String activeConfigurationName;
        Document document = root.getOwnerDocument();
        try {
            activeConfigurationName = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "org.eclipse.titan.designer.activeConfiguration"));
            if (activeConfigurationName == null || activeConfigurationName.length() == 0) {
                activeConfigurationName = "Default";
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            activeConfigurationName = "Default";
        }
        Element activeConfigurationNode = document.createElement("ActiveConfiguration");
        activeConfigurationNode.appendChild(document.createTextNode(activeConfigurationName));
        root.appendChild(activeConfigurationNode);
        Element configurationsRoot = document.createElement("Configurations");
        root.appendChild(configurationsRoot);
        Document configurationDocument = ProjectDocumentHandlingUtility.getDocument(project);
        List<String> configurations = ProjectFileHandler.getConfigurations(configurationDocument);
        for (String config : configurations) {
            Element configurationRoot = document.createElement("Configuration");
            configurationRoot.setAttribute("name", config);
            configurationsRoot.appendChild(configurationRoot);
            Node configurationNode = ProjectFileHandler.findConfigurationNode(configurationDocument.getDocumentElement(), config);
            this.copyConfigurationData(configurationNode, project, configurationRoot, files, folders, saveDefaultValues);
        }
    }

    private void copyConfigurationData(Node sourceRoot, IProject project, Element targetRoot, Map<String, IFile> files, Map<String, IFolder> folders, boolean saveDefaultValues) {
        ProjectFileHandler.copyProjectInfo(sourceRoot, targetRoot, project, files, folders, saveDefaultValues);
    }
}

