/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core;

import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.preferences.SubscribedBoolean;
import org.eclipse.titan.designer.preferences.SubscribedInt;

public final class LoadBalancingUtilities {
    private static SubscribedInt tokensToProcessInARow = new SubscribedInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.debug.load.tokensToProcessInARow", 100);
    private static SubscribedInt threadPriority = new SubscribedInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.debug.load.threadPriority", 1);
    private static SubscribedInt sleepBetweenFiles = new SubscribedInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.debug.load.sleepBetweenFiles", 10);
    private static SubscribedBoolean yieldBetweenChecks = new SubscribedBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.debug.load.yieldBetweenChecks", true);

    private LoadBalancingUtilities() {
        throw new UnsupportedOperationException();
    }

    public static int getThreadPriority() {
        return (Integer)threadPriority.getValue();
    }

    public static int getTokensToProcessInARow() {
        return (Integer)tokensToProcessInARow.getValue();
    }

    public static void syntaxAnalyzerProcessedAFile() {
        if ((Integer)sleepBetweenFiles.getValue() >= 0) {
            try {
                Thread.sleep(((Integer)sleepBetweenFiles.getValue()).intValue());
            }
            catch (Exception e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
    }

    public static void astNodeChecked() {
        if (((Boolean)yieldBetweenChecks.getValue()).booleanValue()) {
            Thread.yield();
        }
    }
}

