/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Boolean_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Property_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReparseUtilities;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Return_Statement
extends Statement {
    private static final String SPECIFICVALUEEXPECTED = "A specific value without matching symbols was expected as return value";
    private static final String MISSINGTEMPLATE = "Missing return template. The function should return a template of type `{0}''";
    private static final String MISSINGRETURNVALUE = "Missing return value";
    private static final String MISSINGVALUE = "Missing return value. The function should return a value of type `{0}''";
    private static final String UNEXPECTEDRETURNVALUE = "Unexpected return value. The function does not have return type";
    private static final String UNEXPETEDRETURNSTATEMENT = "Return statement cannot be used in a {0}. It is allowed only in functions, altsteps, dynamic matching and class property getters";
    private static final String ALTSTEPRETURNINGVALUE = "An altstep cannot return a value";
    private static final String USAGEINCONTROLPART = "Return statement cannot be used in the control part. It is allowed only in functions, altsteps, dynamic matching and class property getters";
    private static final String RETURNINDESTRUCTOR = "Return statement cannot be used in a class destructor";
    private static final String INVALIDSETTERRETURN = "Return statement cannot be used in a property setter";
    private static final String INVALIDRETURNINDYNAMICTEMPLATESB1 = "Missing return value. The dynamic template's statement block should return a boolean value";
    private static final String INVALIDRETURNINDYNAMICTEMPLATESB2 = "A specific value without matching symbols was expected as return value";
    private static final String FULLNAMEPART = ".returnexpression";
    private static final String STATEMENT_NAME = "return";
    private final TTCN3Template template;
    private boolean genRestrictionCheck = false;

    public Return_Statement(TTCN3Template template) {
        this.template = template;
        if (template != null) {
            template.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_RETURN;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.template == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.template != null) {
            this.template.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.template != null) {
            this.template.setCodeSection(codeSection);
        }
    }

    @Override
    public boolean isTerminating(CompilationTimeStamp timestamp) {
        return true;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        IValue value;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.genRestrictionCheck = false;
        Definition definition = this.myStatementBlock.getMyDefinition();
        if (this.myStatementBlock.hasDestructor()) {
            this.location.reportSemanticError(RETURNINDESTRUCTOR);
            return;
        }
        if (this.myStatementBlock.isInGetterScope()) {
            boolean isTemplate;
            Definition property = this.myStatementBlock.getScopeGetter().getMyDefinition();
            boolean bl = isTemplate = property.getAssignmentType() == Assignment.Assignment_type.A_VAR_TEMPLATE;
            if (this.template == null) {
                this.location.reportSemanticError(MISSINGRETURNVALUE);
                return;
            }
            if (!isTemplate && !this.template.isValue(timestamp)) {
                this.location.reportSemanticError("A specific value without matching symbols was expected as return value");
                return;
            }
            IType returnType = property.getType(timestamp);
            if (isTemplate) {
                this.template.setMyGovernor(returnType);
                ITTCN3Template temporalTemplate = returnType.checkThisTemplateRef(timestamp, this.template, Expected_Value_type.EXPECTED_TEMPLATE, null);
                temporalTemplate.checkThisTemplateGeneric(timestamp, returnType, true, true, true, true, true, null);
                this.genRestrictionCheck = TemplateRestriction.check(timestamp, definition, temporalTemplate, null);
            } else {
                this.template.setMyGovernor(returnType);
                value = this.template.getValue();
                if (value != null) {
                    value.setMyGovernor(returnType);
                    returnType.checkThisValueRef(timestamp, value);
                    returnType.checkThisValue(timestamp, value, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, false, true, false, false));
                }
            }
        }
        if (definition == null) {
            this.location.reportSemanticError(USAGEINCONTROLPART);
            return;
        }
        switch (definition.getAssignmentType()) {
            case A_FUNCTION: {
                if (this.template == null) break;
                this.template.getLocation().reportSemanticError(UNEXPECTEDRETURNVALUE);
                break;
            }
            case A_FUNCTION_RVAL: {
                Type returnType = ((Def_Function)definition).getType(timestamp);
                if (this.template == null) {
                    this.location.reportSemanticError(MessageFormat.format(MISSINGVALUE, returnType.getTypename()));
                    break;
                }
                if (!this.template.isValue(timestamp)) {
                    this.template.getLocation().reportSemanticError("A specific value without matching symbols was expected as return value");
                    break;
                }
                this.template.setMyGovernor(returnType);
                IValue value2 = this.template.getValue();
                if (value2 == null) break;
                value2.setMyGovernor(returnType);
                returnType.checkThisValueRef(timestamp, value2);
                returnType.checkThisValue(timestamp, value2, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, false, true, false, false));
                break;
            }
            case A_FUNCTION_RTEMP: {
                if (this.template == null) {
                    this.location.reportSemanticError(MessageFormat.format(MISSINGTEMPLATE, ((Def_Function)definition).getType(timestamp).getTypename()));
                    break;
                }
                Type returnType = ((Def_Function)definition).getType(timestamp);
                this.template.setMyGovernor(returnType);
                ITTCN3Template temporalTemplate = returnType.checkThisTemplateRef(timestamp, this.template, Expected_Value_type.EXPECTED_TEMPLATE, null);
                temporalTemplate.checkThisTemplateGeneric(timestamp, returnType, true, true, true, true, true, null);
                this.genRestrictionCheck = TemplateRestriction.check(timestamp, definition, temporalTemplate, null);
                break;
            }
            case A_ALTSTEP: {
                if (this.template == null) break;
                this.template.getLocation().reportSemanticError(ALTSTEPRETURNINGVALUE);
                break;
            }
            case A_VAR: {
                INamedNode node;
                if (!this.myStatementBlock.ownerIsProperty()) break;
                if (this.myStatementBlock.isPropertyGetter() && (node = this.myStatementBlock.getNameParent()) instanceof Property_Type) {
                    IType propType;
                    Property_Type property = (Property_Type)node;
                    if (this.template == null) {
                        propType = property.getFieldType(timestamp, null, 0, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                        this.location.reportSemanticError(MessageFormat.format(MISSINGTEMPLATE, propType.getTypename()));
                        break;
                    }
                    propType = property.getFieldType(timestamp, null, 0, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                    this.template.setMyGovernor(propType);
                    value = this.template.getValue();
                    if (value == null) break;
                    value.setMyGovernor(propType);
                    propType.checkThisValueRef(timestamp, value);
                    propType.checkThisValue(timestamp, value, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, false, true, false, false));
                    break;
                }
                if (!this.myStatementBlock.isPropertySetter()) break;
                this.location.reportSemanticError(INVALIDSETTERRETURN);
                break;
            }
            case A_TEMPLATE: 
            case A_VAR_TEMPLATE: {
                if (this.myStatementBlock.isInDynamicTemplate() && this.template == null) {
                    this.myStatementBlock.getDynamicTemplate().getLocation().reportSemanticError(INVALIDRETURNINDYNAMICTEMPLATESB1);
                } else if (this.myStatementBlock.isInDynamicTemplate() && !this.template.isValue(timestamp)) {
                    this.myStatementBlock.getDynamicTemplate().getLocation().reportSemanticError("A specific value without matching symbols was expected as return value");
                }
                if (this.template == null) break;
                Type returnType = new Boolean_Type();
                this.template.setMyGovernor(returnType);
                IValue value3 = this.template.getValue();
                if (value3 == null) break;
                value3.setMyGovernor(returnType);
                returnType.checkThisValueRef(timestamp, value3);
                returnType.checkThisValue(timestamp, value3, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, false, true, false, false));
                break;
            }
            default: {
                this.location.reportSemanticError(MessageFormat.format(UNEXPETEDRETURNSTATEMENT, definition.getAssignmentName()));
            }
        }
    }

    @Override
    public void checkAllowedInterleave() {
        this.location.reportSemanticError("Return statement is not allowed within an interleave statement");
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.template != null) {
            return null;
        }
        return ReparseUtilities.getAllValidTokenTypes();
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.template != null) {
            this.template.updateSyntax(reparser, false);
            reparser.updateLocation(this.template.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.template == null) {
            return;
        }
        this.template.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.template == null || this.template.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expression = new ExpressionStruct();
        expression.expression.append("return ");
        Definition definition = this.myStatementBlock.getMyDefinition();
        if (this.template == null) {
            if (definition.getAssignmentType() == Assignment.Assignment_type.A_ALTSTEP) {
                expression.expression.append("TitanAlt_Status.ALT_YES");
            }
            expression.mergeExpression(source);
            return;
        }
        if (definition.getAssignmentType() == Assignment.Assignment_type.A_FUNCTION_RVAL && this.template.isValue(CompilationTimeStamp.getBaseTimestamp())) {
            IValue value = this.template.getValue();
            ExpressionStruct valueExpression = new ExpressionStruct();
            value.generateCodeExpressionMandatory(aData, valueExpression, true);
            expression.preamble.append((CharSequence)valueExpression.preamble);
            expression.expression.append((CharSequence)valueExpression.expression);
            expression.postamble.append((CharSequence)valueExpression.postamble);
        } else {
            Definition myDefinition = this.myStatementBlock.getMyDefinition();
            if (myDefinition.getTemplateRestriction() != TemplateRestriction.Restriction_type.TR_NONE && this.genRestrictionCheck) {
                this.template.generateCodeExpression(aData, expression, myDefinition.getTemplateRestriction());
            } else {
                this.template.generateCodeExpression(aData, expression, TemplateRestriction.Restriction_type.TR_NONE);
            }
        }
        expression.mergeExpression(source);
    }
}

