/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core.makefile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.common.path.PathUtil;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.common.product.ProductIdentity;
import org.eclipse.titan.common.utils.Cygwin;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.common.utils.ResourceUtils;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.GeneralConstants;
import org.eclipse.titan.designer.consoles.TITANConsole;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.CompilerVersionInformationCollector;
import org.eclipse.titan.designer.core.LoadBalancingUtilities;
import org.eclipse.titan.designer.core.ProductIdentityHelper;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.core.makefile.BaseDirectoryStruct;
import org.eclipse.titan.designer.core.makefile.MakefileGeneratorVisitor;
import org.eclipse.titan.designer.core.makefile.ModuleStruct;
import org.eclipse.titan.designer.core.makefile.OtherFileStruct;
import org.eclipse.titan.designer.core.makefile.TTCN3IncludeFileStruct;
import org.eclipse.titan.designer.core.makefile.UserStruct;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.properties.data.CCompilerOptionsData;
import org.eclipse.titan.designer.properties.data.COptimalizationOptionsData;
import org.eclipse.titan.designer.properties.data.LinkerFlagsOptionsData;
import org.eclipse.titan.designer.properties.data.LinkerLibrariesOptionsData;
import org.eclipse.titan.designer.properties.data.MakefileCreationData;
import org.eclipse.titan.designer.properties.data.PlatformSpecificLibrariesOptionsData;
import org.eclipse.titan.designer.properties.data.PreprocessorIncludedOptionsData;
import org.eclipse.titan.designer.properties.data.PreprocessorSymbolsOptionsData;
import org.eclipse.titan.designer.properties.data.ProjectBuildPropertyData;
import org.eclipse.titan.designer.properties.data.TITANFlagsOptionsData;
import org.eclipse.titan.designer.properties.data.TTCN3PreprocessorOptionsData;

public final class InternalMakefileGenerator {
    private static final String INVALID_OPTIONS = "Invalid build options found, for more information please refer to the Error Log view";
    private static final boolean USAGE_STATS = true;
    private static final String MISSING_CYGWIN = "Makefile generation failed. No cygwin installation found! Please make sure that cygwin is installed properly.";
    private final IProject project;
    private String projectLocation;
    private final List<ModuleStruct> ttcn3Modules = new ArrayList<ModuleStruct>();
    private boolean preprocess = false;
    private final List<ModuleStruct> ttcnppModules = new ArrayList<ModuleStruct>();
    private boolean ttcn3ModulesRegular = true;
    private boolean baseTTCN3ModulesRegular = true;
    private final List<TTCN3IncludeFileStruct> ttcn3IncludeFiles = new ArrayList<TTCN3IncludeFileStruct>();
    private final List<ModuleStruct> asn1modules = new ArrayList<ModuleStruct>();
    private boolean asn1ModulesRegular = true;
    private boolean baseASN1ModulesRegular = true;
    private final List<UserStruct> userFiles = new ArrayList<UserStruct>();
    private boolean userHeadersRegular = true;
    private boolean userSourcesRegular = true;
    private boolean baseUserHeadersRegular = true;
    private boolean baseUserSourcesRegular = true;
    private final List<OtherFileStruct> otherFiles = new ArrayList<OtherFileStruct>();
    private final List<BaseDirectoryStruct> baseDirectories = new ArrayList<BaseDirectoryStruct>();
    private final List<BaseDirectoryStruct> additionallyIncludedFolders = new ArrayList<BaseDirectoryStruct>();
    private String workingDirectory;
    private IPath workingDirectoryPath;
    private boolean gnuMake = false;
    private boolean incrementalDependencyRefresh = false;
    private boolean singleMode = false;
    private boolean dynamicLinking = false;
    private String etsName = null;
    private boolean useAbsolutePathNames = false;
    private boolean useRuntime2 = false;
    private String codeSplittingMode = null;
    private boolean library = false;
    private boolean usingSymbolicLinks = true;
    private boolean allProjectsUseSymbolicLinks = true;
    private ProductIdentity compilerProductNumber;
    private static final boolean useCrossCompilation = false;
    private List<IProject> reachableProjects;
    private boolean centralStorage;

    public InternalMakefileGenerator(IProject project) {
        this.project = project;
    }

    public void convertDirsToRelative() {
        Path path;
        for (ModuleStruct module : this.ttcn3Modules) {
            if (module.getDirectory() != null) {
                module.setDirectory(PathUtil.getRelativePath((String)this.workingDirectory, (String)module.getDirectory()));
            }
            if (module.getOriginalLocation() == null) continue;
            module.setOriginalLocation(PathUtil.getRelativePath((String)this.workingDirectory, (String)module.getOriginalLocation()));
        }
        for (ModuleStruct module : this.ttcnppModules) {
            if (module.getDirectory() != null) {
                module.setDirectory(PathUtil.getRelativePath((String)this.workingDirectory, (String)module.getDirectory()));
            }
            if (module.getOriginalLocation() == null) continue;
            module.setOriginalLocation(PathUtil.getRelativePath((String)this.workingDirectory, (String)module.getOriginalLocation()));
        }
        for (TTCN3IncludeFileStruct includeFile : this.ttcn3IncludeFiles) {
            if (includeFile.getDirectory() != null) {
                includeFile.setDirectory(PathUtil.getRelativePath((String)this.workingDirectory, (String)includeFile.getDirectory()));
            }
            if (includeFile.getWorkspaceDirectory() != null) {
                includeFile.setWorkspaceDirectory(PathUtil.getRelativePath((String)this.workingDirectory, (String)includeFile.getWorkspaceDirectory()));
            }
            if (includeFile.getOriginalLocation() != null) {
                includeFile.setOriginalLocation(PathUtil.getRelativePath((String)this.workingDirectory, (String)includeFile.getOriginalLocation()));
            }
            if (includeFile.getWorkspaceLocation() == null) continue;
            includeFile.setWorkspaceLocation(PathUtil.getRelativePath((String)this.workingDirectory, (String)includeFile.getWorkspaceLocation()));
        }
        for (ModuleStruct module : this.asn1modules) {
            if (module.getDirectory() != null) {
                module.setDirectory(PathUtil.getRelativePath((String)this.workingDirectory, (String)module.getDirectory()));
            }
            if (module.getOriginalLocation() == null) continue;
            module.setOriginalLocation(PathUtil.getRelativePath((String)this.workingDirectory, (String)module.getOriginalLocation()));
        }
        for (UserStruct user : this.userFiles) {
            if (user.getDirectory() != null) {
                user.setDirectory(PathUtil.getRelativePath((String)this.workingDirectory, (String)user.getDirectory()));
            }
            if (user.getOriginalHeaderLocation() != null) {
                user.setOriginalHeaderLocation(PathUtil.getRelativePath((String)this.workingDirectory, (String)user.getOriginalHeaderLocation()));
            }
            if (user.getOriginalSourceLocation() == null) continue;
            user.setOriginalSourceLocation(PathUtil.getRelativePath((String)this.workingDirectory, (String)user.getOriginalSourceLocation()));
        }
        for (OtherFileStruct other : this.otherFiles) {
            if (other.getDirectory() != null) {
                other.setDirectory(PathUtil.getRelativePath((String)this.workingDirectory, (String)other.getDirectory()));
            }
            if (other.getOriginalLocation() == null) continue;
            other.setOriginalLocation(PathUtil.getRelativePath((String)this.workingDirectory, (String)other.getOriginalLocation()));
        }
        for (BaseDirectoryStruct dir : this.baseDirectories) {
            if (dir.getDirectoryName() == null) continue;
            dir.setDirectoryName(PathUtil.getRelativePath((String)this.workingDirectory, (String)dir.getDirectoryName()));
        }
        for (BaseDirectoryStruct dir : this.additionallyIncludedFolders) {
            if (dir.getDirectoryName() == null) continue;
            dir.setDirectoryName(PathUtil.getRelativePath((String)this.workingDirectory, (String)dir.getDirectoryName()));
        }
        if (this.etsName != null && (path = new Path(this.etsName)).segmentCount() > 1) {
            this.etsName = PathUtil.getRelativePath((String)this.workingDirectory, (String)this.etsName);
        }
    }

    private void convertDirectories() {
        final boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        if (!"win32".equals(Platform.getOS())) {
            return;
        }
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        IPreferencesService prefs = Platform.getPreferencesService();
        int processingUnitsToUse = prefs.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.processingUnitsToUse", availableProcessors, null);
        boolean limitAllThreadCreation = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.limitAllThreadCreation", false, null);
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setPriority(LoadBalancingUtilities.getThreadPriority());
                return t;
            }
        };
        ExecutorService executor = limitAllThreadCreation ? Executors.newFixedThreadPool(processingUnitsToUse, threadFactory) : Executors.newCachedThreadPool(threadFactory);
        final CountDownLatch latch = new CountDownLatch(this.ttcn3Modules.size() + this.ttcnppModules.size() + this.ttcn3IncludeFiles.size() + this.asn1modules.size() + this.userFiles.size() + this.otherFiles.size() + this.baseDirectories.size() + this.additionallyIncludedFolders.size() + (this.etsName != null ? 1 : 0));
        for (final ModuleStruct module : this.ttcn3Modules) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    StringBuilder output;
                    if (module.getDirectory() != null) {
                        output = new StringBuilder();
                        module.setDirectory(PathConverter.convert((String)module.getDirectory(), (boolean)reportDebugInformation, (StringBuilder)output));
                        TITANDebugConsole.println(output);
                    }
                    if (module.getOriginalLocation() != null) {
                        output = new StringBuilder();
                        module.setOriginalLocation(PathConverter.convert((String)module.getOriginalLocation(), (boolean)reportDebugInformation, (StringBuilder)output));
                        TITANDebugConsole.println(output);
                    }
                    latch.countDown();
                }
            });
        }
        for (final ModuleStruct module : this.ttcnppModules) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    StringBuilder output;
                    if (module.getDirectory() != null) {
                        output = new StringBuilder();
                        module.setDirectory(PathConverter.convert((String)module.getDirectory(), (boolean)reportDebugInformation, (StringBuilder)output));
                        TITANDebugConsole.println(output);
                    }
                    if (module.getOriginalLocation() != null) {
                        output = new StringBuilder();
                        module.setOriginalLocation(PathConverter.convert((String)module.getOriginalLocation(), (boolean)reportDebugInformation, (StringBuilder)output));
                        TITANDebugConsole.println(output);
                    }
                    latch.countDown();
                }
            });
        }
        for (final TTCN3IncludeFileStruct includeFile : this.ttcn3IncludeFiles) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    StringBuilder output;
                    if (includeFile.getDirectory() != null) {
                        output = new StringBuilder();
                        includeFile.setDirectory(PathConverter.convert((String)includeFile.getDirectory(), (boolean)reportDebugInformation, (StringBuilder)output));
                        TITANDebugConsole.println(output);
                    }
                    if (includeFile.getOriginalLocation() != null) {
                        output = new StringBuilder();
                        includeFile.setOriginalLocation(PathConverter.convert((String)includeFile.getOriginalLocation(), (boolean)reportDebugInformation, (StringBuilder)output));
                        TITANDebugConsole.println(output);
                    }
                    latch.countDown();
                }
            });
        }
        for (final ModuleStruct module : this.asn1modules) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    StringBuilder output;
                    if (module.getDirectory() != null) {
                        output = new StringBuilder();
                        module.setDirectory(PathConverter.convert((String)module.getDirectory(), (boolean)reportDebugInformation, (StringBuilder)output));
                        TITANDebugConsole.println(output);
                    }
                    if (module.getOriginalLocation() != null) {
                        output = new StringBuilder();
                        module.setOriginalLocation(PathConverter.convert((String)module.getOriginalLocation(), (boolean)reportDebugInformation, (StringBuilder)output));
                        TITANDebugConsole.println(output);
                    }
                    latch.countDown();
                }
            });
        }
        for (final UserStruct user : this.userFiles) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    StringBuilder output;
                    if (user.getDirectory() != null) {
                        output = new StringBuilder();
                        user.setDirectory(PathConverter.convert((String)user.getDirectory(), (boolean)reportDebugInformation, (StringBuilder)output));
                        TITANDebugConsole.println(output);
                    }
                    if (user.getOriginalHeaderLocation() != null) {
                        output = new StringBuilder();
                        user.setOriginalHeaderLocation(PathConverter.convert((String)user.getOriginalHeaderLocation(), (boolean)reportDebugInformation, (StringBuilder)output));
                        TITANDebugConsole.println(output);
                    }
                    if (user.getOriginalSourceLocation() != null) {
                        output = new StringBuilder();
                        user.setOriginalSourceLocation(PathConverter.convert((String)user.getOriginalSourceLocation(), (boolean)reportDebugInformation, (StringBuilder)output));
                        TITANDebugConsole.println(output);
                    }
                    latch.countDown();
                }
            });
        }
        for (final OtherFileStruct other : this.otherFiles) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    StringBuilder output;
                    if (other.getDirectory() != null) {
                        output = new StringBuilder();
                        other.setDirectory(PathConverter.convert((String)other.getDirectory(), (boolean)reportDebugInformation, (StringBuilder)output));
                        TITANDebugConsole.println(output);
                    }
                    if (other.getOriginalLocation() != null) {
                        output = new StringBuilder();
                        other.setOriginalLocation(PathConverter.convert((String)other.getOriginalLocation(), (boolean)reportDebugInformation, (StringBuilder)output));
                        TITANDebugConsole.println(output);
                    }
                    latch.countDown();
                }
            });
        }
        for (final BaseDirectoryStruct dir : this.baseDirectories) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (dir.getDirectoryName() != null) {
                        StringBuilder output = new StringBuilder();
                        dir.setDirectoryName(PathConverter.convert((String)dir.getDirectoryName(), (boolean)reportDebugInformation, (StringBuilder)output));
                        TITANDebugConsole.println(output);
                    }
                    latch.countDown();
                }
            });
        }
        for (final BaseDirectoryStruct dir : this.additionallyIncludedFolders) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (dir.getDirectoryName() != null) {
                        StringBuilder output = new StringBuilder();
                        dir.setDirectoryName(PathConverter.convert((String)dir.getDirectoryName(), (boolean)reportDebugInformation, (StringBuilder)output));
                        TITANDebugConsole.println(output);
                    }
                    latch.countDown();
                }
            });
        }
        if (this.etsName != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    Path path = new Path(InternalMakefileGenerator.this.etsName);
                    if (path.segmentCount() > 1) {
                        StringBuilder output = new StringBuilder();
                        InternalMakefileGenerator.this.etsName = PathConverter.convert((String)InternalMakefileGenerator.this.etsName, (boolean)reportDebugInformation, (StringBuilder)output);
                        TITANDebugConsole.println(output);
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor.shutdownNow();
    }

    private boolean hasSpecialCharacters(String path) {
        if (path == null) {
            return false;
        }
        for (int i = 0; i < path.length(); ++i) {
            char actual = path.charAt(i);
            switch (actual) {
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '`': 
                case '{': 
                case '|': 
                case '}': {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkSpecialCharacters() {
        String path;
        boolean isErroneous = false;
        StringBuilder errorBuilder = new StringBuilder();
        for (ModuleStruct module : this.ttcn3Modules) {
            if (!this.hasSpecialCharacters(module.getDirectory()) && !this.hasSpecialCharacters(module.getFileName())) continue;
            path = module.getDirectory() == null ? "" : module.getDirectory() + File.separatorChar;
            errorBuilder.append("The path of the TTCN-3 file `" + path + module.getFileName() + "' contains special characters, that cannot be handled properly by the `make' utility and/or the shell.\n");
            isErroneous = true;
        }
        for (ModuleStruct module : this.ttcnppModules) {
            if (!this.hasSpecialCharacters(module.getDirectory()) && !this.hasSpecialCharacters(module.getFileName())) continue;
            path = module.getDirectory() == null ? "" : module.getDirectory() + File.separatorChar;
            errorBuilder.append("The path of the TTCN-3 file to be preprocessed `" + path + module.getFileName() + "' contains special characters, that cannot be handled properly by the `make' utility and/or the shell.\n");
            isErroneous = true;
        }
        for (ModuleStruct module : this.asn1modules) {
            if (!this.hasSpecialCharacters(module.getDirectory()) && !this.hasSpecialCharacters(module.getFileName())) continue;
            path = module.getDirectory() == null ? "" : module.getDirectory() + File.separatorChar;
            errorBuilder.append("The path of the ASN.1 file `" + path + module.getFileName() + "' contains special characters, that cannot be handled properly by the `make' utility and/or the shell.\n");
            isErroneous = true;
        }
        for (UserStruct user : this.userFiles) {
            if (!this.hasSpecialCharacters(user.getDirectory()) && !this.hasSpecialCharacters(user.getFileName())) continue;
            String string = path = user.getDirectory() == null ? "" : user.getDirectory() + File.separatorChar;
            if (user.isHasHHSuffix()) {
                errorBuilder.append("The path of the C/C++ header file `" + path + user.getFileName() + "' contains special characters, that cannot be handled properly by the `make' utility and/or the shell.\n");
            } else {
                errorBuilder.append("The path of the C/C++ source file `" + path + user.getFileName() + "' contains special characters, that cannot be handled properly by the `make' utility and/or the shell.\n");
            }
            isErroneous = true;
        }
        for (OtherFileStruct other : this.otherFiles) {
            if (!this.hasSpecialCharacters(other.getDirectory()) && !this.hasSpecialCharacters(other.getFileName())) continue;
            path = other.getDirectory() == null ? "" : other.getDirectory() + File.separatorChar;
            errorBuilder.append("The path of the file `" + path + other.getFileName() + "' contains special characters, that cannot be handled properly by the `make' utility and/or the shell.\n");
            isErroneous = true;
        }
        if (isErroneous) {
            ErrorReporter.logError((String)errorBuilder.toString());
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Special character error", (String)(errorBuilder.toString() + "Makefile was not generated!\n"));
        }
        return isErroneous;
    }

    private void checkNamingConvention() {
        ModuleStruct module;
        int i;
        this.ttcn3ModulesRegular = true;
        this.baseTTCN3ModulesRegular = true;
        this.asn1ModulesRegular = true;
        this.baseASN1ModulesRegular = true;
        this.userHeadersRegular = true;
        this.userSourcesRegular = true;
        this.baseUserHeadersRegular = true;
        this.baseUserSourcesRegular = true;
        for (i = 0; i < this.ttcn3Modules.size() && (this.ttcn3ModulesRegular || this.baseTTCN3ModulesRegular); ++i) {
            module = this.ttcn3Modules.get(i);
            if (module.getDirectory() == null) {
                if (module.isRegular()) continue;
                this.ttcn3ModulesRegular = false;
                continue;
            }
            if (module.isRegular()) continue;
            this.baseTTCN3ModulesRegular = false;
        }
        for (i = 0; i < this.ttcnppModules.size() && (this.ttcn3ModulesRegular || this.baseTTCN3ModulesRegular); ++i) {
            module = this.ttcnppModules.get(i);
            if (module.getDirectory() == null) {
                if (module.isRegular()) continue;
                this.ttcn3ModulesRegular = false;
                continue;
            }
            if (module.isRegular()) continue;
            this.baseTTCN3ModulesRegular = false;
        }
        for (i = 0; i < this.asn1modules.size() && (this.asn1ModulesRegular || this.baseASN1ModulesRegular); ++i) {
            module = this.asn1modules.get(i);
            if (module.getDirectory() == null) {
                if (module.isRegular()) continue;
                this.asn1ModulesRegular = false;
                continue;
            }
            if (module.isRegular()) continue;
            this.baseASN1ModulesRegular = false;
        }
        boolean hasRegular = true;
        for (int i2 = 0; i2 < this.userFiles.size() && hasRegular; ++i2) {
            UserStruct user = this.userFiles.get(i2);
            if (user.getDirectory() != null) {
                if (!user.isHasCCSuffix()) {
                    this.baseUserSourcesRegular = false;
                }
                if (!user.isHasCCSuffix() || !user.isHasHHSuffix()) {
                    this.baseUserHeadersRegular = false;
                }
            } else {
                if (!user.isHasCCSuffix()) {
                    this.userSourcesRegular = false;
                }
                if (!user.isHasCCSuffix() || !user.isHasHHSuffix()) {
                    this.userHeadersRegular = false;
                }
            }
            hasRegular = this.userHeadersRegular || this.userSourcesRegular || this.baseUserHeadersRegular || this.baseUserSourcesRegular;
        }
    }

    private String getSplittingMode() {
        if ("type".equals(this.codeSplittingMode) || "none".equals(this.codeSplittingMode)) {
            return this.codeSplittingMode;
        }
        try {
            Integer.parseInt(this.codeSplittingMode);
            return "number";
        }
        catch (NumberFormatException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return "none";
        }
    }

    private StringBuilder getSplittedFilenames(ModuleStruct module, boolean printDir) {
        StringBuilder contents = new StringBuilder();
        if ("type".equals(this.codeSplittingMode)) {
            contents.append(' ').append((CharSequence)module.generatedName(printDir, "cc", "_seq"));
            contents.append(' ').append((CharSequence)module.generatedName(printDir, "cc", "_seqof"));
            contents.append(' ').append((CharSequence)module.generatedName(printDir, "cc", "_set"));
            contents.append(' ').append((CharSequence)module.generatedName(printDir, "cc", "_setof"));
            contents.append(' ').append((CharSequence)module.generatedName(printDir, "cc", "_union"));
        } else if (!"none".equals(this.codeSplittingMode)) {
            int n_slices = Integer.parseInt(this.codeSplittingMode);
            for (int i = 1; i < n_slices; ++i) {
                contents.append(' ').append((CharSequence)module.generatedName(printDir, "cc", "_part_" + i));
            }
        }
        return contents;
    }

    private void sortFiles() {
        Collections.sort(this.baseDirectories);
        Collections.sort(this.additionallyIncludedFolders);
        Collections.sort(this.ttcn3Modules);
        Collections.sort(this.ttcn3IncludeFiles);
        Collections.sort(this.ttcnppModules);
        Collections.sort(this.asn1modules);
        Collections.sort(this.userFiles);
        Collections.sort(this.otherFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public void generateMakefile() {
        block326: {
            StringBuilder output;
            String[] location;
            Object optionList;
            if (Cygwin.isMissingInOSWin32()) {
                ErrorReporter.logError((String)MISSING_CYGWIN);
                return;
            }
            boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
            this.projectLocation = this.project.getLocation().toOSString();
            ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(this.project);
            projectSourceParser.makefileCreatingAnalyzeAll();
            try {
                this.setParameters();
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                return;
            }
            this.gatherInformation();
            if (!this.useAbsolutePathNames) {
                this.convertDirsToRelative();
            }
            this.convertDirectories();
            if (this.checkSpecialCharacters()) {
                return;
            }
            this.checkNamingConvention();
            this.sortFiles();
            StringBuilder contents = new StringBuilder();
            contents.append("# This Makefile was generated by the TITAN Designer eclipse plug-in\n");
            contents.append("# of the TTCN-3 Test executor version ").append(GeneralConstants.VERSION_STRING).append('\n');
            contents.append("# for  (").append(System.getProperty("user.name")).append('@');
            try {
                contents.append(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                contents.append("unknown");
            }
            String pattern = "MMMM dd yyyy";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM dd yyyy");
            String date = simpleDateFormat.format(new Date());
            contents.append(") on ").append(date).append("\n\n");
            contents.append("# ").append("Copyright (c) 2000-2024 Ericsson Telecom AB").append('\n');
            contents.append('\n');
            contents.append("# The following make commands are available:\n");
            contents.append("# - make, make all      ");
            if (this.library) {
                contents.append("Builds the library archive: '" + this.getLibraryName() + "'.\n");
            } else {
                contents.append("Builds the executable test suite.\n");
            }
            contents.append("# - make archive        Archives all source files.\n");
            contents.append("# - make check          Checks the semantics of TTCN-3 and ASN.1 modules.\n");
            contents.append("# - make port           Generates port skeletons.\n");
            contents.append("# - make clean          Removes all generated files.\n");
            contents.append("# - make compile        Translates TTCN-3 and ASN.1 modules to C++.\n");
            contents.append("# - make dep            Creates/updates dependency list.\n");
            contents.append("# - make executable     Builds the executable test suite.\n");
            contents.append("# - make library        Builds the library archive: '" + this.getLibraryName() + "'.\n");
            contents.append("# - make objects        Builds the object files without linking the executable.\n");
            if (this.dynamicLinking) {
                contents.append("# - make shared_objects Builds the shared object files without linking the executable.\n");
            }
            if (this.preprocess) {
                contents.append("# - make preprocess     Preprocess TTCN-3 files.\n");
            }
            if (this.centralStorage) {
                contents.append("# WARNING! This Makefile uses pre-compiled files from the following directories:\n");
                for (BaseDirectoryStruct dir : this.baseDirectories) {
                    contents.append("# ").append((CharSequence)dir.name()).append('\n');
                }
                contents.append("# The executable tests will be consistent only if all directories use\n");
                contents.append("# the same platform and the same version of TTCN-3 Test Executor and\n");
                contents.append("# C++ compiler with the same command line switches.\n\n");
            }
            if (this.gnuMake) {
                contents.append("# WARNING! This Makefile can be used with GNU make only.\n");
                contents.append("# Other versions of make may report syntax errors in it.\n\n");
                contents.append("#\n");
                contents.append("# Do NOT touch this line...\n");
                contents.append("#\n");
                contents.append(".PHONY: all");
                if (this.dynamicLinking) {
                    contents.append(" shared_objects");
                }
                contents.append(" executable library objects check port clean dep archive");
                if (this.preprocess) {
                    contents.append(" preprocess");
                }
                contents.append("\n\n");
                if (this.incrementalDependencyRefresh) {
                    contents.append(".SUFFIXES: .d\n\n");
                }
            }
            contents.append("#\n");
            contents.append("# Set these variables...\n");
            contents.append("#\n");
            contents.append('\n');
            contents.append("# The path of your TTCN-3 Test Executor installation:\n");
            contents.append("# Uncomment this line to override the environment variable.\n");
            contents.append("# TTCN3_DIR =\n");
            String platform = Platform.getOS();
            String platformString = null;
            if ("linux".equals(platform)) {
                platformString = "LINUX";
            } else if ("win32".equals(platform)) {
                platformString = "WIN32";
            } else if ("solaris".equals(platform)) {
                platformString = "SOLARIS";
            }
            contents.append('\n');
            contents.append("# Your platform: (SOLARIS, SOLARIS8, LINUX, FREEBSD or WIN32)\n");
            contents.append("PLATFORM = ").append(platformString).append("\n\n");
            contents.append("# Your C++ compiler:\n");
            contents.append("# (if you change the platform, you may need to change the compiler)\n");
            String compilerName = CCompilerOptionsData.getCompilerName(this.project);
            if (compilerName == null || compilerName.length() == 0) {
                ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Errors detected during Makefile generation", (String)("The C/C++ compiler tool is not set for the project " + this.project.getName() + " using g++ as default."));
                compilerName = "g++";
            }
            contents.append("CXX = ").append(compilerName).append("\n\n");
            if (this.preprocess) {
                contents.append("# C preprocessor used for TTCN-3 files:\n");
                Iterator<Object> preprocessorName = TTCN3PreprocessorOptionsData.getPreprocessorName(this.project);
                if (preprocessorName == null || ((String)((Object)preprocessorName)).length() == 0) {
                    ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Errors detected during Makefile generation", (String)("The preprocessor tool is not set for the project " + this.project.getName() + " using cpp as default."));
                    preprocessorName = "cpp";
                }
                contents.append("CPP = ").append((String)((Object)preprocessorName)).append("\n\n");
            }
            contents.append("# Flags for the C++ preprocessor (and makedepend as well):\n");
            contents.append("CPPFLAGS = -D$(PLATFORM) -I. -I$(TTCN3_DIR)/include");
            if (this.useRuntime2) {
                contents.append(" -DTITAN_RUNTIME_2");
            }
            for (IProject reachableProject : this.reachableProjects) {
                optionList = PreprocessorIncludedOptionsData.getPreprocessorIncludes(reachableProject);
                if (((String[])optionList).length <= 0) continue;
                location = reachableProject.getLocation();
                if (location == null) {
                    ErrorReporter.logError((String)("The project `" + reachableProject.getName() + "' is not located in the local file system. The extra include directories set for it will not be generated into the Makefile"));
                    continue;
                }
                String tempProjectLocation = location.toOSString();
                String[] stringArray = optionList;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String temp = stringArray[i];
                    output = new StringBuilder();
                    temp = TITANPathUtilities.resolvePathURIForMakefile((String)temp, (String)tempProjectLocation, (boolean)reportDebugInformation, (StringBuilder)output);
                    contents.append(" -I").append(temp);
                    TITANDebugConsole.println(output);
                }
            }
            for (IProject reachableProject : this.reachableProjects) {
                optionList = PreprocessorSymbolsOptionsData.getPreprocessorDefines(reachableProject);
                for (String option : optionList) {
                    contents.append(" -D").append(option);
                }
            }
            for (IProject reachableProject : this.reachableProjects) {
                optionList = PreprocessorSymbolsOptionsData.getPreprocessorUndefines(reachableProject);
                for (String option : optionList) {
                    contents.append(" -U").append(option);
                }
            }
            for (BaseDirectoryStruct dir : this.baseDirectories) {
                contents.append(" -I").append((CharSequence)dir.name());
            }
            if (!this.usingSymbolicLinks) {
                for (BaseDirectoryStruct dir : this.additionallyIncludedFolders) {
                    contents.append(" -I").append((CharSequence)dir.name());
                }
            }
            contents.append("\n\n");
            if (this.incrementalDependencyRefresh) {
                contents.append("# Flags for dependency generation\n");
                contents.append("CXXDEPFLAGS = -MM\n\n");
            }
            if (this.preprocess) {
                contents.append("# Flags for preprocessing TTCN-3 files:\n");
                contents.append("CPPFLAGS_TTCN3 = -I.");
                for (BaseDirectoryStruct dir : this.baseDirectories) {
                    contents.append(" -I").append((CharSequence)dir.name());
                }
                if (!this.usingSymbolicLinks) {
                    for (BaseDirectoryStruct dir : this.additionallyIncludedFolders) {
                        contents.append(" -I").append((CharSequence)dir.name());
                    }
                }
                for (IProject reachableProject : this.reachableProjects) {
                    optionList = PreprocessorIncludedOptionsData.getTTCN3PreprocessorIncludes(reachableProject);
                    if (((String[])optionList).length <= 0) continue;
                    location = reachableProject.getLocation();
                    if (location == null) {
                        ErrorReporter.logError((String)("The project `" + reachableProject.getName() + "' is not located in the local file system. The extra preprocessor include directories set for it will not be generated into the Makefile"));
                        continue;
                    }
                    String tempProjectLocation = location.toOSString();
                    for (String option : optionList) {
                        output = new StringBuilder();
                        option = TITANPathUtilities.resolvePathURIForMakefile((String)option, (String)tempProjectLocation, (boolean)reportDebugInformation, (StringBuilder)output);
                        contents.append(" -I").append(option);
                        TITANDebugConsole.println(output);
                    }
                }
                for (IProject reachableProject : this.reachableProjects) {
                    optionList = PreprocessorSymbolsOptionsData.getTTCN3PreprocessorDefines(reachableProject);
                    for (String option : optionList) {
                        contents.append(" -D").append(option);
                    }
                }
                for (IProject reachableProject : this.reachableProjects) {
                    optionList = PreprocessorSymbolsOptionsData.getTTCN3PreprocessorUndefines(reachableProject);
                    for (String option : optionList) {
                        contents.append(" -U").append(option);
                    }
                }
                contents.append("\n\n");
            }
            contents.append("# Flags for the C++ compiler:\n");
            contents.append("CXXFLAGS = -Wall").append(COptimalizationOptionsData.getCxxOptimizationFlags(this.project));
            if (this.dynamicLinking) {
                contents.append(" -fPIC");
            }
            contents.append("\n\n");
            contents.append("# Flags for the linker:\n");
            contents.append("LDFLAGS = ");
            contents.append(LinkerFlagsOptionsData.getLinkerFlags(this.project));
            if (this.dynamicLinking) {
                contents.append(" -fPIC");
            }
            contents.append("\n\n");
            contents.append("ifeq ($(PLATFORM), WIN32)\n");
            contents.append("# Silence linker warnings.\n");
            contents.append("LDFLAGS += -Wl,--enable-auto-import,--enable-runtime-pseudo-reloc\n");
            contents.append("endif\n\n");
            contents.append("# Utility to create library files\n");
            contents.append("AR = ar\n");
            contents.append("ARFLAGS = \n\n");
            contents.append("# Flags for the TTCN-3 and ASN.1 compiler:\n");
            contents.append("# ").append(TITANFlagsOptionsData.getTITANFlagComments(this.project, this.useRuntime2)).append('\n');
            contents.append("COMPILER_FLAGS = ").append(TITANFlagsOptionsData.getTITANFlags(this.project, this.useRuntime2)).append("\n\n");
            contents.append("# Execution mode: ");
            contents.append(this.useRuntime2 ? "function" : "load").append(" test runtime in ");
            contents.append(this.singleMode ? "single" : "parallel").append(" mode");
            contents.append(this.dynamicLinking ? " with dynamic linking" : "").append('\n');
            contents.append("TTCN3_LIB = ttcn3");
            if (this.useRuntime2) {
                contents.append("-rt2");
            }
            if (!this.singleMode) {
                contents.append("-parallel");
            }
            if (this.dynamicLinking) {
                contents.append("-dynamic");
            }
            contents.append("\n\n");
            contents.append("# The path of your OpenSSL installation:\n");
            contents.append("# If you do not have your own one, leave it unchanged.\n");
            String ttcn3Lib = "";
            boolean externalLibrariesDisabled = LinkerLibrariesOptionsData.getExternalFoldersDisabled(this.project);
            if (externalLibrariesDisabled) {
                contents.append("# OPENSSL_DIR = $(TTCN3_").append("").append("DIR)\n\n");
            } else {
                contents.append("OPENSSL_DIR = $(TTCN3_").append("").append("DIR)\n\n");
            }
            contents.append("# The path of your libxml2 installation:\n");
            contents.append("# If you do not have your own one, leave it unchanged.\n");
            if (externalLibrariesDisabled) {
                contents.append("# XMLDIR = $(TTCN3_").append("").append("DIR)\n\n");
            } else {
                contents.append("XMLDIR = $(TTCN3_").append("").append("DIR)\n\n");
            }
            contents.append("# Directory to store the archived source files:\n");
            if (!this.gnuMake) {
                contents.append("# Note: you can set any directory except ./archive\n");
            }
            contents.append("ARCHIVE_DIR = backup\n\n");
            contents.append("#\n");
            contents.append("# You may change these variables. Add your files if necessary...\n");
            contents.append("#\n\n");
            contents.append("# TTCN-3 modules of this project:\n");
            contents.append("TTCN3_MODULES =");
            for (Object module : this.ttcn3Modules) {
                if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                if (this.usingSymbolicLinks) {
                    contents.append(' ').append((CharSequence)((ModuleStruct)module).fileName());
                    continue;
                }
                contents.append(' ').append(((ModuleStruct)module).getOriginalLocation());
            }
            if (this.preprocess) {
                contents.append("\n\n");
                contents.append("# TTCN-3 modules to preprocess:\n");
                contents.append("TTCN3_PP_MODULES =");
                for (Object module : this.ttcnppModules) {
                    if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                    if (this.usingSymbolicLinks) {
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).fileName());
                        continue;
                    }
                    contents.append(' ').append(((ModuleStruct)module).getOriginalLocation());
                }
            }
            if (this.centralStorage) {
                contents.append("\n\n");
                contents.append("# TTCN-3 modules used from central project(s):\n");
                contents.append("BASE_TTCN3_MODULES =");
                for (Object module : this.ttcn3Modules) {
                    if (((ModuleStruct)module).getDirectory() == null) continue;
                    if (this.allProjectsUseSymbolicLinks) {
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).fileName());
                        continue;
                    }
                    contents.append(' ').append(((ModuleStruct)module).getOriginalLocation());
                }
                if (this.preprocess) {
                    contents.append("\n\n");
                    contents.append("# TTCN-3 modules to preprocess used from central project(s):\n");
                    contents.append("BASE_TTCN3_PP_MODULES =");
                    for (Object module : this.ttcnppModules) {
                        if (((ModuleStruct)module).getDirectory() == null) continue;
                        if (this.allProjectsUseSymbolicLinks) {
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).fileName());
                            continue;
                        }
                        contents.append(' ').append(((ModuleStruct)module).getOriginalLocation());
                    }
                }
            }
            if (this.preprocess) {
                contents.append("\n\n");
                contents.append("# Files to include in TTCN-3 preprocessed modules:\n");
                contents.append("TTCN3_INCLUDES =");
                for (TTCN3IncludeFileStruct temp : this.ttcn3IncludeFiles) {
                    if (this.usingSymbolicLinks) {
                        contents.append(' ').append(temp.getWorkspaceLocation());
                        continue;
                    }
                    contents.append(' ').append(temp.getOriginalLocation());
                }
            }
            contents.append("\n\n");
            contents.append("# ASN.1 modules of this project:\n");
            contents.append("ASN1_MODULES =");
            for (Object module : this.asn1modules) {
                if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                if (this.usingSymbolicLinks) {
                    contents.append(' ').append((CharSequence)((ModuleStruct)module).fileName());
                    continue;
                }
                contents.append(' ').append(((ModuleStruct)module).getOriginalLocation());
            }
            if (this.centralStorage) {
                contents.append("\n\n");
                contents.append("# ASN.1 modules used from central project(s):\n");
                contents.append("BASE_ASN1_MODULES =");
                for (Object module : this.asn1modules) {
                    if (((ModuleStruct)module).getDirectory() == null) continue;
                    if (this.allProjectsUseSymbolicLinks) {
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).fileName());
                        continue;
                    }
                    contents.append(' ').append(((ModuleStruct)module).getOriginalLocation());
                }
            }
            if (this.preprocess) {
                contents.append("\n\n");
                contents.append("# TTCN-3 source files generated by the C preprocessor:\n");
                contents.append("PREPROCESSED_TTCN3_MODULES =");
                for (Object module : this.ttcnppModules) {
                    if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                    contents.append(' ').append((CharSequence)((ModuleStruct)module).preprocessedName(false));
                }
                if (this.centralStorage) {
                    contents.append("\n\n");
                    contents.append("# TTCN-3 files generated by the CPP used from central project(s):\n");
                    contents.append("BASE_PREPROCESSED_TTCN3_MODULES =");
                    for (Object module : this.ttcnppModules) {
                        if (((ModuleStruct)module).getDirectory() == null) continue;
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).preprocessedName(true));
                    }
                }
            }
            contents.append("\n\n");
            contents.append("# C++ source & header files generated from the TTCN-3 & ASN.1 ");
            contents.append("modules of\n");
            contents.append("# this project:\n");
            contents.append("GENERATED_SOURCES =");
            if (this.gnuMake && this.ttcn3ModulesRegular && this.allProjectsUseSymbolicLinks) {
                contents.append(" $(TTCN3_MODULES:.ttcn=.cc)");
                if (!"none".equals(this.codeSplittingMode)) {
                    for (Object module : this.ttcn3Modules) {
                        if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                        contents.append((CharSequence)this.getSplittedFilenames((ModuleStruct)module, false));
                    }
                }
                if (this.preprocess) {
                    contents.append(" $(TTCN3_PP_MODULES:.ttcnpp=.cc)");
                    if (!"none".equals(this.codeSplittingMode)) {
                        for (Object module : this.ttcnppModules) {
                            if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                            contents.append((CharSequence)this.getSplittedFilenames((ModuleStruct)module, false));
                        }
                    }
                }
            } else {
                for (Object module : this.ttcn3Modules) {
                    if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                    contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "cc"));
                    if ("none".equals(this.codeSplittingMode)) continue;
                    contents.append((CharSequence)this.getSplittedFilenames((ModuleStruct)module, false));
                }
                if (this.preprocess) {
                    for (Object module : this.ttcnppModules) {
                        if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "cc"));
                        if ("none".equals(this.codeSplittingMode)) continue;
                        contents.append((CharSequence)this.getSplittedFilenames((ModuleStruct)module, false));
                    }
                }
            }
            if (this.gnuMake && this.asn1ModulesRegular && this.allProjectsUseSymbolicLinks) {
                contents.append(" $(ASN1_MODULES:.asn=.cc)");
                if (!"none".equals(this.codeSplittingMode)) {
                    for (Object module : this.asn1modules) {
                        if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                        contents.append((CharSequence)this.getSplittedFilenames((ModuleStruct)module, false));
                    }
                }
            } else {
                for (Object module : this.asn1modules) {
                    if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                    contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "cc"));
                    if ("none".equals(this.codeSplittingMode)) continue;
                    contents.append((CharSequence)this.getSplittedFilenames((ModuleStruct)module, false));
                }
            }
            contents.append("\nGENERATED_HEADERS =");
            if (this.gnuMake) {
                if (this.getSplittingMode().equals("number") || this.getSplittingMode().equals("type")) {
                    if (this.ttcn3ModulesRegular) {
                        contents.append(" $(TTCN3_MODULES:.ttcn=.hh)");
                        if (this.preprocess) {
                            contents.append(" $(TTCN3_PP_MODULES:.ttcnpp=.hh)");
                        }
                    } else {
                        for (Object module : this.ttcn3Modules) {
                            if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "hh"));
                        }
                        if (this.preprocess) {
                            for (Object module : this.ttcnppModules) {
                                if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "hh"));
                            }
                        }
                    }
                    if (this.asn1ModulesRegular) {
                        contents.append(" $(ASN1_MODULES:.asn=.hh)");
                    } else {
                        for (Object module : this.asn1modules) {
                            if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "hh"));
                        }
                    }
                } else {
                    contents.append(" $(GENERATED_SOURCES:.cc=.hh)");
                }
            } else {
                for (Object module : this.ttcn3Modules) {
                    if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                    contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "hh"));
                }
                if (this.preprocess) {
                    for (Object module : this.ttcnppModules) {
                        if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "hh"));
                    }
                }
                for (Object module : this.asn1modules) {
                    if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                    contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "hh"));
                }
            }
            if (this.centralStorage) {
                contents.append("\n\n");
                contents.append("# C++ source & header files generated from the TTCN-3 & ASN.1 ");
                contents.append("modules of\n");
                contents.append("# central project(s):\n");
                contents.append("BASE_GENERATED_SOURCES =");
                if (this.gnuMake && this.baseTTCN3ModulesRegular && this.allProjectsUseSymbolicLinks) {
                    contents.append(" $(BASE_TTCN3_MODULES:.ttcn=.cc)");
                    if (!"none".equals(this.codeSplittingMode)) {
                        for (Object module : this.ttcn3Modules) {
                            if (((ModuleStruct)module).getDirectory() == null) continue;
                            contents.append((CharSequence)this.getSplittedFilenames((ModuleStruct)module, false));
                        }
                    }
                    if (this.preprocess) {
                        contents.append(" $(BASE_TTCN3_PP_MODULES:.ttcnpp=.cc)");
                        if (!"none".equals(this.codeSplittingMode)) {
                            for (Object module : this.ttcnppModules) {
                                if (((ModuleStruct)module).getDirectory() == null) continue;
                                contents.append((CharSequence)this.getSplittedFilenames((ModuleStruct)module, false));
                            }
                        }
                    }
                } else {
                    for (Object module : this.ttcn3Modules) {
                        if (((ModuleStruct)module).getDirectory() == null) continue;
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "cc"));
                        if ("none".equals(this.codeSplittingMode)) continue;
                        contents.append((CharSequence)this.getSplittedFilenames((ModuleStruct)module, true));
                    }
                    if (this.preprocess) {
                        for (Object module : this.ttcnppModules) {
                            if (((ModuleStruct)module).getDirectory() == null) continue;
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "cc"));
                            if ("none".equals(this.codeSplittingMode)) continue;
                            contents.append((CharSequence)this.getSplittedFilenames((ModuleStruct)module, true));
                        }
                    }
                }
                if (this.gnuMake && this.baseASN1ModulesRegular && this.allProjectsUseSymbolicLinks) {
                    contents.append(" $(BASE_ASN1_MODULES:.asn=.cc)");
                    if (!"none".equals(this.codeSplittingMode)) {
                        for (Object module : this.asn1modules) {
                            if (((ModuleStruct)module).getDirectory() == null) continue;
                            contents.append((CharSequence)this.getSplittedFilenames((ModuleStruct)module, false));
                        }
                    }
                } else {
                    for (Object module : this.asn1modules) {
                        if (((ModuleStruct)module).getDirectory() == null) continue;
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "cc"));
                        if ("none".equals(this.codeSplittingMode)) continue;
                        contents.append((CharSequence)this.getSplittedFilenames((ModuleStruct)module, true));
                    }
                }
                contents.append("\nBASE_GENERATED_HEADERS =");
                if (this.gnuMake) {
                    if (this.getSplittingMode().equals("number") || this.getSplittingMode().equals("type")) {
                        if (this.ttcn3ModulesRegular) {
                            contents.append(" $(BASE_TTCN3_MODULES:.ttcn=.hh)");
                            if (this.preprocess) {
                                contents.append(" $(BASE_TTCN3_PP_MODULES:.ttcnpp=.hh)");
                            }
                        } else {
                            for (Object module : this.ttcn3Modules) {
                                if (((ModuleStruct)module).getDirectory() == null) continue;
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "hh"));
                            }
                            if (this.preprocess) {
                                for (Object module : this.ttcnppModules) {
                                    if (((ModuleStruct)module).getDirectory() == null) continue;
                                    contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "hh"));
                                }
                            }
                        }
                        if (this.asn1ModulesRegular) {
                            contents.append(" $(BASE_ASN1_MODULES:.asn=.hh)");
                        } else {
                            for (Object module : this.asn1modules) {
                                if (((ModuleStruct)module).getDirectory() == null) continue;
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "hh"));
                            }
                        }
                    } else {
                        contents.append(" $(BASE_GENERATED_SOURCES:.cc=.hh)");
                    }
                } else {
                    for (Object module : this.ttcn3Modules) {
                        if (((ModuleStruct)module).getDirectory() == null) continue;
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "hh"));
                    }
                    if (this.preprocess) {
                        for (Object module : this.ttcnppModules) {
                            if (((ModuleStruct)module).getDirectory() == null) continue;
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "hh"));
                        }
                    }
                    for (Object module : this.asn1modules) {
                        if (((ModuleStruct)module).getDirectory() == null) continue;
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "hh"));
                    }
                }
            }
            contents.append("\n\n");
            contents.append("# C/C++ Source & header files of Test Ports, external functions ");
            contents.append("and\n");
            contents.append("# other modules:\n");
            contents.append("USER_SOURCES =");
            for (UserStruct user : this.userFiles) {
                if (user.getDirectory() != null && this.centralStorage) continue;
                if (!this.usingSymbolicLinks && user.getOriginalSourceLocation() != null) {
                    contents.append(' ').append(user.getOriginalSourceLocation());
                    continue;
                }
                contents.append(' ').append((CharSequence)user.sourceName());
            }
            contents.append("\nUSER_HEADERS =");
            if (this.gnuMake && this.userHeadersRegular) {
                contents.append(" $(USER_SOURCES:.cc=.hh)");
            } else {
                for (UserStruct user : this.userFiles) {
                    if (user.getDirectory() != null && this.centralStorage) continue;
                    if (!this.usingSymbolicLinks && user.getOriginalHeaderLocation() != null) {
                        contents.append(' ').append(user.getOriginalHeaderLocation());
                        continue;
                    }
                    contents.append(' ').append((CharSequence)user.headerName());
                }
            }
            if (this.centralStorage) {
                contents.append("\n\n");
                contents.append("# C/C++ Source & header files of Test Ports, external functions ");
                contents.append("and\n");
                contents.append("# other modules used from central project(s):\n");
                contents.append("BASE_USER_SOURCES =");
                for (UserStruct user : this.userFiles) {
                    if (user.getDirectory() == null) continue;
                    contents.append(' ').append((CharSequence)user.sourceName());
                }
                contents.append("\nBASE_USER_HEADERS =");
                if (this.gnuMake && this.baseUserHeadersRegular) {
                    contents.append(" $(BASE_USER_SOURCES:.cc=.hh)");
                } else {
                    for (UserStruct user : this.userFiles) {
                        if (user.getDirectory() == null) continue;
                        contents.append(' ').append((CharSequence)user.headerName());
                    }
                }
            }
            contents.append("\n\n");
            contents.append("# Object files of this project that are needed for the executable ");
            contents.append("test suite:\n");
            contents.append("OBJECTS = $(GENERATED_OBJECTS) $(USER_OBJECTS)\n\n");
            contents.append("GENERATED_OBJECTS =");
            if (this.gnuMake) {
                contents.append(" $(GENERATED_SOURCES:.cc=.o)");
            } else {
                for (Object module : this.ttcn3Modules) {
                    if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                    contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o"));
                    if ("type".equals(this.codeSplittingMode)) {
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_seq"));
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_seqof"));
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_set"));
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_setof"));
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_union"));
                        continue;
                    }
                    if ("none".equals(this.codeSplittingMode)) continue;
                    int n_slices = Integer.parseInt(this.codeSplittingMode);
                    for (int i = 1; i < n_slices; ++i) {
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_part_" + i));
                    }
                }
                if (this.preprocess) {
                    for (Object module : this.ttcnppModules) {
                        if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o"));
                        if ("type".equals(this.codeSplittingMode)) {
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_seq"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_seqof"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_set"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_setof"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_union"));
                            continue;
                        }
                        if ("none".equals(this.codeSplittingMode)) continue;
                        int n_slices = Integer.parseInt(this.codeSplittingMode);
                        for (int i = 1; i < n_slices; ++i) {
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_part_" + i));
                        }
                    }
                }
                for (Object module : this.asn1modules) {
                    if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                    contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o"));
                    if ("type".equals(this.codeSplittingMode)) {
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_seq"));
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_seqof"));
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_set"));
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_setof"));
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_union"));
                        continue;
                    }
                    if ("none".equals(this.codeSplittingMode)) continue;
                    int n_slices = Integer.parseInt(this.codeSplittingMode);
                    for (int i = 1; i < n_slices; ++i) {
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "o", "_part_" + i));
                    }
                }
            }
            contents.append("\n\nUSER_OBJECTS =");
            if (this.gnuMake && this.userSourcesRegular && this.usingSymbolicLinks) {
                contents.append(" $(USER_SOURCES:.cc=.o)");
            } else {
                for (UserStruct user : this.userFiles) {
                    StringBuilder objectName;
                    if (user.getDirectory() != null && this.centralStorage || (objectName = user.objectName()) == null) continue;
                    contents.append(' ').append((CharSequence)objectName);
                }
            }
            if (this.dynamicLinking) {
                contents.append("\n\n");
                contents.append("# Shared object files of this project that are needed for the executable ");
                contents.append("test suite:\n");
                contents.append("SHARED_OBJECTS =");
                if (this.gnuMake) {
                    contents.append(" $(GENERATED_SOURCES:.cc=.so)");
                } else {
                    for (Object module : this.ttcn3Modules) {
                        if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so"));
                        if ("type".equals(this.codeSplittingMode)) {
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_seq"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_seqof"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_set"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_setof"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_union"));
                            continue;
                        }
                        if ("none".equals(this.codeSplittingMode)) continue;
                        int n_slices = Integer.parseInt(this.codeSplittingMode);
                        for (int i = 1; i < n_slices; ++i) {
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_part_" + i));
                        }
                    }
                    if (this.preprocess) {
                        for (Object module : this.ttcnppModules) {
                            if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so"));
                            if ("type".equals(this.codeSplittingMode)) {
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_seq"));
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_seqof"));
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_set"));
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_setof"));
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_union"));
                                continue;
                            }
                            if ("none".equals(this.codeSplittingMode)) continue;
                            int n_slices = Integer.parseInt(this.codeSplittingMode);
                            for (int i = 1; i < n_slices; ++i) {
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_part_" + i));
                            }
                        }
                    }
                    for (Object module : this.asn1modules) {
                        if (((ModuleStruct)module).getDirectory() != null && this.centralStorage) continue;
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so"));
                        if ("type".equals(this.codeSplittingMode)) {
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_seq"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_seqof"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_set"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_setof"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_union"));
                            continue;
                        }
                        if ("none".equals(this.codeSplittingMode)) continue;
                        int n_slices = Integer.parseInt(this.codeSplittingMode);
                        for (int i = 1; i < n_slices; ++i) {
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(false, "so", "_part_" + i));
                        }
                    }
                }
                if (this.gnuMake && this.userSourcesRegular) {
                    contents.append(" $(USER_SOURCES:.cc=.so)");
                } else {
                    for (UserStruct user : this.userFiles) {
                        Object sharedObjectName;
                        if (user.getDirectory() != null && this.centralStorage || (sharedObjectName = user.specialName("so")) == null) continue;
                        contents.append(' ').append((CharSequence)sharedObjectName);
                    }
                }
            }
            if (this.centralStorage) {
                contents.append("\n\n");
                contents.append("# Object files of central project(s) that are needed for the ");
                contents.append("executable test suite:\n");
                contents.append("BASE_OBJECTS =");
                if (this.gnuMake) {
                    contents.append(" $(BASE_GENERATED_SOURCES:.cc=.o)");
                } else {
                    for (Object module : this.ttcn3Modules) {
                        if (((ModuleStruct)module).getDirectory() == null) continue;
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o"));
                        if ("type".equals(this.codeSplittingMode)) {
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_seq"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_seqof"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_set"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_setof"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_union"));
                            continue;
                        }
                        if ("none".equals(this.codeSplittingMode)) continue;
                        int n_slices = Integer.parseInt(this.codeSplittingMode);
                        for (int i = 1; i < n_slices; ++i) {
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_part_" + i));
                        }
                    }
                    if (this.preprocess) {
                        for (Object module : this.ttcnppModules) {
                            if (((ModuleStruct)module).getDirectory() == null) continue;
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o"));
                            if ("type".equals(this.codeSplittingMode)) {
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_seq"));
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_seqof"));
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_set"));
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_setof"));
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_union"));
                                continue;
                            }
                            if ("none".equals(this.codeSplittingMode)) continue;
                            int n_slices = Integer.parseInt(this.codeSplittingMode);
                            for (int i = 1; i < n_slices; ++i) {
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_part_" + i));
                            }
                        }
                    }
                    for (Object module : this.asn1modules) {
                        if (((ModuleStruct)module).getDirectory() == null) continue;
                        contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o"));
                        if ("type".equals(this.codeSplittingMode)) {
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_seq"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_seqof"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_set"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_setof"));
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_union"));
                            continue;
                        }
                        if ("none".equals(this.codeSplittingMode)) continue;
                        int n_slices = Integer.parseInt(this.codeSplittingMode);
                        for (int i = 1; i < n_slices; ++i) {
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "o", "_part_" + i));
                        }
                    }
                }
                if (this.gnuMake && this.baseUserSourcesRegular) {
                    contents.append(" $(BASE_USER_SOURCES:.cc=.o)");
                } else {
                    for (UserStruct user : this.userFiles) {
                        Iterator<Comparable<ModuleStruct>> objectName;
                        if (user.getDirectory() == null || (objectName = user.objectName()) == null) continue;
                        contents.append(' ').append((CharSequence)((Object)objectName));
                    }
                }
                if (this.dynamicLinking) {
                    contents.append("\n\n");
                    contents.append("# Shared object files of central project(s) that are needed for the ");
                    contents.append("executable test suite:\n");
                    contents.append("BASE_SHARED_OBJECTS =");
                    if (this.gnuMake) {
                        contents.append(" $(BASE_GENERATED_SOURCES:.cc=.so)");
                    } else {
                        for (Object module : this.ttcn3Modules) {
                            if (((ModuleStruct)module).getDirectory() == null) continue;
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so"));
                            if ("type".equals(this.codeSplittingMode)) {
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_seq"));
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_seqof"));
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_set"));
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_setof"));
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_union"));
                                continue;
                            }
                            if ("none".equals(this.codeSplittingMode)) continue;
                            int n_slices = Integer.parseInt(this.codeSplittingMode);
                            for (int i = 1; i < n_slices; ++i) {
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_part_" + i));
                            }
                        }
                        if (this.preprocess) {
                            for (Object module : this.ttcnppModules) {
                                if (((ModuleStruct)module).getDirectory() == null) continue;
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so"));
                                if ("type".equals(this.codeSplittingMode)) {
                                    contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_seq"));
                                    contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_seqof"));
                                    contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_set"));
                                    contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_setof"));
                                    contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_union"));
                                    continue;
                                }
                                if ("none".equals(this.codeSplittingMode)) continue;
                                int n_slices = Integer.parseInt(this.codeSplittingMode);
                                for (int i = 1; i < n_slices; ++i) {
                                    contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_part_" + i));
                                }
                            }
                        }
                        for (Object module : this.asn1modules) {
                            if (((ModuleStruct)module).getDirectory() == null) continue;
                            contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so"));
                            if ("type".equals(this.codeSplittingMode)) {
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_seq"));
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_seqof"));
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_set"));
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_setof"));
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_union"));
                                continue;
                            }
                            if ("none".equals(this.codeSplittingMode)) continue;
                            int n_slices = Integer.parseInt(this.codeSplittingMode);
                            for (int i = 1; i < n_slices; ++i) {
                                contents.append(' ').append((CharSequence)((ModuleStruct)module).generatedName(true, "so", "_part_" + i));
                            }
                        }
                    }
                    if (this.gnuMake && this.baseUserSourcesRegular) {
                        contents.append(" $(BASE_USER_SOURCES:.cc=.so)");
                    } else {
                        for (UserStruct user : this.userFiles) {
                            StringBuilder sharedObjectName;
                            if (user.getDirectory() == null || (sharedObjectName = user.specialName("so")) == null) continue;
                            contents.append(' ').append((CharSequence)sharedObjectName);
                        }
                    }
                }
            }
            if (this.incrementalDependencyRefresh) {
                contents.append("\n\n");
                contents.append("# Dependency files of this project that are needed for the executable test suite:\n");
                contents.append("DEPFILES =");
                contents.append(" $(USER_OBJECTS:.o=.d) $(GENERATED_OBJECTS:.o=.d)");
            }
            contents.append("\n\n");
            contents.append("# Other files of the project (Makefile, configuration files, etc.)\n");
            contents.append("# that will be added to the archived source files:\n");
            contents.append("OTHER_FILES =");
            for (OtherFileStruct file : this.otherFiles) {
                if (!this.usingSymbolicLinks && file.getOriginalLocation() != null) {
                    contents.append(' ').append(file.getOriginalLocation());
                    continue;
                }
                contents.append(' ').append((CharSequence)file.name(this.workingDirectory, this.useAbsolutePathNames));
            }
            contents.append("\n\n");
            contents.append("# The name of the executable test suite:\n");
            contents.append("EXECUTABLE = ").append(this.etsName).append('\n');
            contents.append("LIBRARY = " + this.getLibraryName() + '\n');
            contents.append("\nTARGET = " + (this.library ? "$(LIBRARY)" : "$(EXECUTABLE)"));
            String zlib = "";
            String rmCommand = this.gnuMake ? "$(RM)" : "rm -f";
            contents.append("\n\n");
            contents.append("#\n");
            contents.append("# Do not modify these unless you know what you are doing...\n");
            contents.append("# Platform specific additional libraries:\n");
            contents.append("#\n");
            contents.append("SOLARIS_LIBS = -lsocket -lnsl -lxml2 ").append("");
            contents.append(" -lresolv");
            for (IProject reachableProject : this.reachableProjects) {
                String[] optionList2;
                for (String option : optionList2 = PlatformSpecificLibrariesOptionsData.getPlatformSpecificLibraries(reachableProject, "Solaris")) {
                    contents.append(" -l").append(option);
                }
            }
            contents.append('\n');
            contents.append("SOLARIS8_LIBS = -lsocket -lnsl -lxml2 ").append("");
            contents.append(" -lresolv");
            for (IProject reachableProject : this.reachableProjects) {
                String[] optionList3;
                for (String option : optionList3 = PlatformSpecificLibrariesOptionsData.getPlatformSpecificLibraries(reachableProject, "Solaris8")) {
                    contents.append(" -l").append(option);
                }
            }
            contents.append('\n');
            contents.append("LINUX_LIBS = -lxml2 -lpthread ").append("");
            contents.append(" -lrt");
            for (IProject reachableProject : this.reachableProjects) {
                String[] optionList4;
                for (String option : optionList4 = PlatformSpecificLibrariesOptionsData.getPlatformSpecificLibraries(reachableProject, "Linux")) {
                    contents.append(" -l").append(option);
                }
            }
            contents.append('\n');
            contents.append("FREEBSD_LIBS = -lxml2 ").append("");
            for (IProject reachableProject : this.reachableProjects) {
                String[] optionList5;
                for (String option : optionList5 = PlatformSpecificLibrariesOptionsData.getPlatformSpecificLibraries(reachableProject, "FreeBSD")) {
                    contents.append(" -l").append(option);
                }
            }
            contents.append('\n');
            contents.append("WIN32_LIBS = -lxml2 ").append("");
            for (IProject reachableProject : this.reachableProjects) {
                String[] optionList6;
                for (String option : optionList6 = PlatformSpecificLibrariesOptionsData.getPlatformSpecificLibraries(reachableProject, "Win32")) {
                    contents.append(" -l").append(option);
                }
            }
            contents.append("\n\n");
            contents.append("#\n");
            contents.append("# Rules for building the executable...\n");
            contents.append("#\n\n");
            contents.append("all: $(TARGET) ;\n\n");
            contents.append("executable: $(EXECUTABLE) ;\n\n");
            contents.append("library: $(LIBRARY) ;\n\n");
            contents.append("objects: $(OBJECTS) compile;\n\n");
            if (this.dynamicLinking) {
                contents.append("shared_objects: $(SHARED_OBJECTS) ;\n\n");
            }
            StringBuilder allObjects = new StringBuilder();
            if (this.dynamicLinking) {
                allObjects.append("$(SHARED_OBJECTS)");
                if (this.centralStorage) {
                    allObjects.append(" $(BASE_SHARED_OBJECTS)");
                }
            } else {
                allObjects.append("$(OBJECTS)");
                if (this.centralStorage) {
                    allObjects.append(" $(BASE_OBJECTS)");
                }
            }
            this.appendExecutableTarget(contents, allObjects.toString(), externalLibrariesDisabled);
            contents.append("$(LIBRARY): " + allObjects + '\n');
            if (this.dynamicLinking) {
                contents.append("\t$(CXX) -shared -o $@ " + allObjects + "\n\n");
            } else {
                contents.append("\t$(AR) -r $(ARFLAGS) $(LIBRARY) " + allObjects + "\n\n");
            }
            if (this.dynamicLinking) {
                contents.append("%.so: %.o\n");
                contents.append("\t$(CXX) -shared -o $@ $<\n\n");
            }
            if (!this.usingSymbolicLinks) {
                for (UserStruct user : this.userFiles) {
                    StringBuilder objectName = user.objectName();
                    if (objectName == null) continue;
                    contents.append(objectName + " : ");
                    if (user.getOriginalSourceLocation() != null) {
                        contents.append(' ').append(user.getOriginalSourceLocation());
                    } else {
                        contents.append(' ').append((CharSequence)user.sourceName());
                    }
                    contents.append('\n');
                    contents.append("\t$(CXX) -c $(CPPFLAGS) $(CXXFLAGS) -o $@ $<\n\n");
                }
            }
            contents.append(".cc.o .c.o:\n");
            contents.append("\t$(CXX) -c $(CPPFLAGS) $(CXXFLAGS) -o $@ $<\n\n");
            if (this.incrementalDependencyRefresh) {
                if (!this.usingSymbolicLinks) {
                    for (UserStruct user : this.userFiles) {
                        StringBuilder depName = user.specialName("d");
                        if (depName == null) continue;
                        contents.append(depName + " : ");
                        if (user.getOriginalSourceLocation() != null) {
                            contents.append(' ').append(user.getOriginalSourceLocation());
                        } else {
                            contents.append(' ').append((CharSequence)user.sourceName());
                        }
                        contents.append('\n');
                        contents.append("\t@echo Creating dependency file for '$<'; set -e; \\\n");
                        contents.append("\t$(CXX) $(CXXDEPFLAGS) $(CPPFLAGS) $(CXXFLAGS) $< \\\n");
                        contents.append("\t| sed 's/\\($*\\)\\.o[ :]*/\\1.o $@ : /g' > $@; \\\n");
                        contents.append("\t[ -s $@ ] || rm -f $@\n\n");
                    }
                }
                contents.append(".cc.d .c.d:\n");
                contents.append("\t@echo Creating dependency file for '$<'; set -e; \\\n");
                contents.append("\t$(CXX) $(CXXDEPFLAGS) $(CPPFLAGS) $(CXXFLAGS) $< \\\n");
                contents.append("\t| sed 's/\\($*\\)\\.o[ :]*/\\1.o $@ : /g' > $@; \\\n");
                contents.append("\t[ -s $@ ] || rm -f $@\n\n");
            }
            if (this.preprocess) {
                if (!this.usingSymbolicLinks) {
                    for (ModuleStruct module : this.ttcnppModules) {
                        StringBuilder depName = module.preprocessedName(true);
                        if (depName == null) continue;
                        contents.append(depName + " : ");
                        if (module.getOriginalLocation() != null) {
                            contents.append(' ').append(module.getOriginalLocation());
                        } else {
                            contents.append(' ').append(module.getFileName());
                        }
                        contents.append(" $(TTCN3_INCLUDES) \n");
                        contents.append("\t$(CPP) -x c -nostdinc $(CPPFLAGS_TTCN3) $< $@\n\n");
                    }
                }
                contents.append("%.ttcn: %.ttcnpp $(TTCN3_INCLUDES)\n");
                contents.append("\t$(CPP) -x c -nostdinc $(CPPFLAGS_TTCN3) $< $@\n\n");
                contents.append("preprocess: $(PREPROCESSED_TTCN3_MODULES) ;\n\n");
            }
            if (this.centralStorage) {
                boolean isFirst = true;
                contents.append("$(GENERATED_SOURCES) $(GENERATED_HEADERS): compile-all compile");
                for (BaseDirectoryStruct dir : this.baseDirectories) {
                    if (!dir.isHasModules()) continue;
                    if (isFirst) {
                        contents.append(" \\\n");
                        isFirst = false;
                    } else {
                        contents.append(' ');
                    }
                    if (".".equals(dir.name().toString())) continue;
                    contents.append((CharSequence)dir.name()).append("/compile");
                }
                if (this.preprocess) {
                    contents.append('\n');
                    contents.append("\t@if [ ! -f $@ ]; then ").append(rmCommand).append(" compile-all; $(MAKE) compile-all; fi\n");
                    contents.append('\n');
                    contents.append("check: $(TTCN3_MODULES) $(BASE_TTCN3_MODULES) \\\n");
                    contents.append("$(PREPROCESSED_TTCN3_MODULES) $(BASE_PREPROCESSED_TTCN3_MODULES) ");
                    contents.append("\\\n");
                    contents.append("$(ASN1_MODULES) $(BASE_ASN1_MODULES)\n");
                    contents.append("\t$(TTCN3_DIR)/bin/compiler -s $(COMPILER_FLAGS) ");
                    if (this.gnuMake) {
                        contents.append("$^");
                    } else {
                        contents.append("\\\n");
                        contents.append("\t$(TTCN3_MODULES) $(BASE_TTCN3_MODULES) \\\n");
                        contents.append("\t$(PREPROCESSED_TTCN3_MODULES) ");
                        contents.append("$(BASE_PREPROCESSED_TTCN3_MODULES) \\\n");
                        contents.append("\t$(ASN1_MODULES) $(BASE_ASN1_MODULES)");
                    }
                    contents.append("\n\n");
                    contents.append("port: $(TTCN3_MODULES) $(BASE_TTCN3_MODULES) \\\n");
                    contents.append("$(PREPROCESSED_TTCN3_MODULES) $(BASE_PREPROCESSED_TTCN3_MODULES) ");
                    contents.append("\\\n");
                    contents.append("$(ASN1_MODULES) $(BASE_ASN1_MODULES)\n");
                    contents.append("\t$(TTCN3_DIR)/bin/compiler -t $(COMPILER_FLAGS) ");
                    if (this.gnuMake) {
                        contents.append("$^");
                    } else {
                        contents.append("\\\n");
                        contents.append("\t$(TTCN3_MODULES) $(BASE_TTCN3_MODULES) \\\n");
                        contents.append("\t$(PREPROCESSED_TTCN3_MODULES) ");
                        contents.append("$(BASE_PREPROCESSED_TTCN3_MODULES)");
                    }
                    contents.append("\n\n");
                    contents.append("compile: $(TTCN3_MODULES) $(PREPROCESSED_TTCN3_MODULES) ");
                    contents.append("$(ASN1_MODULES)\n");
                    contents.append("\t$(TTCN3_DIR)/bin/compiler $(COMPILER_FLAGS) \\\n");
                    contents.append("\t$(TTCN3_MODULES) $(BASE_TTCN3_MODULES) \\\n");
                    contents.append("\t$(PREPROCESSED_TTCN3_MODULES) ");
                    contents.append("$(BASE_PREPROCESSED_TTCN3_MODULES) \\\n");
                    contents.append("\t$(ASN1_MODULES) $(BASE_ASN1_MODULES) - $?\n");
                    contents.append("\ttouch $@\n");
                    contents.append('\n');
                    contents.append("compile-all: $(BASE_TTCN3_MODULES) ");
                    contents.append("$(BASE_PREPROCESSED_TTCN3_MODULES) \\\n");
                    contents.append("$(BASE_ASN1_MODULES)\n");
                    contents.append("\t$(MAKE) preprocess\n");
                    contents.append("\t$(TTCN3_DIR)/bin/compiler $(COMPILER_FLAGS) \\\n");
                    contents.append("\t$(TTCN3_MODULES) $(BASE_TTCN3_MODULES) \\\n");
                    contents.append("\t$(PREPROCESSED_TTCN3_MODULES) $(BASE_PREPROCESSED_TTCN3_MODULES) ");
                    contents.append("\\\n");
                    contents.append("\t$(ASN1_MODULES) $(BASE_ASN1_MODULES) \\\n");
                    contents.append("\t- $(TTCN3_MODULES) $(PREPROCESSED_TTCN3_MODULES) $(ASN1_MODULES)\n");
                    contents.append("\ttouch $@ compile\n\n");
                } else {
                    contents.append('\n');
                    contents.append("\t@if [ ! -f $@ ]; then ").append(rmCommand).append(" compile-all; $(MAKE) compile-all; fi\n");
                    contents.append('\n');
                    contents.append("check: $(TTCN3_MODULES) $(BASE_TTCN3_MODULES) \\\n");
                    contents.append("$(ASN1_MODULES) $(BASE_ASN1_MODULES)\n");
                    contents.append("\t$(TTCN3_DIR)/bin/compiler -s $(COMPILER_FLAGS) ");
                    if (this.gnuMake) {
                        contents.append("$^");
                    } else {
                        contents.append("\\\n");
                        contents.append("\t$(TTCN3_MODULES) $(BASE_TTCN3_MODULES) \\\n");
                        contents.append("\t$(ASN1_MODULES) $(BASE_ASN1_MODULES)");
                    }
                    contents.append("\n\n");
                    contents.append("port: $(TTCN3_MODULES) $(BASE_TTCN3_MODULES) \\\n");
                    contents.append("$(ASN1_MODULES) $(BASE_ASN1_MODULES)\n");
                    contents.append("\t$(TTCN3_DIR)/bin/compiler -t $(COMPILER_FLAGS) ");
                    if (this.gnuMake) {
                        contents.append("$^");
                    } else {
                        contents.append("\\\n");
                        contents.append("\t$(TTCN3_MODULES) $(BASE_TTCN3_MODULES)");
                    }
                    contents.append("\n\n");
                    contents.append("compile: $(TTCN3_MODULES) $(ASN1_MODULES)\n");
                    contents.append("\t$(TTCN3_DIR)/bin/compiler $(COMPILER_FLAGS) \\\n");
                    contents.append("\t$(TTCN3_MODULES) $(BASE_TTCN3_MODULES) \\\n");
                    contents.append("\t$(ASN1_MODULES) $(BASE_ASN1_MODULES) \\\n");
                    contents.append("\t- $?\n");
                    contents.append("\ttouch $@\n");
                    contents.append('\n');
                    contents.append("compile-all: $(BASE_TTCN3_MODULES) $(BASE_ASN1_MODULES)\n");
                    contents.append("\t$(TTCN3_DIR)/bin/compiler $(COMPILER_FLAGS) \\\n");
                    contents.append("\t$(TTCN3_MODULES) $(BASE_TTCN3_MODULES) \\\n");
                    contents.append("\t$(ASN1_MODULES) $(BASE_ASN1_MODULES) \\\n");
                    contents.append("\t- $(TTCN3_MODULES) $(ASN1_MODULES)\n");
                    contents.append("\ttouch $@ compile\n\n");
                }
                for (BaseDirectoryStruct dir : this.baseDirectories) {
                    String dirName;
                    if (!dir.isHasModules() || ".".equals(dir.name().toString())) continue;
                    contents.append((CharSequence)dir.name()).append("/compile:");
                    if (this.allProjectsUseSymbolicLinks) {
                        for (ModuleStruct module : this.ttcn3Modules) {
                            dirName = module.getDirectory();
                            if (dirName == null || !dir.getDirectoryName().equals(dirName)) continue;
                            contents.append(' ').append((CharSequence)dir.name()).append('/').append(module.getFileName());
                        }
                        for (ModuleStruct module : this.ttcnppModules) {
                            dirName = module.getDirectory();
                            if (dirName == null || !dir.getDirectoryName().equals(dirName)) continue;
                            contents.append(' ').append((CharSequence)dir.name()).append('/').append(module.getFileName());
                        }
                        for (ModuleStruct module : this.asn1modules) {
                            dirName = module.getDirectory();
                            if (dirName == null || !dir.getDirectoryName().equals(dirName)) continue;
                            contents.append(' ').append((CharSequence)dir.name()).append('/').append(module.getFileName());
                        }
                    } else {
                        for (ModuleStruct module : this.ttcn3Modules) {
                            dirName = module.getDirectory();
                            if (dirName == null || !dir.getDirectoryName().equals(dirName)) continue;
                            contents.append(' ').append(module.getOriginalLocation());
                        }
                        for (ModuleStruct module : this.ttcnppModules) {
                            dirName = module.getDirectory();
                            if (dirName == null || !dir.getDirectoryName().equals(dirName)) continue;
                            contents.append(' ').append(module.getOriginalLocation());
                        }
                        for (ModuleStruct module : this.asn1modules) {
                            dirName = module.getDirectory();
                            if (dirName == null || !dir.getDirectoryName().equals(dirName)) continue;
                            contents.append(' ').append(module.getOriginalLocation());
                        }
                    }
                    contents.append('\n');
                    contents.append("\t@echo 'Central directory ").append((CharSequence)dir.originalName()).append(" is not up-to-date!'\n");
                    contents.append("\t@exit 2\n\n");
                }
                contents.append("browserdata.dat: $(TTCN3_MODULES) $(BASE_TTCN3_MODULES) \\\n");
                if (this.preprocess) {
                    contents.append("$(PREPROCESSED_TTCN3_MODULES) ");
                    contents.append("$(BASE_PREPROCESSED_TTCN3_MODULES) \\\n");
                }
                contents.append("$(ASN1_MODULES) $(BASE_ASN1_MODULES)\n");
                contents.append("\t$(TTCN3_DIR)/bin/compiler -B -s $(COMPILER_FLAGS) ");
                if (this.gnuMake) {
                    contents.append("$^");
                } else {
                    contents.append("\\\n");
                    contents.append("\t$(TTCN3_MODULES) $(BASE_TTCN3_MODULES) \\\n");
                    if (this.preprocess) {
                        contents.append("\t$(PREPROCESSED_TTCN3_MODULES) ");
                        contents.append("$(BASE_PREPROCESSED_TTCN3_MODULES) \\\n");
                    }
                    contents.append("\t$(BASE_ASN1_MODULES) $(ASN1_MODULES)");
                }
                contents.append("\n\n");
            } else {
                contents.append("$(GENERATED_SOURCES) $(GENERATED_HEADERS): compile\n");
                contents.append("\t@if [ ! -f $@ ]; then ").append(rmCommand).append(" compile; $(MAKE) compile; fi\n\n");
                contents.append("check: $(TTCN3_MODULES) ");
                if (this.preprocess) {
                    contents.append("$(PREPROCESSED_TTCN3_MODULES) ");
                }
                contents.append("$(ASN1_MODULES)\n");
                contents.append("\t$(TTCN3_DIR)/bin/compiler -s $(COMPILER_FLAGS) ");
                if (this.gnuMake) {
                    contents.append("$^");
                } else {
                    contents.append("\\\n");
                    contents.append("\t$(TTCN3_MODULES) $(PREPROCESSED_TTCN3_MODULES) $(ASN1_MODULES)");
                }
                contents.append("\n\n");
                contents.append("port: $(TTCN3_MODULES) ");
                if (this.preprocess) {
                    contents.append("$(PREPROCESSED_TTCN3_MODULES) ");
                }
                contents.append("$(ASN1_MODULES)\n");
                contents.append("\t$(TTCN3_DIR)/bin/compiler -t $(COMPILER_FLAGS) ");
                if (this.gnuMake) {
                    contents.append("$^");
                } else {
                    contents.append("\\\n");
                    contents.append("\t$(TTCN3_MODULES) $(PREPROCESSED_TTCN3_MODULES)");
                }
                contents.append("\n\n");
                contents.append("compile: $(TTCN3_MODULES) ");
                if (this.preprocess) {
                    contents.append("$(PREPROCESSED_TTCN3_MODULES) ");
                }
                contents.append("$(ASN1_MODULES)\n");
                contents.append("\t$(TTCN3_DIR)/bin/compiler $(COMPILER_FLAGS) ");
                if (this.gnuMake) {
                    contents.append("$^");
                } else {
                    contents.append("\\\n");
                    contents.append("\t$(TTCN3_MODULES) ");
                    if (this.preprocess) {
                        contents.append("$(PREPROCESSED_TTCN3_MODULES) ");
                    }
                    contents.append("$(ASN1_MODULES)");
                }
                contents.append(" - $?\n");
                contents.append("\ttouch $@\n");
                contents.append('\n');
                contents.append("browserdata.dat: $(TTCN3_MODULES) ");
                if (this.preprocess) {
                    contents.append("$(PREPROCESSED_TTCN3_MODULES) ");
                }
                contents.append("$(ASN1_MODULES)\n");
                contents.append("\t$(TTCN3_DIR)/bin/compiler -B -s $(COMPILER_FLAGS) ");
                if (this.gnuMake) {
                    contents.append("$^");
                } else {
                    contents.append("\\\n");
                    contents.append("\t$(TTCN3_MODULES) ");
                    if (this.preprocess) {
                        contents.append("$(PREPROCESSED_TTCN3_MODULES) ");
                    }
                    contents.append("$(ASN1_MODULES)");
                }
                contents.append("\n\n");
            }
            contents.append("clean:\n");
            contents.append("\t-").append(rmCommand).append(" $(EXECUTABLE) $(LIBRARY) $(OBJECTS)\n");
            contents.append("\t-").append(rmCommand).append(" $(GENERATED_HEADERS)\n");
            contents.append("\t-").append(rmCommand).append(" $(GENERATED_SOURCES)\n");
            if (this.dynamicLinking) {
                contents.append("\t-").append(rmCommand).append(" $(SHARED_OBJECTS)\n");
            }
            if (this.preprocess) {
                contents.append("\t-").append(rmCommand).append(" $(PREPROCESSED_TTCN3_MODULES)\n");
            }
            contents.append("\t-").append(rmCommand).append(" compile");
            if (this.centralStorage) {
                contents.append(" compile-all");
            }
            if (this.incrementalDependencyRefresh) {
                contents.append(" $(DEPFILES)");
            }
            contents.append("\n");
            contents.append("\t-").append(rmCommand).append(" browserdata.dat tags *.log");
            contents.append("\n\n");
            contents.append("dep: $(GENERATED_SOURCES) $(USER_SOURCES)");
            if (this.incrementalDependencyRefresh) {
                contents.append(" $(DEPFILES) ;\n\n");
                contents.append("ifeq ($(filter clean check port compile archive,$(MAKECMDGOALS)),)\n");
                if (this.preprocess) {
                    contents.append("ifeq ($(findstring preprocess,$(MAKECMDGOALS)),)\n");
                }
                contents.append("-include $(DEPFILES)\n");
                if (this.preprocess) {
                    contents.append("endif\n");
                }
                contents.append("endif\n\n");
            } else {
                contents.append("\n\tmakedepend $(CPPFLAGS) -DMAKEDEPEND_RUN ");
                if (this.gnuMake) {
                    contents.append("$^");
                } else {
                    contents.append("$(GENERATED_SOURCES) $(USER_SOURCES)");
                }
            }
            contents.append("\n\n");
            contents.append("archive:\n");
            contents.append("\tmkdir -p $(ARCHIVE_DIR)\n");
            contents.append("\ttar -cvhf - ");
            if (this.centralStorage) {
                contents.append("$(TTCN3_MODULES) $(BASE_TTCN3_MODULES) \\\n");
                if (this.preprocess) {
                    contents.append("\t$(TTCN3_PP_MODULES) $(BASE_TTCN3_PP_MODULES) ");
                    contents.append("$(TTCN3_INCLUDES)\\\n");
                }
                contents.append("\t$(ASN1_MODULES) $(BASE_ASN1_MODULES) \\\n");
                contents.append("\t$(USER_HEADERS) $(BASE_USER_HEADERS) \\\n");
                contents.append("\t$(USER_SOURCES) $(BASE_USER_SOURCES)");
            } else {
                contents.append("$(TTCN3_MODULES) ");
                if (this.preprocess) {
                    contents.append("$(TTCN3_PP_MODULES) \\\n");
                    contents.append("\t$(TTCN3_INCLUDES) ");
                }
                contents.append("$(ASN1_MODULES) \\\n");
                contents.append("\t$(USER_HEADERS) $(USER_SOURCES)");
            }
            contents.append(" $(OTHER_FILES) \\\n");
            contents.append("\t| gzip >$(ARCHIVE_DIR)/`basename $(TARGET) .exe`-");
            contents.append("`date '+%y%m%d-%H%M'`.tgz\n\n");
            contents.append("diag:\n");
            contents.append("\t$(TTCN3_DIR)/bin/compiler -v 2>&1\n");
            contents.append("\t$(TTCN3_DIR)/bin/mctr_cli -v 2>&1\n");
            contents.append("\t$(CXX) -v 2>&1\n");
            if (!this.dynamicLinking) {
                contents.append("\t$(AR) -V 2>&1\n");
            }
            contents.append("\t@echo TTCN3_DIR=$(TTCN3_DIR)\n");
            contents.append("\t@echo OPENSSL_DIR=$(OPENSSL_DIR)\n");
            contents.append("\t@echo XMLDIR=$(XMLDIR)\n");
            contents.append("\t@echo PLATFORM=$(PLATFORM)\n\n");
            contents.append("#\n");
            contents.append("# Add your rules here if necessary...\n");
            contents.append("#\n\n");
            String makefileName = "Makefile";
            try {
                if (this.project.getLocation().isPrefixOf(this.workingDirectoryPath)) {
                    IFile sampleMakefile;
                    int matchingSegments = this.project.getLocation().matchingFirstSegments(this.workingDirectoryPath);
                    IPath samplePath = this.workingDirectoryPath.removeFirstSegments(matchingSegments);
                    IFolder folder = this.project.getFolder(samplePath);
                    if (!folder.isAccessible()) {
                        ResourceUtils.refreshResources(Arrays.asList(folder));
                    }
                    if (InternalMakefileGenerator.needsUpdate(sampleMakefile = this.project.getFile(samplePath.append("/Makefile")), contents.toString())) {
                        sampleMakefile.refreshLocal(0, null);
                        if (sampleMakefile.exists()) {
                            sampleMakefile.setContents((InputStream)new ByteArrayInputStream(contents.toString().getBytes()), 3, null);
                        } else {
                            sampleMakefile.create((InputStream)new ByteArrayInputStream(contents.toString().getBytes()), 1, null);
                        }
                        ResourceUtils.refreshResources(Arrays.asList(sampleMakefile));
                        sampleMakefile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    }
                    break block326;
                }
                IPath makefilepath = this.workingDirectoryPath.append("Makefile");
                BufferedOutputStream out = null;
                try {
                    out = new BufferedOutputStream(new FileOutputStream(makefilepath.toOSString()));
                    out.write(contents.toString().getBytes());
                    IOUtils.closeQuietly((Closeable)out);
                }
                catch (FileNotFoundException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                }
                catch (IOException e2) {
                    ErrorReporter.logExceptionStackTrace((Exception)e2);
                    break block326;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    IOUtils.closeQuietly(out);
                }
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
    }

    private static boolean needsUpdate(IFile file, String content) throws CoreException {
        if (!file.isAccessible()) {
            return true;
        }
        boolean result = true;
        InputStream filestream = file.getContents();
        BufferedInputStream bufferedFile = new BufferedInputStream(filestream);
        ByteArrayInputStream contentStream = new ByteArrayInputStream(content.getBytes());
        BufferedInputStream bufferedOutput = new BufferedInputStream(contentStream);
        try {
            int read1 = bufferedFile.read();
            int read2 = bufferedOutput.read();
            while (read1 != -1 && read1 == read2) {
                read1 = bufferedFile.read();
                read2 = bufferedOutput.read();
            }
            result = read1 != read2;
            bufferedFile.close();
            bufferedOutput.close();
        }
        catch (IOException exception) {
            return true;
        }
        return result;
    }

    public void gatherInformation() {
        this.centralStorage = false;
        try {
            MakefileGeneratorVisitor visitor = new MakefileGeneratorVisitor(this, this.project);
            this.project.accept((IResourceVisitor)visitor);
            this.centralStorage = !visitor.getCentralStorages().isEmpty();
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return;
        }
        List<IProject> tempReachableProjects = ProjectBasedBuilder.getProjectBasedBuilder(this.project).getAllReachableProjects();
        this.reachableProjects = new ArrayList<IProject>(tempReachableProjects.size());
        boolean foundClosedProject = false;
        for (IProject reachableProject : tempReachableProjects) {
            if (reachableProject.isAccessible()) {
                this.reachableProjects.add(reachableProject);
                continue;
            }
            StringBuilder builder = new StringBuilder("The project `" + reachableProject.getName() + "' (reachable from project `" + this.project.getName() + "') is not accessible.");
            IProject[] referencingProjects = reachableProject.getReferencingProjects();
            if (referencingProjects != null && referencingProjects.length > 0) {
                builder.append(" The project `").append(reachableProject.getName()).append("' is referenced directly by");
                for (IProject referencingProject : referencingProjects) {
                    builder.append(" `").append(referencingProject.getName()).append('\'');
                }
            }
            ErrorReporter.logError((String)builder.toString());
            foundClosedProject = true;
        }
        for (IProject reachableProject : this.reachableProjects) {
            if (reachableProject.equals(this.project)) continue;
            this.centralStorage = true;
            try {
                reachableProject.accept((IResourceVisitor)new MakefileGeneratorVisitor(this, reachableProject));
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                return;
            }
        }
        if (foundClosedProject) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Error during Makefile generation", (String)("A makefile can not be generated for project " + this.project.getName() + "\nSome of the projects referenced by it are not accessible.\nPlease check the error log for more details."));
            return;
        }
        try {
            this.codeSplittingMode = this.project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "codeSplitting"));
            if (this.codeSplittingMode == null || "none".equals(this.codeSplittingMode)) {
                this.codeSplittingMode = "none";
            } else if (!"type".equals(this.codeSplittingMode)) {
                try {
                    Integer.parseInt(this.codeSplittingMode);
                }
                catch (NumberFormatException ex) {
                    ErrorReporter.logExceptionStackTrace((Exception)ex);
                    this.codeSplittingMode = "none";
                }
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return;
        }
        OtherFileStruct otherFile = new OtherFileStruct(null, null, "Makefile");
        this.otherFiles.add(otherFile);
    }

    private StringBuilder appendExecutableTarget(StringBuilder contents, String allObjects, boolean externalLibrariesDisabled) {
        StringBuilder output;
        String tempProjectLocation;
        IPath location;
        String[] optionList;
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        List<IProject> referencedProjects = ProjectBasedBuilder.getProjectBasedBuilder(this.project).getAllReachableProjects();
        if (this.dynamicLinking && this.library) {
            contents.append("$(EXECUTABLE): $(LIBRARY)\n");
            contents.append("\t$(CXX) $(LDFLAGS) -o $@ $(LIBRARY)");
        } else {
            contents.append("$(EXECUTABLE): " + allObjects).append('\n');
            contents.append("\t$(CXX) $(LDFLAGS) -o $@ ");
            if (this.dynamicLinking && !"solaris".equals(Platform.getOS())) {
                contents.append("-Wl,--no-as-needed ");
            }
            contents.append(this.gnuMake ? "$^" : allObjects);
            for (IProject referencedProject : referencedProjects) {
                optionList = LinkerLibrariesOptionsData.getAdditionalObjects(referencedProject);
                if (optionList.length <= 0) continue;
                location = referencedProject.getLocation();
                if (location == null) {
                    ErrorReporter.logError((String)("The project `" + referencedProject.getName() + "' is not located in the local file system. The additional object files to link against, set for it will not be generated into the Makefile"));
                    continue;
                }
                tempProjectLocation = location.toOSString();
                for (String option : optionList) {
                    output = new StringBuilder();
                    option = TITANPathUtilities.resolvePathURIForMakefile((String)option, (String)tempProjectLocation, (boolean)reportDebugInformation, (StringBuilder)output);
                    contents.append(' ').append(option);
                    TITANDebugConsole.println(output);
                }
            }
        }
        contents.append(" \\\n");
        contents.append("\t-L$(TTCN3_");
        contents.append("DIR)/lib");
        if (!externalLibrariesDisabled) {
            contents.append(" -L$(OPENSSL_DIR)/lib -L$(XMLDIR)/lib");
        }
        for (IProject referencedProject : referencedProjects) {
            if (!referencedProject.isAccessible() || (optionList = LinkerLibrariesOptionsData.getLinkerSearchPaths(referencedProject)).length <= 0) continue;
            location = referencedProject.getLocation();
            if (location == null) {
                ErrorReporter.logError((String)("The project `" + referencedProject.getName() + "' is not located in the local file system. The extra linker search paths set for it will not be generated into the Makefile"));
                continue;
            }
            tempProjectLocation = location.toOSString();
            for (String temp : optionList) {
                output = new StringBuilder();
                temp = TITANPathUtilities.resolvePathURIForMakefile((String)temp, (String)tempProjectLocation, (boolean)reportDebugInformation, (StringBuilder)output);
                contents.append(" -L").append(temp);
                TITANDebugConsole.println(output);
            }
        }
        contents.append(" \\\n");
        contents.append("\t-l$(TTCN3_LIB)");
        contents.append(" -lcrypto");
        if (!referencedProjects.isEmpty()) {
            for (IProject tempProject : referencedProjects) {
                for (String anOptionList : optionList = LinkerLibrariesOptionsData.getLinkerLibraries(tempProject)) {
                    contents.append(" -l").append(anOptionList);
                }
            }
        }
        contents.append(" \\\n");
        contents.append("\t$($(PLATFORM)_LIBS) \\\n");
        contents.append("\t|| if [ -f $(TTCN3_DIR)/bin/titanver ]; then $(TTCN3_DIR)/bin/titanver ");
        contents.append(this.gnuMake ? "$^" : allObjects).append("; else : ; fi\n");
        if (this.asn1modules.isEmpty() && this.ttcn3Modules.isEmpty() && this.ttcnppModules.isEmpty()) {
            contents.append("\ttouch compile\n");
        }
        return contents.append('\n');
    }

    private String getLibraryName() {
        if (this.etsName == null || this.etsName.length() == 0) {
            return "";
        }
        String prefix = this.etsName.endsWith(".exe") ? this.etsName.substring(0, this.etsName.length() - ".exe".length()) : this.etsName;
        return prefix + (this.dynamicLinking ? "_lib.so" : ".a");
    }

    private void setParameters() throws CoreException {
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        this.workingDirectoryPath = ProjectBasedBuilder.getProjectBasedBuilder(this.project).getWorkingDirectoryPath(true);
        this.workingDirectory = this.workingDirectoryPath.toOSString();
        if (reportDebugInformation) {
            TITANDebugConsole.println(this.workingDirectory);
        }
        String productNumber = CompilerVersionInformationCollector.getCompilerProductNumber();
        this.compilerProductNumber = ProductIdentityHelper.getProductIdentity(productNumber, null);
        this.gnuMake = ResourceUtils.getBooleanPersistentProperty((IResource)this.project, (String)"org.eclipse.titan.designer.Properties.Project", (String)"GNUMake");
        if (ResourceUtils.getBooleanPersistentProperty((IResource)this.project, (String)"org.eclipse.titan.designer.Properties.Project", (String)"IncrementalDependency")) {
            this.incrementalDependencyRefresh = true;
            if (!this.gnuMake) {
                TITANConsole.println(INVALID_OPTIONS);
                ErrorReporter.logError((String)"Incremental dependency refresh is only supported if generating GNU makefiles. The GNU make option was turned on.");
                ResourceUtils.setPersistentProperty((IResource)this.project, (String)"org.eclipse.titan.designer.Properties.Project", (String)"GNUMake", (boolean)true);
            }
        }
        if (ResourceUtils.getBooleanPersistentProperty((IResource)this.project, (String)"org.eclipse.titan.designer.Properties.Project", (String)"DynamicLinkingProperty")) {
            if (!"win32".equals(Platform.getOS())) {
                this.dynamicLinking = true;
            } else {
                TITANConsole.println(INVALID_OPTIONS);
                ErrorReporter.logError((String)("Could not create Makefile with dynamic linking enabled for project " + this.project.getName() + " as this is not supported on Windows"));
            }
        }
        this.singleMode = ResourceUtils.getBooleanPersistentProperty((IResource)this.project, (String)"org.eclipse.titan.designer.Properties.Project", (String)"singleMode");
        this.useAbsolutePathNames = ResourceUtils.getBooleanPersistentProperty((IResource)this.project, (String)"org.eclipse.titan.designer.Properties.Project", (String)"useAbsolutePath");
        this.useRuntime2 = ResourceUtils.getBooleanPersistentProperty((IResource)this.project, (String)"org.eclipse.titan.designer.Properties.Project", (String)"Function test runtime");
        this.library = MakefileCreationData.DefaultTarget.LIBRARY.toString().equals(this.project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "defaultTarget")));
        this.allProjectsUseSymbolicLinks = this.usingSymbolicLinks = ProjectBuildPropertyData.useSymbolicLinks(this.project);
        String temp = ResourceUtils.getPersistentProperty((IResource)this.project, (String)"org.eclipse.titan.designer.Properties.Project", (String)"targetExecutable");
        if (temp != null && temp.trim().length() > 0) {
            StringBuilder output = new StringBuilder();
            this.etsName = TITANPathUtilities.resolvePathURIForMakefile((String)temp, (String)this.projectLocation, (boolean)reportDebugInformation, (StringBuilder)output);
            TITANDebugConsole.println(output);
        } else {
            temp = this.project.getName();
            this.etsName = "win32".equals(Platform.getOS()) ? temp + ".exe" : temp;
        }
    }

    public void addTTCN3Module(IFile file, String directory) {
        ModuleStruct module;
        ProjectSourceParser parser = GlobalParser.getProjectSourceParser(file.getProject());
        String moduleName = parser.containedModuleName(file);
        if (moduleName == null) {
            if (file.isSynchronized(0)) {
                ErrorReporter.logWarning((String)("file " + file.getFullPath().toOSString() + " is out-of sync with the file system"));
            } else {
                ErrorReporter.logWarning((String)("file " + file.getFullPath().toOSString() + " even tough it has ttcn extension is added as on other file since the on-the-fly analyzer was not able to find a valid module inside"));
            }
            this.addOtherFiles(file, directory);
            return;
        }
        Identifier identifier = new Identifier(Identifier.Identifier_type.ID_NAME, moduleName);
        IPath fileLocation = file.getLocation();
        if (fileLocation == null) {
            String originalLocation = directory + File.separatorChar + file.getName();
            module = new ModuleStruct(directory, originalLocation, file.getName(), identifier.getTtcnName());
        } else {
            String originalLocation = fileLocation.toOSString();
            module = new ModuleStruct(directory, originalLocation, fileLocation.lastSegment(), identifier.getTtcnName());
        }
        module.setRegular(fileLocation != null && "ttcn".equals(file.getFileExtension()) && file.getName().equals(moduleName + ".ttcn"));
        this.ttcn3Modules.add(module);
    }

    public void addASN1Module(IFile file, String directory) {
        ProjectSourceParser parser = GlobalParser.getProjectSourceParser(file.getProject());
        String moduleName = parser.containedModuleName(file);
        if (moduleName == null) {
            if (file.isSynchronized(0)) {
                ErrorReporter.logWarning((String)("file " + file.getFullPath().toOSString() + " is out-of sync with the file system"));
            } else {
                ErrorReporter.logWarning((String)("file " + file.getFullPath().toOSString() + " even tough it has asn extension is added as on other file since the on-the-fly analyzer was not able to find a valid module inside"));
            }
            this.addOtherFiles(file, directory);
            return;
        }
        IPath location = file.getLocation();
        String originalLocation = location == null ? directory + File.separatorChar + file.getName() : location.toOSString();
        Identifier identifier = new Identifier(Identifier.Identifier_type.ID_NAME, moduleName);
        ModuleStruct module = new ModuleStruct(directory, originalLocation, file.getName(), identifier.getAsnName());
        String prefix = file.getName();
        prefix = prefix.replace('_', '-');
        module.setRegular(location != null && "asn".equals(file.getFileExtension()) && prefix.equals(moduleName + ".asn"));
        this.asn1modules.add(module);
    }

    public void addUserHeaderFile(IFile file, String directory) {
        String name = file.getName();
        String filePrefix = name.substring(0, name.lastIndexOf(46));
        for (UserStruct other : this.userFiles) {
            if (other.getDirectory() == null || other.getFilePrefix() == null || !other.getDirectory().equals(directory) || !other.getFilePrefix().equals(filePrefix)) continue;
            other.setHeaderName(name);
            if (file.getLocation() == null) {
                other.setOriginalHeaderLocation(directory + File.separatorChar + file.getName());
            } else {
                other.setOriginalHeaderLocation(file.getLocation().toOSString());
            }
            other.setHasHHSuffix("hh".equals(file.getFileExtension()));
            return;
        }
        UserStruct userFile = new UserStruct();
        userFile.setDirectory(directory);
        if (file.getLocation() == null) {
            userFile.setOriginalHeaderLocation(directory + File.separatorChar + file.getName());
        } else {
            userFile.setOriginalHeaderLocation(file.getLocation().toOSString());
        }
        userFile.setFileName(name);
        userFile.setFilePrefix(name.substring(0, name.lastIndexOf(46)));
        userFile.setHeaderName(file.getName());
        userFile.setHasHHSuffix("hh".equals(file.getFileExtension()));
        userFile.setSourceName(null);
        userFile.setHasCCSuffix(false);
        this.userFiles.add(userFile);
        this.addAdditionallyIncludedDirectory(file.getLocation().removeLastSegments(1));
    }

    public void addUserSourceFile(IFile file, String directory) {
        String name = file.getName();
        String filePrefix = name.substring(0, name.lastIndexOf(46));
        for (UserStruct other : this.userFiles) {
            if (other.getDirectory() == null || other.getFilePrefix() == null || !other.getDirectory().equals(directory) || !other.getFilePrefix().equals(filePrefix)) continue;
            other.setSourceName(name);
            if (file.getLocation() == null) {
                other.setOriginalSourceLocation(directory + File.separatorChar + file.getName());
            } else {
                other.setOriginalSourceLocation(file.getLocation().toOSString());
            }
            other.setHasCCSuffix("cc".equals(file.getFileExtension()));
            return;
        }
        UserStruct userFile = new UserStruct();
        userFile.setDirectory(directory);
        if (file.getLocation() == null) {
            userFile.setOriginalSourceLocation(directory + File.separatorChar + file.getName());
        } else {
            userFile.setOriginalSourceLocation(file.getLocation().toOSString());
        }
        userFile.setFileName(name);
        userFile.setFilePrefix(name.substring(0, name.lastIndexOf(46)));
        userFile.setHeaderName(null);
        userFile.setHasHHSuffix(false);
        userFile.setSourceName(file.getName());
        userFile.setHasCCSuffix("cc".equals(file.getFileExtension()));
        this.userFiles.add(userFile);
        this.addAdditionallyIncludedDirectory(file.getLocation().removeLastSegments(1));
    }

    public void addOtherFiles(IFile file, String directory) {
        String originalLocation = file.getLocation() == null ? directory + File.separatorChar + file.getName() : file.getLocation().toOSString();
        if ("null".equals(originalLocation)) {
            originalLocation = null;
        }
        OtherFileStruct otherFile = new OtherFileStruct(directory, originalLocation, file.getName());
        this.otherFiles.add(otherFile);
    }

    public void addPreprocessingModule(IFile file, String directory) {
        this.preprocess = true;
        String name = file.getName();
        String originalLocation = file.getLocation() == null ? directory + File.separatorChar + file.getName() : file.getLocation().toOSString();
        ModuleStruct module = new ModuleStruct(directory, originalLocation, name, name.substring(0, name.lastIndexOf(46)));
        module.setRegular(false);
        this.ttcnppModules.add(module);
    }

    public void addIncludeModule(IFile file, String directory) {
        this.preprocess = true;
        String originalLocation = file.getLocation() == null ? directory + File.separatorChar + file.getName() : file.getLocation().toOSString();
        if ("null".equals(originalLocation)) {
            originalLocation = null;
        }
        IProject project = file.getProject();
        IPath parentPath = file.getLocation().removeLastSegments(1);
        TTCN3IncludeFileStruct includeFile = null;
        if (this.usingSymbolicLinks) {
            IPath workingDirectoryPath = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryPath(true);
            String workspaceFilePath = workingDirectoryPath.toOSString() + File.separatorChar + file.getName();
            includeFile = new TTCN3IncludeFileStruct(parentPath.toOSString(), workingDirectoryPath.toOSString(), originalLocation, workspaceFilePath, file.getName());
            this.addAdditionallyIncludedDirectory(workingDirectoryPath);
        } else {
            includeFile = new TTCN3IncludeFileStruct(parentPath.toOSString(), null, originalLocation, null, file.getName());
            this.addAdditionallyIncludedDirectory(parentPath);
        }
        this.ttcn3IncludeFiles.add(includeFile);
    }

    public void addAdditionallyIncludedDirectory(IPath folder) {
        if (folder == null) {
            return;
        }
        String name = folder.toOSString();
        for (BaseDirectoryStruct dir : this.additionallyIncludedFolders) {
            if (!dir.getDirectoryName().equals(name)) continue;
            if (dir.getDirectory() == null) {
                dir.setDirectory(folder);
            }
            return;
        }
        BaseDirectoryStruct dir = new BaseDirectoryStruct(folder, name, true);
        this.additionallyIncludedFolders.add(dir);
    }

    public void addBaseDirectory(IPath folder) {
        if (folder == null) {
            return;
        }
        String name = folder.toOSString();
        for (BaseDirectoryStruct dir : this.baseDirectories) {
            if (!dir.getDirectoryName().equals(name)) continue;
            if (dir.getDirectory() == null) {
                dir.setDirectory(folder);
            }
            return;
        }
        BaseDirectoryStruct dir = new BaseDirectoryStruct(folder, name, true);
        this.baseDirectories.add(dir);
    }

    public void addBaseDirectory(String folder) {
        for (BaseDirectoryStruct dir : this.baseDirectories) {
            if (!dir.getDirectoryName().equals(folder)) continue;
            return;
        }
        BaseDirectoryStruct dir = new BaseDirectoryStruct(null, folder, true);
        this.baseDirectories.add(dir);
    }

    public List<BaseDirectoryStruct> getBaseDirectories() {
        return this.baseDirectories;
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean isAllProjectsUseSymbolicLinks() {
        return this.allProjectsUseSymbolicLinks;
    }

    public void setAllProjectsUseSymbolicLinks(boolean allProjectsUseSymbolicLinks) {
        this.allProjectsUseSymbolicLinks = allProjectsUseSymbolicLinks;
    }

    public String getProjectLocation() {
        return this.projectLocation;
    }

    public List<ModuleStruct> getTtcn3Modules() {
        return this.ttcn3Modules;
    }

    public List<ModuleStruct> getTtcnppModules() {
        return this.ttcnppModules;
    }

    public List<TTCN3IncludeFileStruct> getTtcn3IncludeFiles() {
        return this.ttcn3IncludeFiles;
    }

    public List<ModuleStruct> getAsn1modules() {
        return this.asn1modules;
    }

    public List<UserStruct> getUserFiles() {
        return this.userFiles;
    }

    public List<OtherFileStruct> getOtherFiles() {
        return this.otherFiles;
    }

    public List<BaseDirectoryStruct> getAdditionallyIncludedFolders() {
        return this.additionallyIncludedFolders;
    }

    public List<IProject> getReachableProjects() {
        return this.reachableProjects;
    }
}

