/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.brokenpartsanalyzers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.BrokenPartsViaReferences;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.SelectionMethodBase;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.LoadBalancingUtilities;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public final class BrokenPartsChecker {
    private final SubMonitor progress;
    private final IProgressMonitor monitor;
    private final CompilationTimeStamp compilationCounter;
    private final SelectionMethodBase selectionMethod;

    public BrokenPartsChecker(SubMonitor monitor, CompilationTimeStamp compilationCounter, SelectionMethodBase selectionMethod) {
        this.compilationCounter = compilationCounter;
        this.selectionMethod = selectionMethod;
        this.monitor = monitor;
        this.progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
    }

    public void doChecking() {
        this.monitor.subTask("Semantic checking");
        BrokenPartsViaReferences brokenParts = (BrokenPartsViaReferences)this.selectionMethod;
        if (brokenParts.getAnalyzeOnlyDefinitions()) {
            Map<Module, List<Assignment>> moduleAndBrokenDefinitions = brokenParts.getModuleAndBrokenDefs();
            this.definitionsChecker(moduleAndBrokenDefinitions);
        } else {
            this.generalChecker();
        }
        this.monitor.subTask("Doing post semantic checks");
        for (Module module : this.selectionMethod.getModulesToCheck()) {
            module.postCheck();
        }
        ArrayList<IFile> filesToCheck = new ArrayList<IFile>();
        for (Module moduleToCheck : this.selectionMethod.getModulesToCheck()) {
            filesToCheck.add((IFile)moduleToCheck.getLocation().getFile());
        }
        for (IEditorPart editorPart : TTCN3Editor.getActiveEditorParts()) {
            IFile editorFile;
            TTCN3Editor editor;
            IEditorInput editorInput;
            if (editorPart == null || !(editorPart instanceof TTCN3Editor) || !((editorInput = (editor = (TTCN3Editor)editorPart).getEditorInput()) instanceof FileEditorInput) || !filesToCheck.contains(editorFile = ((FileEditorInput)editorInput).getFile())) continue;
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                ISourceViewer viewer = editor.getEditorSourceViewer();
                if (viewer != null) {
                    viewer.invalidateTextPresentation();
                }
            });
        }
        this.progress.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generalChecker() {
        List<Module> importedModules;
        List<Module> modulesToCheck = this.selectionMethod.getModulesToCheck();
        if (modulesToCheck.isEmpty()) {
            return;
        }
        this.progress.setTaskName("Semantic check");
        this.progress.setWorkRemaining(modulesToCheck.size());
        for (Module module : this.selectionMethod.getModulesToSkip()) {
            module.setSkippedFromSemanticChecking(true);
        }
        for (Module module : modulesToCheck) {
            module.setSkippedFromSemanticChecking(false);
        }
        long absoluteStart = System.nanoTime();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        IPreferencesService prefs = Platform.getPreferencesService();
        int processingUnitsToUse = prefs.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.processingUnitsToUse", availableProcessors, null);
        boolean limitAllThreadCreation = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.limitAllThreadCreation", false, null);
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setPriority(LoadBalancingUtilities.getThreadPriority());
                return t;
            }
        };
        ExecutorService executor = limitAllThreadCreation ? Executors.newFixedThreadPool(processingUnitsToUse, threadFactory) : Executors.newCachedThreadPool(threadFactory);
        AtomicInteger activeExecutorCount = new AtomicInteger(0);
        ArrayList<Module> modulesToCheckCopy = new ArrayList<Module>(modulesToCheck);
        Collections.sort(modulesToCheckCopy, new Comparator<Module>(){

            @Override
            public int compare(Module o1, Module o2) {
                return o2.getAssignments().getNofAssignments() - o1.getAssignments().getNofAssignments();
            }
        });
        ArrayList<Module> modulesToCheckParallely = new ArrayList<Module>();
        for (Module module : modulesToCheckCopy) {
            importedModules = module.getImportedModules();
            boolean ok = true;
            for (Module importedModule : importedModules) {
                if (importedModule.getSkippedFromSemanticChecking() || importedModule.getLastCompilationTimeStamp() != null && importedModule.getLastCompilationTimeStamp() == this.compilationCounter) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            modulesToCheckParallely.add(module);
        }
        CountDownLatch latch = new CountDownLatch(modulesToCheck.size());
        if (modulesToCheckParallely.isEmpty()) {
            modulesToCheckParallely.add((Module)modulesToCheckCopy.remove(0));
        } else {
            modulesToCheckCopy.removeAll(modulesToCheckParallely);
        }
        LinkedBlockingDeque<Module> modulesBeingChecked = new LinkedBlockingDeque<Module>(modulesToCheckParallely);
        importedModules = modulesToCheckCopy;
        synchronized (importedModules) {
            for (Module module : modulesToCheckParallely) {
                BrokenPartsChecker.addToExecutor(module, executor, latch, this.compilationCounter, absoluteStart, modulesToCheckCopy, modulesBeingChecked, activeExecutorCount, this.progress);
            }
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        TITANDebugConsole.println("  **It took " + (double)(System.nanoTime() - absoluteStart) * 1.0E-9 + " seconds so far for Designer to check the modules in parallel mode");
        executor.shutdown();
        try {
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor.shutdownNow();
        for (Module module : this.selectionMethod.getModulesToSkip()) {
            module.setSkippedFromSemanticChecking(false);
        }
    }

    private static void addToExecutor(final Module module, final ExecutorService executor, final CountDownLatch latch, final CompilationTimeStamp compilationCounter, final long absoluteStart, final List<Module> modulesToCheckCopy, final LinkedBlockingDeque<Module> modulesBeingChecked, final AtomicInteger activeExecutorCount, final SubMonitor progress) {
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (progress.isCanceled()) {
                    latch.countDown();
                    throw new OperationCanceledException();
                }
                try {
                    activeExecutorCount.incrementAndGet();
                    long absoluteStart2 = System.nanoTime();
                    module.check(compilationCounter);
                    long now = System.nanoTime();
                    TITANDebugConsole.println("  **It took (" + (absoluteStart2 - absoluteStart) + "," + (now - absoluteStart) + ") " + (double)(now - absoluteStart2) * 1.0E-9 + " seconds for Designer to check " + module.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    modulesBeingChecked.remove(module);
                    progress.worked(1);
                    latch.countDown();
                    ArrayList<Module> modulesToCheckParallely = new ArrayList<Module>();
                    List list = modulesToCheckCopy;
                    synchronized (list) {
                        for (Module module22 : modulesToCheckCopy) {
                            List<Module> importedModules = module22.getImportedModules();
                            boolean ok = true;
                            for (Module importedModule : importedModules) {
                                if (!modulesBeingChecked.contains(importedModule) && (importedModule.getSkippedFromSemanticChecking() || importedModule.getLastCompilationTimeStamp() != null && importedModule.getLastCompilationTimeStamp() == compilationCounter)) continue;
                                ok = false;
                                break;
                            }
                            if (!ok) continue;
                            modulesToCheckParallely.add(module22);
                        }
                        int remainingExecutors = activeExecutorCount.decrementAndGet();
                        if (modulesToCheckParallely.isEmpty()) {
                            if (remainingExecutors == 0 && modulesBeingChecked.isEmpty() && !modulesToCheckCopy.isEmpty()) {
                                Module module22;
                                module22 = (Module)modulesToCheckCopy.remove(0);
                                modulesToCheckCopy.remove(module22);
                                modulesBeingChecked.add(module22);
                                BrokenPartsChecker.addToExecutor(module22, executor, latch, compilationCounter, absoluteStart, modulesToCheckCopy, modulesBeingChecked, activeExecutorCount, progress);
                            }
                            return;
                        }
                        modulesToCheckCopy.removeAll(modulesToCheckParallely);
                        modulesBeingChecked.addAll(modulesToCheckParallely);
                        for (Module module3 : modulesToCheckParallely) {
                            BrokenPartsChecker.addToExecutor(module3, executor, latch, compilationCounter, absoluteStart, modulesToCheckCopy, modulesBeingChecked, activeExecutorCount, progress);
                        }
                    }
                }
            }
        });
    }

    private void definitionsChecker(Map<Module, List<Assignment>> moduleAndBrokenDefs) {
        this.progress.setTaskName("Semantic check");
        this.progress.setWorkRemaining(moduleAndBrokenDefs.size());
        for (Map.Entry<Module, List<Assignment>> entry : moduleAndBrokenDefs.entrySet()) {
            Module module = entry.getKey();
            this.progress.subTask("Semantically checking broken parts in module: " + module.getName());
            if (module instanceof TTCN3Module) {
                ((TTCN3Module)module).checkWithDefinitions(this.compilationCounter, entry.getValue());
            } else {
                module.check(this.compilationCounter);
            }
            this.progress.worked(1);
        }
    }
}

