/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceableElement;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.JsonAST;
import org.eclipse.titan.designer.AST.TTCN3.attributes.RawAST;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.IndexedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Indexed_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.PermutationMatch_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SubsetMatch_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SupersetMatch_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.AbstractOfType;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.RecordOfGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.SetOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeFactory;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SetOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class SequenceOf_Type
extends AbstractOfType
implements IReferenceableElement {
    public static final String SEQOFVALUEEXPECTED = "SEQUENCE OF value was expected";
    public static final String RECORDOFVALUEEXPECTED = "record of value was expected";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for recordof type `{1}''";
    private static final String REDUNDANTLENGTHRESTRICTION = "Redundant usage of length restriction with `omit''";
    public static final String NOTUSEDNOTALLOWED1 = "Not used symbol `-' is not allowed in this context";
    public static final String NOTUSEDNOTALLOWED2 = "Not used symbol `-' cannot be used here because there is no corresponding element in the base template";
    public static final String TOOBIGINDEXTEMPLATE = "An integer value less than `{0}'' was expected for indexing type `{1}'' instead of `{2}''";
    public static final String NONNEGATIVEINDEXEXPECTEDTEMPLATE = "A non-negative integer value was expected for indexing type `{0}'' instead of `{1}''";
    public static final String DUPLICATEINDEX = "Duplicate index value `{0}'' for component `{1}'' and `{2}''";
    public static final String NONNEGATIVINDEXEXPECTED = "A non-negative integer value was expected as index instead of `{0}''";
    public static final String TOOBIGINDEX = "Integer value `{0}'' is too big for indexing type `{1}''";
    public static final String INTEGERINDEXEXPECTED = "The index should be an integer value";
    private static final String INDEXOVERFLOW = "Index oveflow: the index value must be at most {0} instead of {1}";
    private static final String NOTCOMPATIBLESETSETOF = "set/SET and set of/SET OF types are compatible only with other set/SET and set of/SET OF types";
    private static final String NOTCOMPATIBLEUNIONANYTYPE = "union/CHOICE/anytype types are compatible only with other union/CHOICE/anytype types";

    public SequenceOf_Type(IType ofType) {
        super(ofType);
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_SEQUENCE_OF;
    }

    @Override
    public IASN1Type newInstance() {
        if (this.getOfType() instanceof ASN1Type) {
            return new SequenceOf_Type(((IASN1Type)this.getOfType()).newInstance());
        }
        return this;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType lastOtherType = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || lastOtherType.getIsErroneous(timestamp) || this == lastOtherType) {
            return true;
        }
        if (info == null || noStructuredTypeCompatibility) {
            IType last = this.getTypeRefdLast(timestamp);
            return last.isStronglyCompatible(timestamp, lastOtherType, info, leftChain, rightChain);
        }
        switch (lastOtherType.getTypetype()) {
            case TYPE_ASN1_SEQUENCE: {
                if (!this.isSubtypeCompatible(timestamp, lastOtherType)) {
                    info.setErrorStr("Incompatible record of/SEQUENCE OF subtypes");
                    return false;
                }
                ASN1_Sequence_Type tempType = (ASN1_Sequence_Type)lastOtherType;
                int tempTypeNofComps = tempType.getNofComponents();
                if (tempTypeNofComps == 0) {
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < tempTypeNofComps; ++i) {
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    IType tempTypeCfType = tempTypeCf.getType().getTypeRefdLast(timestamp);
                    IType ofType = this.getOfType().getTypeRefdLast(timestamp);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(ofType, tempTypeCfType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(ofType);
                    rChain.add(tempTypeCfType);
                    if (!(ofType.equals(tempTypeCfType) || lChain.hasRecursion() && rChain.hasRecursion() || ofType.isCompatible(timestamp, tempTypeCfType, infoTemp, lChain, rChain))) {
                        if (infoTemp.getOp1RefStr().length() > 0) {
                            info.appendOp1Ref("[]");
                        }
                        info.appendOp1Ref(infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCf.getIdentifier().getDisplayName() + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_TTCN3_SEQUENCE: {
                if (!this.isSubtypeCompatible(timestamp, lastOtherType)) {
                    info.setErrorStr("Incompatible record of/SEQUENCE OF subtypes");
                    return false;
                }
                TTCN3_Sequence_Type tempType = (TTCN3_Sequence_Type)lastOtherType;
                int tempTypeNofComps = tempType.getNofComponents();
                if (tempTypeNofComps == 0) {
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < tempTypeNofComps; ++i) {
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    IType tempTypeCfType = tempTypeCf.getType().getTypeRefdLast(timestamp);
                    IType ofType = this.getOfType().getTypeRefdLast(timestamp);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(ofType, tempTypeCfType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(ofType);
                    rChain.add(tempTypeCfType);
                    if (!(ofType.equals(tempTypeCfType) || lChain.hasRecursion() && rChain.hasRecursion() || ofType.isCompatible(timestamp, tempTypeCfType, infoTemp, lChain, rChain))) {
                        if (infoTemp.getOp1RefStr().length() > 0) {
                            info.appendOp1Ref("[]");
                        }
                        info.appendOp1Ref(infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCf.getIdentifier().getDisplayName() + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_SEQUENCE_OF: {
                if (!this.isSubtypeCompatible(timestamp, lastOtherType)) {
                    info.setErrorStr("Incompatible record of/SEQUENCE OF subtypes");
                    return false;
                }
                SequenceOf_Type tempType = (SequenceOf_Type)lastOtherType;
                if (this == tempType) {
                    return true;
                }
                IType tempTypeOfType = tempType.getOfType().getTypeRefdLast(timestamp);
                IType ofType = this.getOfType().getTypeRefdLast(timestamp);
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                lChain.markState();
                rChain.markState();
                lChain.add(ofType);
                rChain.add(tempTypeOfType);
                TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(ofType, tempTypeOfType, false);
                if (!(ofType.equals(tempTypeOfType) || lChain.hasRecursion() && rChain.hasRecursion() || ofType.isCompatible(timestamp, tempTypeOfType, infoTemp, lChain, rChain))) {
                    if (info.getOp1RefStr().length() > 0) {
                        info.appendOp1Ref("[]");
                    }
                    if (info.getOp2RefStr().length() > 0) {
                        info.appendOp2Ref("[]");
                    }
                    info.appendOp1Ref(infoTemp.getOp1RefStr());
                    info.appendOp2Ref(infoTemp.getOp2RefStr());
                    info.setOp1Type(infoTemp.getOp1Type());
                    info.setOp2Type(infoTemp.getOp2Type());
                    info.setErrorStr(infoTemp.getErrorStr());
                    lChain.previousState();
                    rChain.previousState();
                    return false;
                }
                info.setNeedsConversion(true);
                lChain.previousState();
                rChain.previousState();
                return true;
            }
            case TYPE_ARRAY: {
                if (!this.isSubtypeCompatible(timestamp, lastOtherType)) {
                    info.setErrorStr("Incompatible record of/SEQUENCE OF subtypes");
                    return false;
                }
                Array_Type tempType = (Array_Type)lastOtherType;
                IType tempTypeElementType = tempType.getElementType().getTypeRefdLast(timestamp);
                IType ofType = this.getOfType().getTypeRefdLast(timestamp);
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                lChain.markState();
                rChain.markState();
                lChain.add(ofType);
                rChain.add(tempTypeElementType);
                TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(ofType, tempTypeElementType, false);
                if (!(ofType.equals(tempTypeElementType) || lChain.hasRecursion() && rChain.hasRecursion() || ofType.isCompatible(timestamp, tempTypeElementType, infoTemp, lChain, rChain))) {
                    if (infoTemp.getOp1RefStr().length() > 0) {
                        info.appendOp1Ref("[]");
                    }
                    info.appendOp1Ref(infoTemp.getOp1RefStr());
                    info.appendOp2Ref(infoTemp.getOp2RefStr());
                    info.setOp1Type(infoTemp.getOp1Type());
                    info.setOp2Type(infoTemp.getOp2Type());
                    info.setErrorStr(infoTemp.getErrorStr());
                    lChain.previousState();
                    rChain.previousState();
                    return false;
                }
                info.setNeedsConversion(true);
                lChain.previousState();
                rChain.previousState();
                return true;
            }
            case TYPE_ASN1_CHOICE: 
            case TYPE_TTCN3_CHOICE: 
            case TYPE_ANYTYPE: {
                info.setErrorStr(NOTCOMPATIBLEUNIONANYTYPE);
                return false;
            }
            case TYPE_ASN1_SET: 
            case TYPE_TTCN3_SET: 
            case TYPE_SET_OF: {
                info.setErrorStr(NOTCOMPATIBLESETSETOF);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isStronglyCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        IType lastOtherType = otherType.getTypeRefdLast(timestamp);
        if (IType.Type_type.TYPE_SEQUENCE_OF.equals((Object)lastOtherType.getTypetype())) {
            IType oftOther = ((SequenceOf_Type)lastOtherType).getOfType();
            IType oft = this.getOfType().getTypeRefdLast(timestamp);
            if (oft != null && oftOther != null) {
                switch (oft.getTypetype()) {
                    case TYPE_BOOL: 
                    case TYPE_BITSTRING: 
                    case TYPE_OCTETSTRING: 
                    case TYPE_INTEGER: 
                    case TYPE_REAL: 
                    case TYPE_CHARSTRING: 
                    case TYPE_HEXSTRING: 
                    case TYPE_UCHARSTRING: 
                    case TYPE_INTEGER_A: 
                    case TYPE_ASN1_ENUMERATED: 
                    case TYPE_BITSTRING_A: 
                    case TYPE_UTF8STRING: 
                    case TYPE_NUMERICSTRING: 
                    case TYPE_PRINTABLESTRING: 
                    case TYPE_TELETEXSTRING: 
                    case TYPE_VIDEOTEXSTRING: 
                    case TYPE_IA5STRING: 
                    case TYPE_GRAPHICSTRING: 
                    case TYPE_VISIBLESTRING: 
                    case TYPE_GENERALSTRING: 
                    case TYPE_UNIVERSALSTRING: 
                    case TYPE_BMPSTRING: 
                    case TYPE_UNRESTRICTEDSTRING: 
                    case TYPE_UTCTIME: 
                    case TYPE_GENERALIZEDTIME: 
                    case TYPE_OBJECTDESCRIPTOR: {
                        if (!oft.isStronglyCompatible(timestamp, oftOther, info, leftChain, rightChain)) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public String getOutlineIcon() {
        return "record_of.gif";
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_RECORDOF;
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        boolean selfReference = super.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return selfReference;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return selfReference;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return selfReference;
            }
        }
        if (IValue.Value_type.UNDEFINED_BLOCK.equals((Object)last.getValuetype())) {
            last = last.setValuetype(timestamp, IValue.Value_type.SEQUENCEOF_VALUE);
        }
        if (last.getIsErroneous(timestamp)) {
            return selfReference;
        }
        switch (last.getValuetype()) {
            case SEQUENCEOF_VALUE: {
                selfReference = this.checkThisValueSequenceOf(timestamp, (SequenceOf_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case SETOF_VALUE: {
                selfReference = this.checkThisValueSetOf(timestamp, (SetOf_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                if (value.isAsn()) {
                    value.getLocation().reportSemanticError(SEQOFVALUEEXPECTED);
                } else {
                    value.getLocation().reportSemanticError(RECORDOFVALUEEXPECTED);
                }
                value.setIsErroneous(true);
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, last);
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    public boolean checkThisValueSequenceOf(CompilationTimeStamp timestamp, SequenceOf_Value value, Assignment lhs, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean implicitOmit, boolean strElem) {
        boolean selfReference = false;
        if (value.isIndexed()) {
            boolean checkHoles = Expected_Value_type.EXPECTED_CONSTANT.equals((Object)expectedValue);
            BigInteger maxIndex = BigInteger.valueOf(-1L);
            HashMap<BigInteger, Integer> indexMap = new HashMap<BigInteger, Integer>(value.getNofComponents());
            int size = value.getNofComponents();
            for (int i = 0; i < size; ++i) {
                IValue component = value.getValueByIndex(i);
                IValue index = value.getIndexByIndex(i);
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                IValue indexLast = index.getValueRefdLast(timestamp, referenceChain);
                referenceChain.release();
                Type tempType = TypeFactory.createType(IType.Type_type.TYPE_INTEGER);
                tempType.check(timestamp);
                indexLast.setMyGovernor(tempType);
                IValue temporalValue = tempType.checkThisValueRef(timestamp, indexLast);
                tempType.checkThisValue(timestamp, temporalValue, lhs, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, true, false, true, false, false));
                if (indexLast.getIsErroneous(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)temporalValue.getValuetype())) {
                    checkHoles = false;
                } else {
                    BigInteger tempIndex = ((Integer_Value)temporalValue).getValueValue();
                    if (tempIndex.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == 1) {
                        index.getLocation().reportSemanticError(MessageFormat.format("A integer value less than `{0}'' was expected for indexing type `{1}'' instead of `{2}''", Integer.MAX_VALUE, this.getTypename(), tempIndex));
                        checkHoles = false;
                    } else if (tempIndex.compareTo(BigInteger.ZERO) == -1) {
                        index.getLocation().reportSemanticError(MessageFormat.format(NONNEGATIVEINDEXEXPECTEDTEMPLATE, this.getTypename(), tempIndex));
                        checkHoles = false;
                    } else if (indexMap.containsKey(tempIndex)) {
                        index.getLocation().reportSemanticError(MessageFormat.format("Duplicate index value `{0}'' for components {1} and {2}", tempIndex, indexMap.get(tempIndex), i + 1));
                        checkHoles = false;
                    } else {
                        indexMap.put(tempIndex, i + 1);
                        if (maxIndex.compareTo(tempIndex) == -1) {
                            maxIndex = tempIndex;
                        }
                    }
                }
                component.setMyGovernor(this.getOfType());
                IValue tempValue2 = this.getOfType().checkThisValueRef(timestamp, component);
                selfReference |= this.getOfType().checkThisValue(timestamp, tempValue2, lhs, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, false, true, implicitOmit, strElem));
            }
            if (checkHoles && maxIndex.compareTo(BigInteger.valueOf(indexMap.size() - 1)) != 0) {
                value.getLocation().reportSemanticError("It's not allowed to create hole(s) in constant values");
            }
        } else {
            int size = value.getNofComponents();
            for (int i = 0; i < size; ++i) {
                IValue component = value.getValueByIndex(i);
                component.setMyGovernor(this.getOfType());
                if (IValue.Value_type.NOTUSED_VALUE.equals((Object)component.getValuetype())) {
                    if (incompleteAllowed) continue;
                    component.getLocation().reportSemanticError(NOTUSEDNOTALLOWED1);
                    continue;
                }
                IValue tempValue2 = this.getOfType().checkThisValueRef(timestamp, component);
                selfReference |= this.getOfType().checkThisValue(timestamp, tempValue2, lhs, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, false, true, implicitOmit, strElem));
            }
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        boolean selfReference = false;
        switch (template.getTemplatetype()) {
            case OMIT_VALUE: {
                if (template.getLengthRestriction() == null) break;
                template.getLocation().reportSemanticWarning(REDUNDANTLENGTHRESTRICTION);
                break;
            }
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case PERMUTATION_MATCH: {
                PermutationMatch_Template permutationTemplate = (PermutationMatch_Template)template;
                int nofComponents = permutationTemplate.getNofTemplates();
                for (int i = 0; i < nofComponents; ++i) {
                    ITTCN3Template templateComponent = permutationTemplate.getTemplateByIndex(i);
                    templateComponent.setMyGovernor(this.getOfType());
                    templateComponent = this.getOfType().checkThisTemplateRef(timestamp, templateComponent);
                    selfReference |= templateComponent.checkThisTemplateGeneric(timestamp, this.getOfType(), false, false, true, true, implicitOmit, lhs);
                }
                break;
            }
            case SUPERSET_MATCH: {
                SupersetMatch_Template supersetTemplate = (SupersetMatch_Template)template;
                int nofComponents = supersetTemplate.getNofTemplates();
                for (int i = 0; i < nofComponents; ++i) {
                    ITTCN3Template templateComponent = supersetTemplate.getTemplateByIndex(i);
                    templateComponent.setMyGovernor(this.getOfType());
                    templateComponent = this.getOfType().checkThisTemplateRef(timestamp, templateComponent);
                    selfReference |= templateComponent.checkThisTemplateGeneric(timestamp, this.getOfType(), false, false, true, true, implicitOmit, lhs);
                }
                break;
            }
            case SUBSET_MATCH: {
                SubsetMatch_Template subsetTemplate = (SubsetMatch_Template)template;
                int nofComponents = subsetTemplate.getNofTemplates();
                for (int i = 0; i < nofComponents; ++i) {
                    ITTCN3Template templateComponent = subsetTemplate.getTemplateByIndex(i);
                    templateComponent.setMyGovernor(this.getOfType());
                    templateComponent = this.getOfType().checkThisTemplateRef(timestamp, templateComponent);
                    selfReference |= templateComponent.checkThisTemplateGeneric(timestamp, this.getOfType(), false, false, true, true, implicitOmit, lhs);
                }
                break;
            }
            case TEMPLATE_LIST: {
                ITTCN3Template.Completeness_type completeness = template.getCompletenessConditionSeof(timestamp, isModified);
                Template_List base = null;
                int nofBaseComps = 0;
                if (ITTCN3Template.Completeness_type.PARTIAL.equals((Object)completeness)) {
                    ITTCN3Template tempBase = template.getBaseTemplate();
                    if (tempBase != null) {
                        tempBase = tempBase.getTemplateReferencedLast(timestamp);
                    }
                    if (tempBase == null) {
                        this.setIsErroneous(true);
                        return selfReference;
                    }
                    base = (Template_List)tempBase;
                    nofBaseComps = base.getNofTemplates();
                }
                Template_List templateList = (Template_List)template;
                int nofComponents = templateList.getNofTemplates();
                block17: for (int i = 0; i < nofComponents; ++i) {
                    ITTCN3Template component = templateList.getTemplateByIndex(i);
                    component.setMyGovernor(this.getOfType());
                    if (base != null && nofBaseComps > i) {
                        component.setBaseTemplate(base.getTemplateByIndex(i));
                    } else {
                        component.setBaseTemplate(null);
                    }
                    component = this.getOfType().checkThisTemplateRef(timestamp, component);
                    switch (component.getTemplatetype()) {
                        case PERMUTATION_MATCH: {
                            selfReference |= component.checkThisTemplateGeneric(timestamp, this, isModified, false, true, true, implicitOmit, lhs);
                            continue block17;
                        }
                        case SUPERSET_MATCH: 
                        case SUBSET_MATCH: {
                            selfReference |= component.checkThisTemplateGeneric(timestamp, this, false, false, true, true, implicitOmit, lhs);
                            continue block17;
                        }
                        case TEMPLATE_NOTUSED: {
                            if (ITTCN3Template.Completeness_type.MUST_COMPLETE.equals((Object)completeness)) {
                                component.getLocation().reportSemanticWarning(NOTUSEDNOTALLOWED1);
                                continue block17;
                            }
                            if (!ITTCN3Template.Completeness_type.PARTIAL.equals((Object)completeness) || i < nofBaseComps) continue block17;
                            component.getLocation().reportSemanticError(NOTUSEDNOTALLOWED2);
                            continue block17;
                        }
                        default: {
                            boolean embeddedModified = completeness == ITTCN3Template.Completeness_type.MAY_INCOMPLETE || completeness == ITTCN3Template.Completeness_type.PARTIAL && i < nofBaseComps;
                            selfReference |= component.checkThisTemplateGeneric(timestamp, this.getOfType(), embeddedModified, false, true, true, implicitOmit, lhs);
                        }
                    }
                }
                break;
            }
            case INDEXED_TEMPLATE_LIST: {
                HashMap<Long, Integer> indexMap = new HashMap<Long, Integer>();
                Indexed_Template_List indexedTemplateList = (Indexed_Template_List)template;
                int size = indexedTemplateList.getNofTemplates();
                for (int i = 0; i < size; ++i) {
                    IndexedTemplate indexedTemplate = indexedTemplateList.getIndexedTemplateByIndex(i);
                    Value indexValue = indexedTemplate.getIndex().getValue();
                    ITTCN3Template templateComponent = indexedTemplate.getTemplate();
                    ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    IValue lastValue = indexValue.getValueRefdLast(timestamp, chain);
                    chain.release();
                    Type tempType = TypeFactory.createType(IType.Type_type.TYPE_INTEGER);
                    tempType.check(timestamp);
                    lastValue.setMyGovernor(tempType);
                    IValue temporalValue = tempType.checkThisValueRef(timestamp, lastValue);
                    tempType.checkThisValue(timestamp, temporalValue, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, true, false, true, false, false));
                    if (!temporalValue.getIsErroneous(timestamp) && IValue.Value_type.INTEGER_VALUE.equals((Object)temporalValue.getValuetype())) {
                        long index = ((Integer_Value)lastValue).getValue();
                        if (index > Integer.MAX_VALUE) {
                            indexValue.getLocation().reportSemanticError(MessageFormat.format(TOOBIGINDEXTEMPLATE, Integer.MAX_VALUE, this.getTypename(), index));
                            indexValue.setIsErroneous(true);
                        } else if (index < 0L) {
                            indexValue.getLocation().reportSemanticError(MessageFormat.format(NONNEGATIVEINDEXEXPECTEDTEMPLATE, this.getTypename(), index));
                            indexValue.setIsErroneous(true);
                        } else if (indexMap.containsKey(index)) {
                            indexValue.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEINDEX, index, i + 1, indexMap.get(index)));
                            indexValue.setIsErroneous(true);
                        } else {
                            indexMap.put(index, i);
                        }
                    }
                    templateComponent.setMyGovernor(this.getOfType());
                    templateComponent = this.getOfType().checkThisTemplateRef(timestamp, templateComponent);
                    selfReference |= templateComponent.checkThisTemplateGeneric(timestamp, this.getOfType(), true, false, true, true, implicitOmit, lhs);
                }
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
            }
        }
        return selfReference;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                Value indexValue = ((ArraySubReference)subreference).getValue();
                if (indexValue != null) {
                    indexValue.setLoweridToReference(timestamp);
                    IType.Type_type tempType = indexValue.getExpressionReturntype(timestamp, expectedIndex);
                    if (tempType == IType.Type_type.TYPE_UNDEFINED) {
                        if (this.getOfType() != null) {
                            return this.getOfType().getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, interruptIfOptional);
                        }
                        return null;
                    }
                    IType indexingType = indexValue.getExpressionGovernor(timestamp, expectedIndex);
                    if (indexingType != null) {
                        indexingType = indexingType.getTypeRefdLast(timestamp);
                    }
                    if (indexingType != null && (indexingType.getTypetype() == IType.Type_type.TYPE_ARRAY || indexingType.getTypetype() == IType.Type_type.TYPE_SEQUENCE_OF)) {
                        long length = 0L;
                        if (indexingType.getTypetype() == IType.Type_type.TYPE_ARRAY) {
                            Array_Type indexingArray = (Array_Type)indexingType;
                            if (indexingArray.getElementType().getTypetype() != IType.Type_type.TYPE_INTEGER) {
                                subreference.getLocation().reportSemanticError("Only fixed length array or record of integer types are allowed for short-hand notation for nested indexes.");
                                return null;
                            }
                            length = indexingArray.getDimension().getSize();
                        } else if (indexingType.getTypetype() == IType.Type_type.TYPE_SEQUENCE_OF) {
                            SequenceOf_Type indexingSequenceOf = (SequenceOf_Type)indexingType;
                            if (indexingSequenceOf.getOfType().getTypetype() != IType.Type_type.TYPE_INTEGER) {
                                subreference.getLocation().reportSemanticError("Only fixed length array or record of integer types are allowed for short-hand notation for nested indexes.");
                                return null;
                            }
                            SubType subType = indexingSequenceOf.getSubtype();
                            if (subType == null) {
                                subreference.getLocation().reportSemanticError(MessageFormat.format("The type `{0}'' must have single size length restriction when used as a short-hand notation for nested indexes.", indexingSequenceOf.getTypename()));
                                return null;
                            }
                            length = subType.get_length_restriction();
                            if (length == -1L) {
                                subreference.getLocation().reportSemanticError(MessageFormat.format("The type `{0}'' must have single size length restriction when used as a short-hand notation for nested indexes.", indexingSequenceOf.getTypename()));
                                return null;
                            }
                        }
                        IType embeddedType = this.getOfType().getTypeRefdLast(timestamp);
                        int j = 0;
                        while ((long)j < length - 1L) {
                            switch (embeddedType.getTypetype()) {
                                case TYPE_ARRAY: {
                                    embeddedType = ((Array_Type)embeddedType).getElementType();
                                    break;
                                }
                                case TYPE_SEQUENCE_OF: {
                                    embeddedType = ((SequenceOf_Type)embeddedType).getOfType();
                                    break;
                                }
                                case TYPE_SET_OF: {
                                    embeddedType = ((SetOf_Type)embeddedType).getOfType();
                                    break;
                                }
                                default: {
                                    subreference.getLocation().reportSemanticError(MessageFormat.format("The type `{0}'' contains too many indexes ({1}) in the short-hand notation for nested indexes.", indexingType.getTypename(), length));
                                    return null;
                                }
                            }
                            ++j;
                        }
                        return embeddedType.getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, interruptIfOptional);
                    }
                    if (indexingType != null && indexingType.getTypetypeTtcn3() == IType.Type_type.TYPE_INTEGER) {
                        IValue last = indexValue.getValueRefdLast(timestamp, expectedIndex, refChain);
                        if (IValue.Value_type.INTEGER_VALUE.equals((Object)last.getValuetype())) {
                            Integer_Value lastInteger = (Integer_Value)last;
                            if (lastInteger.isNative()) {
                                int lengthRestriction;
                                long temp = lastInteger.getValue();
                                if (temp < 0L) {
                                    indexValue.getLocation().reportSemanticError(MessageFormat.format(NONNEGATIVINDEXEXPECTED, temp));
                                    indexValue.setIsErroneous(true);
                                } else if (this.subType != null && (lengthRestriction = this.subType.get_length_restriction()) > 0 && (long)lengthRestriction <= temp) {
                                    indexValue.getLocation().reportSemanticError(MessageFormat.format(INDEXOVERFLOW, lengthRestriction - 1, temp));
                                    indexValue.setIsErroneous(true);
                                }
                            } else {
                                indexValue.getLocation().reportSemanticError(MessageFormat.format(TOOBIGINDEX, lastInteger.getValueValue(), this.getTypename()));
                                indexValue.setIsErroneous(true);
                            }
                        }
                        if (this.getOfType() != null) {
                            return this.getOfType().getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, interruptIfOptional);
                        }
                    } else {
                        indexValue.getLocation().reportSemanticError(INTEGERINDEXEXPECTED);
                        indexValue.setIsErroneous(true);
                    }
                }
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public void checkMapParameter(CompilationTimeStamp timestamp, IReferenceChain refChain, Location errorLocation) {
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        this.getOfType().checkMapParameter(timestamp, refChain, errorLocation);
    }

    @Override
    public void forceRaw(CompilationTimeStamp timestamp) {
        if (this.rawAttribute == null) {
            this.rawAttribute = new RawAST(this.getDefaultRawFieldLength());
        }
    }

    @Override
    public void forceJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null) {
            this.jsonAttribute = new JsonAST();
        }
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        builder.append("sequence of ");
        if (this.getOfType() != null) {
            this.getOfType().getProposalDescription(builder);
        }
        return builder;
    }

    @Override
    public Declaration resolveReference(Reference reference, int subRefIdx, ISubReference lastSubreference) {
        if (this.getOfType() == null) {
            return null;
        }
        IType refdLastOfType = this.getOfType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (refdLastOfType != this && refdLastOfType instanceof IReferenceableElement) {
            return ((IReferenceableElement)((Object)refdLastOfType)).resolveReference(reference, subRefIdx + 1, lastSubreference);
        }
        return null;
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        boolean force_gen_seof = aData.getForceGenSeof();
        if (force_gen_seof) {
            return true;
        }
        IType ofType = this.getOfType();
        switch (ofType.getTypetype()) {
            case TYPE_BOOL: 
            case TYPE_BITSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_INTEGER: 
            case TYPE_REAL: 
            case TYPE_CHARSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_UCHARSTRING: 
            case TYPE_INTEGER_A: 
            case TYPE_BITSTRING_A: 
            case TYPE_UTF8STRING: 
            case TYPE_TELETEXSTRING: 
            case TYPE_VIDEOTEXSTRING: 
            case TYPE_GRAPHICSTRING: 
            case TYPE_GENERALSTRING: 
            case TYPE_UNIVERSALSTRING: 
            case TYPE_BMPSTRING: 
            case TYPE_OBJECTDESCRIPTOR: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        String ofTypeGenName;
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        String genName = this.getGenNameOwn();
        String displayName = this.getFullName();
        IType ofType = this.getOfType();
        boolean force_gen_seof = aData.getForceGenSeof();
        if (force_gen_seof) {
            ofTypeGenName = ofType.getGenNameValue(aData, source);
            String ofTemplateTypeName = ofType.getGenNameTemplate(aData, source);
            boolean hasRaw = this.getGenerateCoderFunctions(IType.MessageEncoding_type.RAW);
            boolean hasJson = this.getGenerateCoderFunctions(IType.MessageEncoding_type.JSON);
            int extension_bit = -1;
            if (hasRaw) {
                RawAST dummy_raw = this.rawAttribute == null ? new RawAST(this.getDefaultRawFieldLength()) : this.rawAttribute;
                extension_bit = dummy_raw.extension_bit;
            }
            StringBuilder localTypeDescriptor = new StringBuilder();
            HashMap<String, String> attributeRegistry = new HashMap<String, String>();
            this.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
            this.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
            StringBuilder localCodingHandler = new StringBuilder();
            this.generateCodeForCodingHandlers(aData, source, localCodingHandler);
            if (!ofType.generatesOwnClass(aData, source)) {
                ofType.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
                ofType.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
                ofType.generateCodeForCodingHandlers(aData, source, localCodingHandler);
            }
            RecordOfGenerator.generateValueClass(aData, source, genName, displayName, ofTypeGenName, false, hasRaw, true, extension_bit, hasJson, localTypeDescriptor, localCodingHandler);
            RecordOfGenerator.generateTemplateClass(aData, source, genName, displayName, ofTemplateTypeName, false);
        } else {
            ofTypeGenName = ofType.getGenNameValue(aData, source);
            switch (ofType.getTypetype()) {
                case TYPE_BOOL: 
                case TYPE_BITSTRING: 
                case TYPE_OCTETSTRING: 
                case TYPE_INTEGER: 
                case TYPE_REAL: 
                case TYPE_CHARSTRING: 
                case TYPE_HEXSTRING: 
                case TYPE_UCHARSTRING: 
                case TYPE_INTEGER_A: 
                case TYPE_BITSTRING_A: 
                case TYPE_UTF8STRING: 
                case TYPE_TELETEXSTRING: 
                case TYPE_VIDEOTEXSTRING: 
                case TYPE_GRAPHICSTRING: 
                case TYPE_GENERALSTRING: 
                case TYPE_UNIVERSALSTRING: 
                case TYPE_BMPSTRING: 
                case TYPE_OBJECTDESCRIPTOR: {
                    this.generateCodeTypedescriptor(aData, source, null, aData.attibute_registry);
                    this.generateCodeDefaultCoding(aData, source, null);
                    this.generateCodeForCodingHandlers(aData, source, null);
                    String ownName = this.getGenNameOwn(aData);
                    String valueName = this.getGenNameValue(aData, source);
                    source.append(MessageFormat.format("\t// code for type {0} is not generated, {1} is used instead\n", ownName, valueName));
                    break;
                }
                case TYPE_REFERENCED: {
                    String ofTemplateTypeName = ofType.getGenNameTemplate(aData, source);
                    boolean hasRaw = this.getGenerateCoderFunctions(IType.MessageEncoding_type.RAW);
                    boolean hasJson = this.getGenerateCoderFunctions(IType.MessageEncoding_type.JSON);
                    int extension_bit = -1;
                    if (hasRaw) {
                        RawAST dummy_raw = this.rawAttribute == null ? new RawAST(this.getDefaultRawFieldLength()) : this.rawAttribute;
                        extension_bit = dummy_raw.extension_bit;
                    }
                    StringBuilder localTypeDescriptor = new StringBuilder();
                    HashMap<String, String> attributeRegistry = new HashMap<String, String>();
                    this.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
                    this.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
                    StringBuilder localCodingHandler = new StringBuilder();
                    this.generateCodeForCodingHandlers(aData, source, localCodingHandler);
                    if (!ofType.generatesOwnClass(aData, source)) {
                        ofType.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
                        ofType.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
                        ofType.generateCodeForCodingHandlers(aData, source, localCodingHandler);
                    }
                    RecordOfGenerator.generateValueClass(aData, source, genName, displayName, ofTypeGenName, false, hasRaw, false, extension_bit, hasJson, localTypeDescriptor, localCodingHandler);
                    RecordOfGenerator.generateTemplateClass(aData, source, genName, displayName, ofTemplateTypeName, false);
                    break;
                }
                default: {
                    String ofTemplateTypeName = ofType.getGenNameTemplate(aData, source);
                    boolean hasRaw = this.getGenerateCoderFunctions(IType.MessageEncoding_type.RAW);
                    boolean hasJson = this.getGenerateCoderFunctions(IType.MessageEncoding_type.JSON);
                    int extension_bit = -1;
                    if (hasRaw) {
                        RawAST dummy_raw = this.rawAttribute == null ? new RawAST(this.getDefaultRawFieldLength()) : this.rawAttribute;
                        extension_bit = dummy_raw.extension_bit;
                    }
                    StringBuilder localTypeDescriptor = new StringBuilder();
                    HashMap<String, String> attributeRegistry = new HashMap<String, String>();
                    this.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
                    this.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
                    StringBuilder localCodingHandler = new StringBuilder();
                    this.generateCodeForCodingHandlers(aData, source, localCodingHandler);
                    if (!ofType.generatesOwnClass(aData, source)) {
                        ofType.generateCodeTypedescriptor(aData, source, localTypeDescriptor, attributeRegistry);
                        ofType.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
                        ofType.generateCodeForCodingHandlers(aData, source, localCodingHandler);
                    }
                    RecordOfGenerator.generateValueClass(aData, source, genName, displayName, ofTypeGenName, false, hasRaw, false, extension_bit, hasJson, localTypeDescriptor, localCodingHandler);
                    RecordOfGenerator.generateTemplateClass(aData, source, genName, displayName, ofTemplateTypeName, false);
                    break;
                }
            }
        }
        StringBuilder tempSource = aData.getCodeForType(ofType.getGenNameOwn());
        ofType.generateCode(aData, tempSource);
        if (!this.isAsn()) {
            if (this.hasDoneAttribute()) {
                this.generateCodeDone(aData, source);
            }
            if (this.subType != null) {
                this.subType.generateCode(aData, source);
            }
        }
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        boolean force_gen_seof = aData.getForceGenSeof();
        if (force_gen_seof) {
            return this.getGenNameOwn(aData);
        }
        boolean optimized_memalloc = false;
        IType ofType = this.getOfType();
        switch (ofType.getTypetype()) {
            case TYPE_BOOL: {
                return RecordOfGenerator.getPreGenBasedNameValue(aData, source, "BOOLEAN", false, false);
            }
            case TYPE_BITSTRING: 
            case TYPE_BITSTRING_A: {
                return RecordOfGenerator.getPreGenBasedNameValue(aData, source, "BITSTRING", false, false);
            }
            case TYPE_HEXSTRING: {
                return RecordOfGenerator.getPreGenBasedNameValue(aData, source, "HEXSTRING", false, false);
            }
            case TYPE_OCTETSTRING: {
                return RecordOfGenerator.getPreGenBasedNameValue(aData, source, "OCTETSTRING", false, false);
            }
            case TYPE_CHARSTRING: {
                return RecordOfGenerator.getPreGenBasedNameValue(aData, source, "CHARSTRING", false, false);
            }
            case TYPE_UCHARSTRING: 
            case TYPE_UTF8STRING: 
            case TYPE_TELETEXSTRING: 
            case TYPE_VIDEOTEXSTRING: 
            case TYPE_GRAPHICSTRING: 
            case TYPE_GENERALSTRING: 
            case TYPE_UNIVERSALSTRING: 
            case TYPE_BMPSTRING: 
            case TYPE_OBJECTDESCRIPTOR: {
                return RecordOfGenerator.getPreGenBasedNameValue(aData, source, "UNIVERSAL__CHARSTRING", false, false);
            }
            case TYPE_INTEGER: 
            case TYPE_INTEGER_A: {
                return RecordOfGenerator.getPreGenBasedNameValue(aData, source, "INTEGER", false, false);
            }
            case TYPE_REAL: {
                return RecordOfGenerator.getPreGenBasedNameValue(aData, source, "FLOAT", false, false);
            }
        }
        return this.getGenNameOwn(aData);
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        return this.getGenNameValue(aData, source).concat("_template");
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        boolean force_gen_seof = aData.getForceGenSeof();
        if (force_gen_seof) {
            String baseName = this.getGenNameTypeName(aData, source);
            return baseName + "." + this.getGenNameOwn();
        }
        IType ofType = this.getOfType();
        switch (ofType.getTypetype()) {
            case TYPE_BOOL: 
            case TYPE_BITSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_INTEGER: 
            case TYPE_REAL: 
            case TYPE_CHARSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_UCHARSTRING: 
            case TYPE_INTEGER_A: 
            case TYPE_BITSTRING_A: 
            case TYPE_UTF8STRING: 
            case TYPE_TELETEXSTRING: 
            case TYPE_VIDEOTEXSTRING: 
            case TYPE_GRAPHICSTRING: 
            case TYPE_GENERALSTRING: 
            case TYPE_UNIVERSALSTRING: 
            case TYPE_BMPSTRING: 
            case TYPE_OBJECTDESCRIPTOR: {
                IType parentType;
                if (this.getParentType() != null && (parentType = this.getParentType()).generatesOwnClass(aData, source)) {
                    return parentType.getGenNameOwn(aData) + "." + this.getGenNameOwn();
                }
                return this.getGenNameOwn(aData);
            }
        }
        String baseName = this.getGenNameTypeName(aData, source);
        return baseName + "." + this.getGenNameOwn();
    }

    @Override
    public boolean needsOwnRawDescriptor(JavaGenData aData) {
        return true;
    }

    @Override
    public String getGenNameRawDescriptor(JavaGenData aData, StringBuilder source) {
        boolean force_gen_seof = aData.getForceGenSeof();
        if (force_gen_seof) {
            return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_raw_";
        }
        IType ofType = this.getOfType();
        switch (ofType.getTypetype()) {
            case TYPE_BOOL: 
            case TYPE_BITSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_INTEGER: 
            case TYPE_REAL: 
            case TYPE_CHARSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_UCHARSTRING: 
            case TYPE_INTEGER_A: 
            case TYPE_BITSTRING_A: 
            case TYPE_UTF8STRING: 
            case TYPE_TELETEXSTRING: 
            case TYPE_VIDEOTEXSTRING: 
            case TYPE_GRAPHICSTRING: 
            case TYPE_GENERALSTRING: 
            case TYPE_UNIVERSALSTRING: 
            case TYPE_BMPSTRING: 
            case TYPE_OBJECTDESCRIPTOR: {
                IType parentType;
                if (this.getParentType() != null && (parentType = this.getParentType()).generatesOwnClass(aData, source)) {
                    return parentType.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_raw_";
                }
                return this.getGenNameOwn(aData) + "_raw_";
            }
        }
        return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_raw_";
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return true;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        boolean force_gen_seof = aData.getForceGenSeof();
        if (force_gen_seof) {
            return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_json_";
        }
        IType ofType = this.getOfType();
        switch (ofType.getTypetype()) {
            case TYPE_BOOL: 
            case TYPE_BITSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_INTEGER: 
            case TYPE_REAL: 
            case TYPE_CHARSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_UCHARSTRING: 
            case TYPE_INTEGER_A: 
            case TYPE_BITSTRING_A: 
            case TYPE_UTF8STRING: 
            case TYPE_TELETEXSTRING: 
            case TYPE_VIDEOTEXSTRING: 
            case TYPE_GRAPHICSTRING: 
            case TYPE_GENERALSTRING: 
            case TYPE_UNIVERSALSTRING: 
            case TYPE_BMPSTRING: 
            case TYPE_OBJECTDESCRIPTOR: {
                IType parentType;
                if (this.getParentType() != null && (parentType = this.getParentType()).generatesOwnClass(aData, source)) {
                    return parentType.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_json_";
                }
                return this.getGenNameOwn(aData) + "_json_";
            }
        }
        return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_json_";
    }

    @Override
    public String getGenNameBerDescriptor(JavaGenData aData, StringBuilder source) {
        return "SEQUENCE_ber_";
    }

    @Override
    public String generateConversion(JavaGenData aData, IType fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        boolean simpleOfType;
        IType refdType = fromType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (refdType == null || this == refdType) {
            return fromName;
        }
        IType ofType = this.getOfType();
        switch (ofType.getTypetype()) {
            case TYPE_BOOL: 
            case TYPE_BITSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_INTEGER: 
            case TYPE_REAL: 
            case TYPE_CHARSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_UCHARSTRING: 
            case TYPE_INTEGER_A: 
            case TYPE_BITSTRING_A: 
            case TYPE_UTF8STRING: 
            case TYPE_TELETEXSTRING: 
            case TYPE_VIDEOTEXSTRING: 
            case TYPE_GRAPHICSTRING: 
            case TYPE_GENERALSTRING: 
            case TYPE_UNIVERSALSTRING: 
            case TYPE_BMPSTRING: 
            case TYPE_OBJECTDESCRIPTOR: {
                simpleOfType = true;
                break;
            }
            default: {
                simpleOfType = false;
            }
        }
        switch (refdType.getTypetype()) {
            case TYPE_SEQUENCE_OF: {
                if (!aData.getForceGenSeof() && simpleOfType) {
                    return fromName;
                }
                IType fromOfType = ((SequenceOf_Type)refdType).getOfType();
                return this.generateConversionSetSeqOfToSetSeqOf(aData, fromType, fromName, ofType, fromOfType, forValue, expression);
            }
            case TYPE_TTCN3_SEQUENCE: {
                TTCN3_Sequence_Type refdFromType = (TTCN3_Sequence_Type)refdType;
                return this.generateConversionSeqToSeqOf(aData, refdFromType, fromName, ofType, forValue, expression);
            }
            case TYPE_ARRAY: {
                return this.generateConversionArrayToSetSeqOf(aData, (Array_Type)fromType, fromName, ofType, forValue, expression);
            }
        }
        return "FATAL ERROR during converting to type " + this.getTypename();
    }

    private String generateConversionSetSeqOfToSetSeqOf(JavaGenData aData, IType fromType, String fromName, IType toOfType, IType fromOfType, boolean forValue, ExpressionStruct expression) {
        String tempId = aData.getTemporaryVariableName();
        String name = forValue ? this.getGenNameValue(aData, expression.preamble) : this.getGenNameTemplate(aData, expression.preamble);
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", name, tempId));
        String ConversionFunctionName = Type.getConversionFunction(aData, fromType, this, forValue, expression.preamble);
        expression.preamble.append(MessageFormat.format("if(!{0}({1}, {2})) '{'\n", ConversionFunctionName, tempId, fromName));
        expression.preamble.append(MessageFormat.format("throw new TtcnError(\"Values or templates of type `{0}'' and `{1}'' are not compatible at run-time\");\n", this.getTypename(), fromType.getTypename()));
        expression.preamble.append("}\n");
        if (!aData.hasTypeConversion(ConversionFunctionName)) {
            StringBuilder conversionFunctionBody = new StringBuilder();
            String fromTypeName = forValue ? fromType.getGenNameValue(aData, conversionFunctionBody) : fromType.getGenNameTemplate(aData, conversionFunctionBody);
            conversionFunctionBody.append(MessageFormat.format("\tpublic static boolean {0}(final {1} to, final {2} from) '{'\n", ConversionFunctionName, name, fromTypeName));
            conversionFunctionBody.append("\t\tto.set_size(from.n_elem());\n");
            conversionFunctionBody.append("\t\tfor (int i = 0; i < from.n_elem(); i++) {\n");
            String tempId2 = aData.getTemporaryVariableName();
            String fromOfTypeName = forValue ? fromOfType.getGenNameValue(aData, conversionFunctionBody) : fromOfType.getGenNameTemplate(aData, conversionFunctionBody);
            conversionFunctionBody.append(MessageFormat.format("\t\t\tfinal {0} {1} = from.constGet_at(i);\n", fromOfTypeName, tempId2));
            conversionFunctionBody.append(MessageFormat.format("\t\t\tif({0}.is_bound()) '{'\n", tempId2));
            ExpressionStruct tempExpression = new ExpressionStruct();
            String tempId3 = toOfType.generateConversion(aData, fromOfType, tempId2, forValue, tempExpression);
            tempExpression.openMergeExpression(conversionFunctionBody);
            conversionFunctionBody.append(MessageFormat.format("\t\t\t\tto.get_at(i).operator_assign({0});\n", tempId3));
            conversionFunctionBody.append("\t\t\t}\n");
            conversionFunctionBody.append("\t\t}\n");
            conversionFunctionBody.append("\t\treturn true;\n");
            conversionFunctionBody.append("\t}\n\n");
            aData.addTypeConversion(ConversionFunctionName, conversionFunctionBody.toString());
        }
        return tempId;
    }

    private String generateConversionSeqToSeqOf(JavaGenData aData, TTCN3_Sequence_Type fromType, String fromName, IType toOfType, boolean forValue, ExpressionStruct expression) {
        String tempId = aData.getTemporaryVariableName();
        String name = forValue ? this.getGenNameValue(aData, expression.preamble) : this.getGenNameTemplate(aData, expression.preamble);
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", name, tempId));
        String ConversionFunctionName = Type.getConversionFunction(aData, fromType, this, forValue, expression.preamble);
        expression.preamble.append(MessageFormat.format("if(!{0}({1}, {2})) '{'\n", ConversionFunctionName, tempId, fromName));
        expression.preamble.append(MessageFormat.format("throw new TtcnError(\"Values or templates of type `{0}'' and `{1}'' are not compatible at run-time\");\n", this.getTypename(), fromType.getTypename()));
        expression.preamble.append("}\n");
        if (!aData.hasTypeConversion(ConversionFunctionName)) {
            StringBuilder conversionFunctionBody = new StringBuilder();
            String fromTypeName = forValue ? fromType.getGenNameValue(aData, conversionFunctionBody) : fromType.getGenNameTemplate(aData, conversionFunctionBody);
            conversionFunctionBody.append(MessageFormat.format("\tpublic static boolean {0}(final {1} to, final {2} from) '{'\n", ConversionFunctionName, name, fromTypeName));
            int fromComponentCount = fromType.getNofComponents();
            conversionFunctionBody.append(MessageFormat.format("\t\tto.set_size({0});\n", fromComponentCount));
            for (int i = 0; i < fromComponentCount; ++i) {
                CompField fromComp = fromType.getComponentByIndex(i);
                Identifier fromFieldName = fromComp.getIdentifier();
                IType fromFieldType = fromComp.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                String tempId2 = aData.getTemporaryVariableName();
                String fromFieldTypeName = forValue ? fromFieldType.getGenNameValue(aData, conversionFunctionBody) : fromFieldType.getGenNameTemplate(aData, conversionFunctionBody);
                conversionFunctionBody.append(MessageFormat.format("\t\tfinal {0} {1} = from.constGet_field_{2}(){3};\n", fromFieldTypeName, tempId2, FieldSubReference.getJavaGetterName(fromFieldName.getName()), forValue && fromComp.isOptional() ? ".constGet()" : ""));
                conversionFunctionBody.append(MessageFormat.format("\t\t\tif({0}.is_bound()) '{'\n", tempId2));
                ExpressionStruct tempExpression = new ExpressionStruct();
                String tempId3 = toOfType.generateConversion(aData, fromFieldType, tempId2, forValue, tempExpression);
                tempExpression.openMergeExpression(conversionFunctionBody);
                conversionFunctionBody.append(MessageFormat.format("\t\t\t\tto.get_at({0}).operator_assign({1});\n", i, tempId3));
                conversionFunctionBody.append("\t\t}\n");
            }
            conversionFunctionBody.append("\t\treturn true;\n");
            conversionFunctionBody.append("\t}\n\n");
            aData.addTypeConversion(ConversionFunctionName, conversionFunctionBody.toString());
        }
        return tempId;
    }

    private String generateConversionArrayToSetSeqOf(JavaGenData aData, Array_Type fromType, String fromName, IType toOfType, boolean forValue, ExpressionStruct expression) {
        String tempId = aData.getTemporaryVariableName();
        IType fromOfType = fromType.getElementType();
        ArrayDimension arrayDimension = fromType.getDimension();
        long startIndex = arrayDimension.getOffset();
        String name = forValue ? this.getGenNameValue(aData, expression.preamble) : this.getGenNameTemplate(aData, expression.preamble);
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", name, tempId));
        String ConversionFunctionName = Type.getConversionFunction(aData, fromType, this, forValue, expression.preamble);
        expression.preamble.append(MessageFormat.format("if(!{0}({1}, {2})) '{'\n", ConversionFunctionName, tempId, fromName));
        expression.preamble.append(MessageFormat.format("throw new TtcnError(\"Values or templates of type `{0}'' and `{1}'' are not compatible at run-time\");\n", this.getTypename(), fromType.getTypename()));
        expression.preamble.append("}\n");
        if (!aData.hasTypeConversion(ConversionFunctionName)) {
            StringBuilder conversionFunctionBody = new StringBuilder();
            String fromTypeName = forValue ? fromType.getGenNameValue(aData, conversionFunctionBody) : fromType.getGenNameTemplate(aData, conversionFunctionBody);
            conversionFunctionBody.append(MessageFormat.format("\tpublic static boolean {0}(final {1} to, final {2} from) '{'\n", ConversionFunctionName, name, fromTypeName));
            conversionFunctionBody.append(MessageFormat.format("\t\tto.set_size({0});\n", arrayDimension.getSize()));
            conversionFunctionBody.append(MessageFormat.format("\t\tfor (int i = 0; i < {0}; i++) '{'\n", arrayDimension.getSize()));
            String tempId2 = aData.getTemporaryVariableName();
            String fromOfTypeName = forValue ? fromOfType.getGenNameValue(aData, conversionFunctionBody) : fromOfType.getGenNameTemplate(aData, conversionFunctionBody);
            conversionFunctionBody.append(MessageFormat.format("\t\t\tfinal {0} {1} = from.constGet_at(i + {2});\n", fromOfTypeName, tempId2, startIndex));
            conversionFunctionBody.append(MessageFormat.format("\t\t\tif({0}.is_bound()) '{'\n", tempId2));
            ExpressionStruct tempExpression = new ExpressionStruct();
            String tempId3 = toOfType.generateConversion(aData, fromOfType, tempId2, forValue, tempExpression);
            tempExpression.openMergeExpression(conversionFunctionBody);
            conversionFunctionBody.append(MessageFormat.format("\t\t\t\tto.get_at(i).operator_assign({0});\n", tempId3));
            conversionFunctionBody.append("\t\t\t}\n");
            conversionFunctionBody.append("\t\t}\n");
            conversionFunctionBody.append("\t\treturn true;\n");
            conversionFunctionBody.append("\t}\n\n");
            aData.addTypeConversion(ConversionFunctionName, conversionFunctionBody.toString());
        }
        return tempId;
    }
}

