/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.implementation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titanium.metrics.MetricData;
import org.eclipse.titanium.metrics.ModuleMetric;
import org.eclipse.titanium.metrics.implementation.AfferentCouplingDetector;
import org.eclipse.titanium.metrics.implementation.BaseModuleMetric;

public class MMAfferentCoupling
extends BaseModuleMetric {
    private final Map<Module, Set<Assignment>> afferentCoupling = new HashMap<Module, Set<Assignment>>();

    public MMAfferentCoupling() {
        super(ModuleMetric.AFFERENT_COUPLING);
    }

    @Override
    public void init(MetricData data) {
        this.afferentCoupling.clear();
        List<Module> modules = data.getModules();
        for (Module module : modules) {
            this.afferentCoupling.put(module, new HashSet());
        }
        for (Module module : modules) {
            module.accept(new ASTVisitor(){

                public int visit(IVisitableNode node) {
                    if (node instanceof Assignment) {
                        Assignment assignment = (Assignment)node;
                        node.accept((ASTVisitor)new AfferentCouplingDetector(assignment, MMAfferentCoupling.this.afferentCoupling));
                        return 1;
                    }
                    if (node instanceof Definition) {
                        return 1;
                    }
                    return 3;
                }
            });
        }
    }

    @Override
    public Number measure(MetricData data, Module module) {
        return this.afferentCoupling.get(module).size();
    }
}

