/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.core.LoadBalancingUtilities;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.markers.handler.Marker;
import org.eclipse.titanium.markers.handler.MarkerHandler;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseProjectCodeSmellSpotter;
import org.eclipse.titanium.markers.utils.AnalyzerBuilder;

public class Analyzer {
    private final Map<Class<? extends IVisitableNode>, Set<BaseModuleCodeSmellSpotter>> actions;
    private final Set<BaseProjectCodeSmellSpotter> projectActions;

    Analyzer(Map<Class<? extends IVisitableNode>, Set<BaseModuleCodeSmellSpotter>> actions, Set<BaseProjectCodeSmellSpotter> projectActions) {
        this.actions = actions;
        this.projectActions = projectActions;
    }

    private List<Marker> internalAnalyzeModule(Module module) {
        CodeSmellVisitor v = new CodeSmellVisitor();
        module.accept((ASTVisitor)v);
        return v.markers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Marker> internalAnalyzeProject(IProject project) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (BaseProjectCodeSmellSpotter spotter : this.projectActions) {
            List<Marker> ms;
            IProject iProject = project;
            synchronized (iProject) {
                ms = spotter.checkProject(project);
            }
            markers.addAll(ms);
        }
        return markers;
    }

    public MarkerHandler analyzeProject(IProgressMonitor monitor, IProject project) {
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)project);
        Set knownModuleNames = projectSourceParser.getKnownModuleNames();
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + knownModuleNames.size()));
        progress.subTask("Project level analysis");
        final ConcurrentHashMap<IResource, List<Marker>> markers = new ConcurrentHashMap<IResource, List<Marker>>();
        markers.put((IResource)project, this.internalAnalyzeProject(project));
        progress.worked(1);
        ArrayList<Module> knownModules = new ArrayList<Module>(knownModuleNames.size());
        for (String moduleName : knownModuleNames) {
            Module mod = projectSourceParser.getModuleByName(moduleName);
            knownModules.add(mod);
        }
        Collections.sort(knownModules, new Comparator<Module>(){

            @Override
            public int compare(Module o1, Module o2) {
                return o2.getAssignments().getNofAssignments() - o1.getAssignments().getNofAssignments();
            }
        });
        ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setPriority(LoadBalancingUtilities.getThreadPriority());
                return t;
            }
        });
        final CountDownLatch latch = new CountDownLatch(knownModuleNames.size());
        for (final Module module : knownModules) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (progress.isCanceled()) {
                        latch.countDown();
                        throw new OperationCanceledException();
                    }
                    try {
                        progress.subTask("Analyzing module " + module.getName());
                        IResource moduleResource = module.getLocation().getFile();
                        markers.put(moduleResource, Analyzer.this.internalAnalyzeModule(module));
                        progress.worked(1);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor.shutdownNow();
        return new MarkerHandler(markers);
    }

    public static AnalyzerBuilder builder() {
        return new AnalyzerBuilder();
    }

    private class CodeSmellVisitor
    extends ASTVisitor {
        private final List<Marker> markers = new ArrayList<Marker>();

        public int visit(IVisitableNode node) {
            Set actionsOnNode = (Set)Analyzer.this.actions.get(node.getClass());
            if (actionsOnNode != null) {
                for (BaseModuleCodeSmellSpotter spotter : actionsOnNode) {
                    this.markers.addAll(spotter.checkNode(node));
                }
            }
            return 3;
        }
    }
}

