/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.gui.layouts.algorithms;

import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.eclipse.titanium.graph.gui.layouts.algorithms.HierarcicalLayoutAlgorithm;

public class DAGLayoutAlgorithm<V, E>
implements HierarcicalLayoutAlgorithm<V> {
    protected Graph<V, E> g;
    protected int nodenum;
    protected Map<V, Integer> level;
    protected Set<V> isolateNodes;
    protected Integer minusLevels;
    protected Map<V, Integer> arcs;
    protected Map<Set<V>, Integer> mapCircleArcs;
    protected PriorityQueue<V> queue;
    protected Set<V> checked;
    protected Map<V, Set<V>> mapNodeCircle;
    protected int[] nodesOnLevel;
    protected int levelnumber;
    public static final String ALG_ID = "TDAG";

    public DAGLayoutAlgorithm(Graph<V, E> graph) {
        this.g = graph;
        this.minusLevels = 0;
        this.nodenum = this.g.getVertexCount();
        this.checked = new HashSet<V>();
        this.mapNodeCircle = new HashMap<V, Set<V>>();
        this.level = new HashMap<V, Integer>();
        this.isolateNodes = new HashSet<V>();
        this.arcs = new HashMap<V, Integer>();
        this.mapCircleArcs = new HashMap<Set<V>, Integer>();
        this.queue = new PriorityQueue(this.nodenum, new Comparator<V>(){

            @Override
            public int compare(V v, V w) {
                int priorw;
                int priorv = DAGLayoutAlgorithm.this.arcs.get(v);
                if (priorv < (priorw = DAGLayoutAlgorithm.this.arcs.get(w).intValue())) {
                    return -1;
                }
                if (priorv == priorw) {
                    return 0;
                }
                return 1;
            }
        });
        this.levelnumber = 0;
    }

    @Override
    public void run() {
        this.init();
        this.runAlgorithm();
        this.createLevelNumbers();
    }

    protected void createLevelNumbers() {
        this.nodesOnLevel = new int[this.levelnumber + 1];
        for (int i = 0; i < this.levelnumber + 1; ++i) {
            this.nodesOnLevel[i] = 0;
        }
        if (!this.isolateNodes.isEmpty()) {
            this.nodesOnLevel[0] = this.isolateNodes.size();
        }
        Iterator<Integer> iterator = this.level.values().iterator();
        while (iterator.hasNext()) {
            int i;
            int n = i = iterator.next().intValue();
            this.nodesOnLevel[n] = this.nodesOnLevel[n] + 1;
        }
    }

    protected void init() {
        Collection vertices = this.g.getVertices();
        HashSet complexVerticses = new HashSet();
        for (Object v : vertices) {
            if (this.getInDegree(v) == 0 && this.getOutDegree(v) == 0) {
                this.isolateNodes.add(v);
                this.minusLevels = 1;
                continue;
            }
            complexVerticses.add(v);
        }
        for (Object v : complexVerticses) {
            this.level.put((Integer)v, this.minusLevels);
            this.arcs.put((Integer)v, this.getInDegree(v));
            this.queue.offer(v);
        }
    }

    protected void runAlgorithm() {
        while (!this.queue.isEmpty()) {
            V v = this.queue.poll();
            if (this.arcs.get(v) == 0) {
                this.checkNonCircle(v);
                continue;
            }
            this.checkCircle(v);
        }
    }

    protected void checkNonCircle(V v) {
        this.checked.add(v);
        for (E e : this.getOutEdges(v)) {
            V w = this.getDest(e);
            this.updateNode(w, this.level.get(v));
        }
    }

    protected void checkCircle(V v) {
        Set<V> circle = this.detectCircles(v);
        int circleLevel = 0;
        for (V w : circle) {
            int currentLevel = this.level.get(w);
            if (currentLevel <= circleLevel) continue;
            circleLevel = currentLevel;
        }
        int foundArcs = 0;
        for (V u : circle) {
            this.level.put((Integer)u, circleLevel);
            this.mapNodeCircle.put((Set<V>)u, (Set<Set<V>>)circle);
            for (E e : this.getInEdges(u)) {
                V w = this.getSource(e);
                if (this.checked.contains(w) || circle.contains(w)) continue;
                ++foundArcs;
            }
            this.queue.remove(u);
        }
        if (foundArcs == 0) {
            this.finalizeCircle(circle, circleLevel);
        }
        this.mapCircleArcs.put(circle, foundArcs);
    }

    protected Set<V> detectCircles(V v) {
        HashSet<V> seenForward = new HashSet<V>();
        HashSet seenBackward = new HashSet();
        this.dfsSeeForward(v, seenForward);
        this.dfsSeeBackward(v, seenBackward);
        seenForward.retainAll(seenBackward);
        seenForward.add(v);
        return seenForward;
    }

    protected void finalizeCircle(Set<V> circle, int circleLevel) {
        for (V u : circle) {
            this.checked.add(u);
            for (E e : this.getOutEdges(u)) {
                V w = this.getDest(e);
                if (circle.contains(w)) continue;
                this.updateNode(w, circleLevel);
            }
        }
    }

    protected void updateNode(V w, int parentLevel) {
        int newLevel;
        boolean isnewlevel;
        int oldLevel = this.level.get(w);
        if (oldLevel > parentLevel + 1) {
            isnewlevel = false;
            newLevel = oldLevel;
        } else {
            isnewlevel = true;
            newLevel = parentLevel + 1;
        }
        if (newLevel > this.levelnumber) {
            this.levelnumber = newLevel;
        }
        if (this.mapNodeCircle.containsKey(w)) {
            Set<V> circle = this.mapNodeCircle.get(w);
            this.mapCircleArcs.put(circle, this.mapCircleArcs.get(circle) - 1);
            if (isnewlevel) {
                for (V u : circle) {
                    this.level.put((Integer)u, newLevel);
                }
            }
            if (this.mapCircleArcs.get(circle) == 0) {
                this.finalizeCircle(circle, newLevel);
            }
        } else {
            this.level.put((Integer)w, newLevel);
            this.arcs.put((Integer)w, this.arcs.get(w) - 1);
            this.queue.remove(w);
            this.queue.offer(w);
        }
    }

    protected void dfsSee(V source, Set<V> set, boolean forward) {
        LinkedList<V> current = new LinkedList<V>();
        current.add(source);
        while (!current.isEmpty()) {
            Object v = current.removeLast();
            set.add(v);
            for (E e : this.getDirectedEdges(v, forward)) {
                V w = this.getNodeOfDirectedEdge(e, forward);
                if (set.contains(w)) continue;
                current.add(w);
            }
        }
        set.remove(source);
    }

    protected void dfsSeeForward(V source, Set<V> set) {
        this.dfsSee(source, set, true);
    }

    protected void dfsSeeBackward(V source, Set<V> set) {
        this.dfsSee(source, set, false);
    }

    protected Collection<E> getDirectedEdges(V v, boolean forward) {
        if (forward) {
            return this.g.getOutEdges(v);
        }
        return this.g.getInEdges(v);
    }

    protected V getNodeOfDirectedEdge(E e, boolean forward) {
        if (forward) {
            return (V)this.g.getDest(e);
        }
        return (V)this.g.getSource(e);
    }

    @Override
    public Map<V, Integer> getLevels() {
        return this.level;
    }

    @Override
    public int getNumberOfLevels() {
        return this.levelnumber + 1;
    }

    @Override
    public int[] getNumberOfNodesPerLevel() {
        return this.nodesOnLevel;
    }

    @Override
    public Set<V> getIsolateNodes() {
        return this.isolateNodes;
    }

    protected int getInDegree(V v) {
        return this.g.inDegree(v);
    }

    protected int getOutDegree(V v) {
        return this.g.outDegree(v);
    }

    protected Collection<E> getInEdges(V v) {
        return this.g.getInEdges(v);
    }

    protected Collection<E> getOutEdges(V v) {
        return this.g.getOutEdges(v);
    }

    protected V getSource(E e) {
        return (V)this.g.getSource(e);
    }

    protected V getDest(E e) {
        return (V)this.g.getDest(e);
    }
}

