/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.dnssec.validator;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.jitsi.dnssec.SecurityStatus;
import org.jitsi.dnssec.validator.KeyEntry;
import org.xbill.DNS.Name;

public class KeyCache {
    public static final String MAX_TTL_CONFIG = "org.jitsi.dnssec.keycache.max_ttl";
    public static final String MAX_CACHE_SIZE_CONFIG = "org.jitsi.dnssec.keycache.max_size";
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private static final int DEFAULT_MAX_TTL = 900;
    private static final int DEFAULT_MAX_CACHE_SIZE = 1000;
    private Map<String, CacheEntry> cache = Collections.synchronizedMap(new LinkedHashMap<String, CacheEntry>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CacheEntry> eldest) {
            return this.size() >= KeyCache.this.maxCacheSize;
        }
    });
    private long maxTtl = 900L;
    private int maxCacheSize = 1000;

    public void init(Properties config) {
        if (config == null) {
            return;
        }
        String s = config.getProperty(MAX_TTL_CONFIG);
        if (s != null) {
            this.maxTtl = Long.parseLong(s);
        }
        if ((s = config.getProperty(MAX_CACHE_SIZE_CONFIG)) != null) {
            this.maxCacheSize = Integer.parseInt(s);
        }
    }

    public KeyEntry find(Name n, int dclass) {
        while (n.labels() > 0) {
            String k = this.key(n, dclass);
            KeyEntry entry = this.lookupEntry(k);
            if (entry != null) {
                return entry;
            }
            n = new Name(n, 1);
        }
        return null;
    }

    public KeyEntry store(KeyEntry ke) {
        if (ke.getRRset() != null) {
            if (ke.getRRset().getType() != 48) {
                return ke;
            }
            if (ke.getRRset().getSecurityStatus() != SecurityStatus.SECURE) {
                return ke;
            }
        }
        String k = this.key(ke.getName(), ke.getDClass());
        CacheEntry ce = new CacheEntry(ke, this.maxTtl);
        this.cache.put(k, ce);
        return ke;
    }

    private String key(Name n, int dclass) {
        return "K" + dclass + "/" + n;
    }

    private KeyEntry lookupEntry(String key) {
        CacheEntry centry = this.cache.get(key);
        if (centry == null) {
            return null;
        }
        if (centry.expiration.before(new Date())) {
            this.cache.remove(key);
            return null;
        }
        return centry.keyEntry;
    }

    private static class CacheEntry {
        private Date expiration;
        private KeyEntry keyEntry;

        public CacheEntry(KeyEntry keyEntry, long maxTtl) {
            long ttl = keyEntry.getTTL();
            if (ttl > maxTtl) {
                ttl = maxTtl;
            }
            this.expiration = new Date(System.currentTimeMillis() + ttl * 1000L);
            this.keyEntry = keyEntry;
        }
    }
}

