/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.domain;

import java.util.Objects;
import org.eclipse.iot.tiaki.utils.ValidatorUtil;

public final class Fqdn {
    private static final String DNS_SD_QUOTED = "\"%s\"";
    private final String entityLabel;
    private final String domain;

    public Fqdn(String domain) {
        this("", domain);
    }

    public Fqdn(String entityLabel, String domain) {
        ValidatorUtil.isValidDomainName(domain.endsWith(".") ? domain : domain + ".");
        ValidatorUtil.check(entityLabel != null);
        this.entityLabel = entityLabel.trim();
        this.domain = domain.trim();
    }

    public String fqdn() {
        return this.buildFQDN("");
    }

    public String fqdnWithPrefix(String prefix) {
        String builtFqdn = this.buildFQDN("");
        if (builtFqdn.contains(prefix)) {
            return builtFqdn;
        }
        return this.buildFQDN(prefix);
    }

    public String label() {
        return this.entityLabel;
    }

    public String domain() {
        return this.domain;
    }

    private String buildFQDN(String prefix) {
        StringBuilder builder = new StringBuilder();
        if (prefix != null && !prefix.isEmpty()) {
            builder.append(prefix);
            if (!builder.toString().endsWith(".")) {
                builder.append(".");
            }
        }
        if (!this.entityLabel.isEmpty()) {
            builder.append(this.entityLabel);
            if (!builder.toString().endsWith(".")) {
                builder.append(".");
            }
        }
        builder.append(this.domain);
        if (!this.domain.endsWith(".")) {
            builder.append(".");
        }
        ValidatorUtil.isValidDomainName(builder.toString());
        if (ValidatorUtil.isDnsSdDomainName(builder.toString())) {
            return String.format(DNS_SD_QUOTED, builder.toString());
        }
        return builder.toString();
    }

    public String toString() {
        return this.buildFQDN("");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Fqdn other = (Fqdn)obj;
        if (!Objects.equals(this.entityLabel, other.entityLabel)) {
            return false;
        }
        return Objects.equals(this.domain, other.domain);
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + Objects.hashCode(this.entityLabel);
        hash = 47 * hash + Objects.hashCode(this.domain);
        return hash;
    }
}

