/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.domain;

import java.util.Objects;

public abstract class DiscoveryRecord
implements Comparable<DiscoveryRecord> {
    protected final String owner;
    protected final String rData;
    protected final long ttl;

    public DiscoveryRecord() {
        this("", 0L);
    }

    public DiscoveryRecord(String rData, long ttl) {
        this("N/A", rData, ttl);
    }

    public DiscoveryRecord(String owner, String rData, long ttl) {
        this.owner = owner;
        this.rData = rData;
        this.ttl = ttl;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getRData() {
        return this.rData;
    }

    public long getTtl() {
        return this.ttl;
    }

    public abstract String getServiceType();

    public abstract String getServiceZone(String var1);

    public abstract String getServiceName(String var1);

    public abstract String toDisplay();

    @Override
    public int compareTo(DiscoveryRecord t) {
        return this.rData.compareTo(t.getRData());
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.rData);
        hash = 97 * hash + (int)(this.ttl ^ this.ttl >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscoveryRecord other = (DiscoveryRecord)obj;
        if (!Objects.equals(this.rData, other.rData)) {
            return false;
        }
        return this.ttl == other.ttl;
    }

    public String toString() {
        return String.format("%d %s", this.ttl, this.rData);
    }
}

