/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.ui;

import java.util.List;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swtbot.generator.framework.Generator;
import org.eclipse.swtbot.generator.framework.IRecorderDialog;
import org.eclipse.swtbot.generator.listener.WorkbenchListener;
import org.eclipse.swtbot.generator.ui.BotGeneratorEventDispatcher;
import org.eclipse.swtbot.generator.ui.GeneratorExtensionPointManager;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class StartupRecorder
implements IStartup {
    public static final String ENABLEMENT_PROPERTY = "org.eclipse.swtbot.generator.enable";
    public static final String DIALOG_PROPERTY = "org.eclipse.swtbot.generator.dialog";
    private static final int[] monitoredEvents = new int[]{26, 21, 13, 17, 24, 3, 8, 1, 21};

    public void earlyStartup() {
        if (!Boolean.parseBoolean(System.getProperty(ENABLEMENT_PROPERTY))) {
            return;
        }
        StartupRecorder.openRecorder(null);
    }

    public static IRecorderDialog openRecorder(String dialog) {
        Display display = Display.getDefault();
        StartRecorderRunnable recorderStarter = new StartRecorderRunnable(display);
        if (dialog == null && System.getProperty(DIALOG_PROPERTY) != null) {
            dialog = System.getProperty(DIALOG_PROPERTY);
        }
        recorderStarter.setRecorderDialog(dialog);
        display.syncExec((Runnable)recorderStarter);
        return recorderStarter.getRecorderDialog();
    }

    private static final class StartRecorderRunnable
    implements Runnable {
        private final Display display;
        private String recorderDialogId;
        private IRecorderDialog recorderDialog;

        private StartRecorderRunnable(Display display) {
            this.display = display;
        }

        public void setRecorderDialog(String dialog) {
            this.recorderDialogId = dialog;
        }

        public void run() {
            IWorkbenchPage page;
            List<Generator> availableGenerators = GeneratorExtensionPointManager.loadGenerators();
            Generator generator = availableGenerators.get(0);
            final BotGeneratorEventDispatcher dispatcher = new BotGeneratorEventDispatcher();
            dispatcher.setGenerator(generator);
            int[] nArray = monitoredEvents;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int monitoredEvent = nArray[n2];
                this.display.addFilter(monitoredEvent, (Listener)dispatcher);
                ++n2;
            }
            if (PlatformUI.isWorkbenchRunning() && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
                page.addPartListener((IPartListener2)new WorkbenchListener(dispatcher));
            }
            if (this.recorderDialogId == null || this.recorderDialogId.isEmpty()) {
                List<IRecorderDialog> dialogs = GeneratorExtensionPointManager.loadDialogs();
                this.recorderDialog = dialogs.get(0);
            } else {
                List<IRecorderDialog> dialogs = GeneratorExtensionPointManager.loadDialogs();
                boolean foundRecorderClass = false;
                int i = 0;
                while (!foundRecorderClass && dialogs.size() > i) {
                    if (dialogs.get(i).getId().equals(this.recorderDialogId)) {
                        foundRecorderClass = true;
                        this.recorderDialog = dialogs.get(i);
                    }
                    ++i;
                }
            }
            dispatcher.ignoreShells(this.recorderDialog.getIgnoredShells());
            this.recorderDialog.setAvailableGenerators(availableGenerators);
            this.recorderDialog.setRecorder(dispatcher);
            this.recorderDialog.open();
            this.recorderDialog.getShell().addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent e) {
                    int[] nArray = monitoredEvents;
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int monitoredEvent = nArray[n2];
                        StartRecorderRunnable.this.display.removeFilter(monitoredEvent, (Listener)dispatcher);
                        ++n2;
                    }
                }
            });
        }

        public IRecorderDialog getRecorderDialog() {
            return this.recorderDialog;
        }
    }
}

