/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.systemtap.ui.graphingapi.ui.GraphingAPIUIPlugin;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.IUpdateListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.swtchart.Chart;
import org.swtchart.ITitle;

public abstract class AbstractChartBuilder
extends Composite
implements IUpdateListener {
    protected static final String FONT_NAME = "MS Sans Serif";
    protected int maxItems;
    protected double scale = 1.0;
    protected IAdapter adapter = null;
    protected int xseries;
    protected int[] yseries;
    protected static final Color WHITE = new Color((Device)Display.getDefault(), 255, 255, 255);
    protected static final Color BLACK = new Color((Device)Display.getDefault(), 0, 0, 0);
    protected static final Color RED = new Color((Device)Display.getDefault(), 255, 0, 0);
    protected static final Color[] COLORS = new Color[]{new Color((Device)Display.getDefault(), 255, 0, 0), new Color((Device)Display.getDefault(), 0, 255, 0), new Color((Device)Display.getDefault(), 0, 0, 255), new Color((Device)Display.getDefault(), 255, 255, 0), new Color((Device)Display.getDefault(), 255, 0, 255), new Color((Device)Display.getDefault(), 0, 255, 255), new Color((Device)Display.getDefault(), 0, 0, 0), new Color((Device)Display.getDefault(), 64, 128, 128), new Color((Device)Display.getDefault(), 255, 165, 0), new Color((Device)Display.getDefault(), 128, 128, 128)};
    protected Chart chart = null;
    protected String title = null;

    public AbstractChartBuilder(IAdapter adapter, Composite parent, int style, String title) {
        super(parent, style);
        this.adapter = adapter;
        this.title = title;
        this.setLayout((Layout)new FillLayout());
        IPreferenceStore store = GraphingAPIUIPlugin.getDefault().getPreferenceStore();
        this.maxItems = Math.min(store.getInt("ViewableDataItems"), store.getInt("MaxDataItems"));
    }

    public void build() {
        this.createChart();
        this.buildPlot();
        this.buildLegend();
        this.buildTitle();
        this.buildXAxis();
        this.buildYAxis();
        this.buildXSeries();
        this.buildYSeries();
        this.updateDataSet();
    }

    protected void createChart() {
        this.chart = new Chart((Composite)this, this.getStyle());
    }

    protected void buildPlot() {
        this.chart.setBackground(WHITE);
        this.chart.setBackgroundInPlotArea(WHITE);
    }

    protected void buildXAxis() {
    }

    protected void buildYAxis() {
    }

    protected void buildXSeries() {
    }

    protected void buildYSeries() {
    }

    protected void buildLegend() {
        this.chart.getLegend().setPosition(131072);
    }

    protected void buildTitle() {
        ITitle ctitle = this.chart.getTitle();
        ctitle.setForeground(BLACK);
        ctitle.setText(this.title);
    }

    public Chart getChart() {
        return this.chart;
    }

    public void updateDataSet() {
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.handleUpdateEvent();
    }

    protected double getDoubleValue(Object o) {
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        return new Double(o.toString());
    }

    public void handleUpdateEvent() {
        try {
            this.repaint();
        }
        catch (Exception exception) {}
    }

    protected void repaint() {
        this.getDisplay().syncExec(new Runnable(){
            boolean stop = false;

            public void run() {
                if (this.stop) {
                    return;
                }
                try {
                    AbstractChartBuilder.this.updateDataSet();
                }
                catch (Exception exception) {
                    this.stop = true;
                }
            }
        });
    }
}

